/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.fife.ui.RColorButton;

public class RColorSwatchesButton
extends RColorButton {
    private static final long serialVersionUID = 1L;
    private static final Dimension SWATCH_MENUITEM_SIZE = new Dimension(24, 24);
    private static final int NUM_COLUMNS = 6;
    private static final String MSG = "org.fife.ui.RColorSwatchesButton";
    private static final Color[] predefinedColors = new Color[]{Color.RED, new Color(255, 128, 128), new Color(255, 153, 0), new Color(204, 102, 0), Color.ORANGE, new Color(255, 240, 204), Color.YELLOW, new Color(255, 255, 164), new Color(148, 148, 0), new Color(188, 188, 40), new Color(0, 128, 0), Color.GREEN, new Color(48, 255, 47), new Color(218, 254, 218), new Color(0, 128, 164), Color.BLUE, Color.CYAN, new Color(231, 231, 255), Color.PINK, new Color(255, 224, 240), Color.MAGENTA, new Color(173, 0, 128), new Color(128, 0, 0), new Color(100, 0, 200), Color.WHITE, new Color(224, 224, 224), Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};
    private ColorPopupMenu popup;
    private PopupListener popupListener;

    public RColorSwatchesButton() {
        this(Color.BLACK);
    }

    public RColorSwatchesButton(Color color) {
        super(color);
    }

    public RColorSwatchesButton(Color color, int width, int height) {
        super(color, width, height);
    }

    public ActionListener createActionListener() {
        return new SwatchesActionListener();
    }

    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            this.popup.updateUI();
            ((JComponent)this.popup.getComponent(this.popup.getComponentCount() - 1)).updateUI();
        }
    }

    private static class SwatchMenuItemUI
    extends BasicMenuItemUI {
        public SwatchMenuItemUI() {
            String prefix = this.getPropertyPrefix();
            UIManager.put(prefix + ".borderPainted", Boolean.FALSE);
        }

        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
            return this.getPreferredSize(c);
        }

        public Dimension getPreferredSize(JComponent c) {
            return SWATCH_MENUITEM_SIZE;
        }

        public void paint(Graphics g, JComponent c) {
            JMenuItem menuItem = (JMenuItem)c;
            ButtonModel model = menuItem.getModel();
            g.setColor(UIManager.getColor("MenuItem.background"));
            Rectangle bounds = c.getBounds();
            g.fillRect(0, 0, bounds.width, bounds.height);
            if (model.isArmed()) {
                g.setColor(Color.BLACK);
                g.drawRect(1, 1, bounds.width - 3, bounds.height - 3);
            }
            Icon icon = menuItem.getIcon();
            int x = (bounds.width - icon.getIconWidth()) / 2;
            int y = (bounds.height - icon.getIconHeight()) / 2;
            icon.paintIcon(menuItem, g, x, y);
        }
    }

    protected class PopupListener
    extends RColorButton.RColorButtonActionListener {
        protected PopupListener() {
            super(RColorSwatchesButton.this);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)source;
                Icon icon = item.getIcon();
                if (icon != null) {
                    RColorButton.ColorIcon colorIcon = (RColorButton.ColorIcon)icon;
                    Color color = colorIcon.getColor();
                    RColorSwatchesButton.this.setColor(color);
                } else {
                    e.setSource(RColorSwatchesButton.this);
                    super.actionPerformed(e);
                }
            }
        }
    }

    private class ColorPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public ColorPopupMenu() {
            RColorSwatchesButton.this.popupListener = new PopupListener();
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            int length = predefinedColors.length;
            for (int i = 0; i < length; i += 6) {
                c.fill = 1;
                c.weightx = 1.0;
                c.gridwidth = 1;
                for (int j = 0; j < 5; ++j) {
                    this.addSwatch(predefinedColors[i + j], layout, c);
                }
                c.gridwidth = 0;
                this.addSwatch(predefinedColors[i + 6 - 1], layout, c);
            }
            ResourceBundle msg = ResourceBundle.getBundle(RColorSwatchesButton.MSG);
            c.weightx = 0.0;
            JMenuItem item = new JMenuItem(msg.getString("MoreColors.txt"));
            item.addActionListener(RColorSwatchesButton.this.popupListener);
            layout.setConstraints(item, c);
            this.add(item);
            this.pack();
        }

        private void addSwatch(Color color, GridBagLayout gridbag, GridBagConstraints c) {
            JMenuItem item = new JMenuItem(new RColorButton.ColorIcon(color, 16, 16));
            item.setUI(new SwatchMenuItemUI());
            item.setToolTipText(this.createToolTipText(color));
            item.setUI(new SwatchMenuItemUI());
            item.addActionListener(RColorSwatchesButton.this.popupListener);
            gridbag.setConstraints(item, c);
            this.add(item);
        }

        private String createToolTipText(Color color) {
            return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
        }
    }

    private class SwatchesActionListener
    implements ActionListener {
        private SwatchesActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (RColorSwatchesButton.this.popup == null) {
                RColorSwatchesButton.this.popup = new ColorPopupMenu();
                RColorSwatchesButton.this.popup.applyComponentOrientation(RColorSwatchesButton.this.getComponentOrientation());
            }
            RColorSwatchesButton.this.popup.show(RColorSwatchesButton.this, 0, 0 + RColorSwatchesButton.this.getHeight());
        }
    }
}

