/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff;

import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;

public class ColumnDifference {
    private String tableName = "";
    private String columnName = "";
    private int col1Type = -1;
    private int col2Type = -1;
    private int col1Length = 0;
    private int col2Length = 0;
    private boolean col1IsNullable = false;
    private boolean col2IsNullable = false;
    private boolean col1Exists = true;
    private boolean col2Exists = true;
    private String col1remarks = "";
    private String col2remarks = "";
    private String col1default = "";
    private String col2default = "";

    public void setColumns(TableColumnInfo c1, TableColumnInfo c2) {
        if (c1 == null || c2 == null) {
            throw new IllegalArgumentException("c1, c2 cannot be null");
        }
        if (!c1.getColumnName().equals(c2.getColumnName())) {
            throw new IllegalArgumentException("Columns to be compared must have the same column name");
        }
        this.setColumn1(c1);
        this.setColumn2(c2);
    }

    public void setColumn1(TableColumnInfo c1) {
        this.col1Type = c1.getDataType();
        this.col1Length = c1.getColumnSize();
        this.col1IsNullable = !c1.isNullable().equalsIgnoreCase("NO");
        this.tableName = c1.getTableName();
        this.columnName = c1.getColumnName();
        this.col1remarks = c1.getRemarks();
        this.col1default = c1.getDefaultValue();
    }

    public void setColumn2(TableColumnInfo c2) {
        this.col2Type = c2.getDataType();
        this.col2Length = c2.getColumnSize();
        this.col2IsNullable = !c2.isNullable().equalsIgnoreCase("NO");
        this.tableName = c2.getTableName();
        this.columnName = c2.getColumnName();
        this.col2remarks = c2.getRemarks();
        this.col2default = c2.getDefaultValue();
    }

    public int getCol1Type() {
        return this.col1Type;
    }

    public int getCol1Length() {
        return this.col1Length;
    }

    public boolean col1AllowsNull() {
        return this.col1IsNullable;
    }

    public int getCol2Type() {
        return this.col2Type;
    }

    public int getCol2Length() {
        return this.col2Length;
    }

    public boolean col2AllowsNull() {
        return this.col2IsNullable;
    }

    public String getCol1Remarks() {
        return this.col1remarks;
    }

    public String getCol2Remarks() {
        return this.col2remarks;
    }

    public String getCol1Default() {
        return this.col1default;
    }

    public String getCol2Default() {
        return this.col2default;
    }

    public boolean execute() {
        if (!this.col1Exists || !this.col2Exists) {
            return true;
        }
        if (this.col1Type != this.col2Type) {
            return true;
        }
        if (this.col1Length != this.col2Length) {
            return true;
        }
        if (this.col1IsNullable != this.col2IsNullable) {
            return true;
        }
        return !this.remarksEqual();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCol1Exists(boolean col1Exists) {
        this.col1Exists = col1Exists;
    }

    public boolean isCol1Exists() {
        return this.col1Exists;
    }

    public void setCol2Exists(boolean col2Exists) {
        this.col2Exists = col2Exists;
    }

    public boolean isCol2Exists() {
        return this.col2Exists;
    }

    public boolean defaultsEqual() {
        if (this.col1default == null && this.col2default == null) {
            return true;
        }
        if (this.col1default == null && this.col2default != null || this.col1default != null && this.col2default == null) {
            return false;
        }
        return this.col1default.equals(this.col2default);
    }

    public boolean remarksEqual() {
        if (this.col1remarks == null && this.col2remarks == null) {
            return true;
        }
        if (this.col1remarks == null && this.col2remarks != null || this.col1remarks != null && this.col2remarks == null) {
            return false;
        }
        return this.col1remarks.equals(this.col2remarks);
    }

    public boolean typesEqual() {
        return this.col1Type == this.col2Type;
    }

    public boolean lengthsEqual() {
        return this.col1Length == this.col2Length;
    }

    public boolean nullableEqual() {
        return this.col1IsNullable == this.col2IsNullable;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TABLE: ");
        result.append(this.tableName);
        result.append(" COLUMN: ");
        result.append(this.columnName);
        result.append("\n");
        result.append("source colType: ");
        result.append(this.col1Type);
        result.append("\n");
        result.append("dest colType: ");
        result.append(this.col2Type);
        result.append("\n");
        result.append("source colLength: ");
        result.append(this.col1Length);
        result.append("\n");
        result.append("dest colLength: ");
        result.append(this.col2Length);
        result.append("\n");
        result.append("source IsNullable: ");
        result.append(this.col1IsNullable);
        result.append("\n");
        result.append("dest IsNullable: ");
        result.append(this.col2IsNullable);
        result.append("\n");
        return result.toString();
    }
}

