/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

class ComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    ComboBoxButton() {
        super("");
        DefaultButtonModel model = new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        };
        this.setModel(model);
        this.setBackground(UIManager.getColor("Button.background"));
        this.setForeground(UIManager.getColor("Button.foreground"));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    public ComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list) {
        this();
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public ComboBoxButton(JComboBox cb, Icon i, boolean iconOnly, CellRendererPane pane, JList list) {
        this(cb, i, pane, list);
        this.iconOnly = iconOnly;
    }

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        g.drawLine(0, 0, 0, this.getHeight() - 1);
        int delta = 0;
        if (this.model.isArmed() && this.model.isPressed()) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(1, 0, this.getWidth() - 1, 0);
            g.drawLine(1, 0, 1, this.getHeight() - 1);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(1, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            delta = 1;
        }
        if (this.comboIcon != null) {
            int iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            this.comboIcon.paintIcon(this, g, this.getWidth() / 2 - iconWidth / 2 + delta, this.getHeight() / 2 - iconHeight / 2 + delta);
        }
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }
}

