/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.StringUtils;

public class PropertyPathFactoryBean
implements FactoryBean,
BeanNameAware,
BeanFactoryAware {
    private BeanWrapper targetBeanWrapper;
    private String targetBeanName;
    private String propertyPath;
    private Class resultType;
    private String beanName;
    private BeanFactory beanFactory;

    public void setTargetObject(Object targetObject) {
        this.targetBeanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(targetObject);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = StringUtils.trimAllWhitespace((String)targetBeanName);
    }

    public void setPropertyPath(String propertyPath) {
        this.propertyPath = StringUtils.trimAllWhitespace((String)propertyPath);
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    public void setBeanName(String beanName) {
        this.beanName = StringUtils.trimAllWhitespace((String)BeanFactoryUtils.originalBeanName(beanName));
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (this.targetBeanWrapper != null && this.targetBeanName != null) {
            throw new IllegalArgumentException("Specify either 'targetObject' or 'targetBeanName', not both");
        }
        if (this.targetBeanWrapper == null && this.targetBeanName == null) {
            if (this.propertyPath != null) {
                throw new IllegalArgumentException("Specify 'targetObject' or 'targetBeanName' in combination with 'propertyPath'");
            }
            int dotIndex = this.beanName.indexOf(46);
            if (dotIndex == -1) {
                throw new IllegalArgumentException("Neither 'targetObject' nor 'targetBeanName' specified, and PropertyPathFactoryBean bean name '" + this.beanName + "' does not follow 'beanName.property' syntax");
            }
            this.targetBeanName = this.beanName.substring(0, dotIndex);
            this.propertyPath = this.beanName.substring(dotIndex + 1);
        } else if (this.propertyPath == null) {
            throw new IllegalArgumentException("'propertyPath' is required");
        }
        if (this.targetBeanWrapper == null && this.beanFactory.isSingleton(this.targetBeanName)) {
            Object bean = this.beanFactory.getBean(this.targetBeanName);
            this.targetBeanWrapper = PropertyAccessorFactory.forBeanPropertyAccess(bean);
            this.resultType = this.targetBeanWrapper.getPropertyType(this.propertyPath);
        }
    }

    public Object getObject() throws BeansException {
        BeanWrapper target = this.targetBeanWrapper;
        if (target == null) {
            Object bean = this.beanFactory.getBean(this.targetBeanName);
            target = PropertyAccessorFactory.forBeanPropertyAccess(bean);
        }
        return target.getPropertyValue(this.propertyPath);
    }

    public Class getObjectType() {
        return this.resultType;
    }

    public boolean isSingleton() {
        return false;
    }
}

