/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferencesFrameStarter;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.RootTable;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowReferencesCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowReferencesCommand.class);
    private final JTable _table;
    private final IDataSetUpdateableModel _updateableModel;
    private JFrame _owningFrame;

    public ShowReferencesCommand(JTable table, IDataSetUpdateableModel updateableModel, JFrame owningFrame) {
        this._table = table;
        this._updateableModel = updateableModel;
        this._owningFrame = owningFrame;
    }

    public void execute() {
        ResultMetaDataTable buf;
        ITableInfo ti;
        ResultMetaDataTable globalDbTable = null;
        if (this._updateableModel instanceof IDataSetUpdateableTableModel && null != (ti = ((IDataSetUpdateableTableModel)this._updateableModel).getTableInfo())) {
            globalDbTable = new ResultMetaDataTable(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
        }
        ArrayList<InStatColumnInfo> inStatColumnInfos = new TableCopyInStatementCommand(this._table).getInStatColumnInfos();
        if (null == globalDbTable && null != (buf = this.findTable(inStatColumnInfos))) {
            globalDbTable = buf;
        }
        if (null == globalDbTable) {
            JOptionPane.showMessageDialog(this._owningFrame, s_stringMgr.getString("ShowReferencesCommand.noTable"));
            return;
        }
        ReferencesFrameStarter.showReferences(new RootTable(globalDbTable, inStatColumnInfos), this._updateableModel.getSession(), this._owningFrame);
    }

    private ResultMetaDataTable findTable(ArrayList<InStatColumnInfo> inStatColumnInfos) {
        ResultMetaDataTable ret = null;
        for (InStatColumnInfo inStatColumnInfo : inStatColumnInfos) {
            ResultMetaDataTable buf = inStatColumnInfo.getColDef().getResultMetaDataTable();
            if (null == ret) {
                ret = buf;
                continue;
            }
            if (ret.getQualifiedName().equalsIgnoreCase(buf.getQualifiedName())) continue;
            return null;
        }
        return ret;
    }
}

