/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkCommand;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPlugin;

public class RunBookmarkAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final long serialVersionUID = 1L;
    private transient ISession session;
    private transient SQLBookmarkPlugin plugin;

    public RunBookmarkAction(IApplication app, IResources resources, SQLBookmarkPlugin plugin) throws IllegalArgumentException {
        super(app, resources);
        if (plugin == null) {
            throw new IllegalArgumentException("null IPlugin passed");
        }
        this.plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source;
        if (this.session != null && (source = evt.getSource()) instanceof JMenuItem) {
            ISQLEntryPanel sqlEntryPanel;
            JMenuItem item = (JMenuItem)source;
            Bookmark bookmark = this.plugin.getBookmarkManager().get(item.getText());
            if (this.session.getActiveSessionWindow() instanceof SessionInternalFrame) {
                sqlEntryPanel = ((SessionInternalFrame)this.session.getActiveSessionWindow()).getSQLPanelAPI().getSQLEntryPanel();
            } else if (this.session.getActiveSessionWindow() instanceof SQLInternalFrame) {
                sqlEntryPanel = ((SQLInternalFrame)this.session.getActiveSessionWindow()).getSQLPanelAPI().getSQLEntryPanel();
            } else {
                return;
            }
            if (bookmark != null) {
                new RunBookmarkCommand(this.getParentFrame(evt), this.session, bookmark, this.plugin, sqlEntryPanel).execute();
            }
        }
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this.session = null != panel ? panel.getSession() : null;
        this.setEnabled(null != this.session);
    }
}

