/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.blocktree.Lucene40FieldReader;
import org.apache.lucene.codecs.blocktree.Lucene40IntersectTermsEnumFrame;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;

@Deprecated
final class Lucene40IntersectTermsEnum
extends TermsEnum {
    final IndexInput in;
    static final Outputs<BytesRef> fstOutputs = ByteSequenceOutputs.getSingleton();
    private Lucene40IntersectTermsEnumFrame[] stack;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[5];
    final RunAutomaton runAutomaton;
    final CompiledAutomaton compiledAutomaton;
    private Lucene40IntersectTermsEnumFrame currentFrame;
    private final BytesRef term = new BytesRef();
    private final FST.BytesReader fstReader;
    final Lucene40FieldReader fr;
    private BytesRef savedStartTerm;

    public Lucene40IntersectTermsEnum(Lucene40FieldReader fr, CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        this.fr = fr;
        this.runAutomaton = compiled.runAutomaton;
        this.compiledAutomaton = compiled;
        this.in = fr.parent.in.clone();
        this.stack = new Lucene40IntersectTermsEnumFrame[5];
        for (int idx = 0; idx < this.stack.length; ++idx) {
            this.stack[idx] = new Lucene40IntersectTermsEnumFrame(this, idx);
        }
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.fstReader = fr.index == null ? null : fr.index.getBytesReader();
        FST.Arc arc = fr.index.getFirstArc(this.arcs[0]);
        assert (arc.isFinal());
        Lucene40IntersectTermsEnumFrame f = this.stack[0];
        f.fp = f.fpOrig = fr.rootBlockFP;
        f.prefix = 0;
        f.setState(this.runAutomaton.getInitialState());
        f.arc = arc;
        f.outputPrefix = (BytesRef)arc.output;
        f.load(fr.rootCode);
        assert (this.setSavedStartTerm(startTerm));
        this.currentFrame = f;
        if (startTerm != null) {
            this.seekToStartTerm(startTerm);
        }
    }

    private boolean setSavedStartTerm(BytesRef startTerm) {
        this.savedStartTerm = startTerm == null ? null : BytesRef.deepCopyOf((BytesRef)startTerm);
        return true;
    }

    public TermState termState() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.clone();
    }

    private Lucene40IntersectTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            Lucene40IntersectTermsEnumFrame[] next = new Lucene40IntersectTermsEnumFrame[ArrayUtil.oversize((int)(1 + ord), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new Lucene40IntersectTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.oversize((int)(1 + ord), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next.length; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        return this.arcs[ord];
    }

    private Lucene40IntersectTermsEnumFrame pushFrame(int state) throws IOException {
        Lucene40IntersectTermsEnumFrame f = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord);
        f.fp = f.fpOrig = this.currentFrame.lastSubFP;
        f.prefix = this.currentFrame.prefix + this.currentFrame.suffix;
        f.setState(state);
        FST.Arc arc = this.currentFrame.arc;
        assert (this.currentFrame.suffix > 0);
        BytesRef output = this.currentFrame.outputPrefix;
        for (int idx = this.currentFrame.prefix; idx < f.prefix; ++idx) {
            int target = this.term.bytes[idx] & 0xFF;
            arc = this.fr.index.findTargetArc(target, arc, this.getArc(1 + idx), this.fstReader);
            assert (arc != null);
            output = (BytesRef)fstOutputs.add((Object)output, arc.output);
        }
        f.arc = arc;
        f.outputPrefix = output;
        assert (arc.isFinal());
        f.load((BytesRef)fstOutputs.add((Object)output, arc.nextFinalOutput));
        return f;
    }

    public BytesRef term() {
        return this.term;
    }

    public int docFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.docFreq;
    }

    public long totalTermFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.totalTermFreq;
    }

    public PostingsEnum postings(Bits skipDocs, PostingsEnum reuse, int flags) throws IOException {
        if (PostingsEnum.featureRequested((int)flags, (short)16384) && this.fr.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            return null;
        }
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.termState, skipDocs, reuse, flags);
    }

    private int getState() {
        int state = this.currentFrame.state;
        for (int idx = 0; idx < this.currentFrame.suffix; ++idx) {
            state = this.runAutomaton.step(state, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + idx] & 0xFF);
            assert (state != -1);
        }
        return state;
    }

    private void seekToStartTerm(BytesRef target) throws IOException {
        assert (this.currentFrame.ord == 0);
        if (this.term.length < target.length) {
            this.term.bytes = ArrayUtil.grow((byte[])this.term.bytes, (int)target.length);
        }
        FST.Arc<BytesRef> arc = this.arcs[0];
        assert (arc == this.currentFrame.arc);
        for (int idx = 0; idx <= target.length; ++idx) {
            block8: {
                int cmp;
                int saveTermBlockOrd;
                long saveLastSubFP;
                int saveSuffix;
                int saveStartBytePos;
                int savePos;
                block9: {
                    while (true) {
                        savePos = this.currentFrame.suffixesReader.getPosition();
                        saveStartBytePos = this.currentFrame.startBytePos;
                        saveSuffix = this.currentFrame.suffix;
                        saveLastSubFP = this.currentFrame.lastSubFP;
                        saveTermBlockOrd = this.currentFrame.termState.termBlockOrd;
                        boolean isSubBlock = this.currentFrame.next();
                        this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                        if (this.term.bytes.length < this.term.length) {
                            this.term.bytes = ArrayUtil.grow((byte[])this.term.bytes, (int)this.term.length);
                        }
                        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                        if (isSubBlock && StringHelper.startsWith((BytesRef)target, (BytesRef)this.term)) break block8;
                        cmp = this.term.compareTo(target);
                        if (cmp >= 0) break block9;
                        if (this.currentFrame.nextEnt != this.currentFrame.entCount) continue;
                        if (this.currentFrame.isLastInFloor) break;
                        this.currentFrame.loadNextFloorBlock();
                    }
                    return;
                }
                if (cmp == 0) {
                    return;
                }
                --this.currentFrame.nextEnt;
                this.currentFrame.lastSubFP = saveLastSubFP;
                this.currentFrame.startBytePos = saveStartBytePos;
                this.currentFrame.suffix = saveSuffix;
                this.currentFrame.suffixesReader.setPosition(savePos);
                this.currentFrame.termState.termBlockOrd = saveTermBlockOrd;
                System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                return;
            }
            this.currentFrame = this.pushFrame(this.getState());
        }
        assert (false);
    }

    public BytesRef next() throws IOException {
        block0: while (true) {
            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                if (!this.currentFrame.isLastInFloor) {
                    this.currentFrame.loadNextFloorBlock();
                    continue;
                }
                if (this.currentFrame.ord == 0) {
                    return null;
                }
                long lastFP = this.currentFrame.fpOrig;
                this.currentFrame = this.stack[this.currentFrame.ord - 1];
                assert (this.currentFrame.lastSubFP == lastFP);
                continue;
            }
            boolean isSubBlock = this.currentFrame.next();
            if (this.currentFrame.suffix != 0) {
                int label = this.currentFrame.suffixBytes[this.currentFrame.startBytePos] & 0xFF;
                while (label > this.currentFrame.curTransitionMax) {
                    if (this.currentFrame.transitionIndex >= this.currentFrame.transitionCount - 1) {
                        this.currentFrame.isLastInFloor = true;
                        this.currentFrame.nextEnt = this.currentFrame.entCount;
                        continue block0;
                    }
                    ++this.currentFrame.transitionIndex;
                    this.compiledAutomaton.automaton.getNextTransition(this.currentFrame.transition);
                    this.currentFrame.curTransitionMax = this.currentFrame.transition.max;
                }
            }
            if (this.compiledAutomaton.commonSuffixRef != null && !isSubBlock) {
                int suffixBytesPos;
                int termLen = this.currentFrame.prefix + this.currentFrame.suffix;
                if (termLen < this.compiledAutomaton.commonSuffixRef.length) continue;
                byte[] suffixBytes = this.currentFrame.suffixBytes;
                byte[] commonSuffixBytes = this.compiledAutomaton.commonSuffixRef.bytes;
                int lenInPrefix = this.compiledAutomaton.commonSuffixRef.length - this.currentFrame.suffix;
                assert (this.compiledAutomaton.commonSuffixRef.offset == 0);
                int commonSuffixBytesPos = 0;
                if (lenInPrefix > 0) {
                    byte[] termBytes = this.term.bytes;
                    int termBytesPos = this.currentFrame.prefix - lenInPrefix;
                    assert (termBytesPos >= 0);
                    int termBytesPosEnd = this.currentFrame.prefix;
                    while (termBytesPos < termBytesPosEnd) {
                        if (termBytes[termBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                        continue block0;
                    }
                    suffixBytesPos = this.currentFrame.startBytePos;
                } else {
                    suffixBytesPos = this.currentFrame.startBytePos + this.currentFrame.suffix - this.compiledAutomaton.commonSuffixRef.length;
                }
                int commonSuffixBytesPosEnd = this.compiledAutomaton.commonSuffixRef.length;
                while (commonSuffixBytesPos < commonSuffixBytesPosEnd) {
                    if (suffixBytes[suffixBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                    continue block0;
                }
            }
            int state = this.currentFrame.state;
            for (int idx = 0; idx < this.currentFrame.suffix; ++idx) {
                if ((state = this.runAutomaton.step(state, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + idx] & 0xFF)) == -1) continue block0;
            }
            if (isSubBlock) {
                this.copyTerm();
                this.currentFrame = this.pushFrame(state);
                continue;
            }
            if (this.runAutomaton.isAccept(state)) break;
        }
        this.copyTerm();
        assert (this.savedStartTerm == null || this.term.compareTo(this.savedStartTerm) > 0) : "saveStartTerm=" + this.savedStartTerm.utf8ToString() + " term=" + this.term.utf8ToString();
        return this.term;
    }

    private void copyTerm() {
        int len = this.currentFrame.prefix + this.currentFrame.suffix;
        if (this.term.bytes.length < len) {
            this.term.bytes = ArrayUtil.grow((byte[])this.term.bytes, (int)len);
        }
        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
        this.term.length = len;
    }

    public boolean seekExact(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    public long ord() {
        throw new UnsupportedOperationException();
    }

    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }
}

