/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.gui.dictionaries.IDictionaries;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

public class DictionariesManager
implements DirectoryMonitor.Callback {
    public static final String IGNORE_FILE = "ignore.txt";
    private final IDictionaries pane;
    protected DirectoryMonitor monitor;
    protected final List<IDictionaryFactory> factories = new ArrayList<IDictionaryFactory>();
    protected final Map<String, IDictionary> dictionaries = new TreeMap<String, IDictionary>();
    protected final List<IDictionary> onlineDictionaries = new ArrayList<IDictionary>();
    protected final Set<String> ignoreWords = new TreeSet<String>();
    private Language indexLanguage;
    private ITokenizer tokenizer;

    public DictionariesManager(IDictionaries pane) {
        this.pane = pane;
        this.indexLanguage = new Language(Locale.getDefault());
        this.tokenizer = new DefaultTokenizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDictionaryFactory(IDictionaryFactory dict) {
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            this.factories.add(dict);
        }
        if (this.monitor != null) {
            this.monitor.fin();
            this.start(this.monitor.getDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDictionaryFactory(IDictionaryFactory factory) {
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            this.factories.remove(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnlineDictionary(IDictionary dict) {
        List<IDictionary> list = this.onlineDictionaries;
        synchronized (list) {
            this.onlineDictionaries.add(dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnlineDictionary(IDictionary dict) {
        List<IDictionary> list = this.onlineDictionaries;
        synchronized (list) {
            this.onlineDictionaries.remove(dict);
        }
    }

    public void start(File dictDir) {
        this.monitor = new DirectoryMonitor(dictDir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            this.dictionaries.values().forEach(this::closeDict);
            this.dictionaries.clear();
        }
    }

    private void closeDict(IDictionary dict) {
        try {
            dict.close();
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        Map<String, IDictionary> map = this.dictionaries;
        synchronized (map) {
            IDictionary dict = this.dictionaries.get(file.getPath());
            if (dict != null) {
                this.closeDict(dict);
            }
            this.dictionaries.remove(file.getPath());
        }
        if (!file.exists()) {
            return;
        }
        try {
            long st = System.currentTimeMillis();
            if (file.getName().equals(IGNORE_FILE)) {
                this.loadIgnoreWords(file);
            } else if (this.loadDictionary(file)) {
                long en = System.currentTimeMillis();
                Log.log("Loaded dictionary from '" + file.getPath() + "': " + (en - st) + "ms");
            }
        }
        catch (Exception ex) {
            Log.log("Error load dictionary from '" + file.getPath() + "': " + ex.getMessage());
        }
        this.pane.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDictionary(File file) throws Exception {
        ArrayList<IDictionaryFactory> currFactories;
        if (!file.isFile()) {
            return false;
        }
        List<IDictionaryFactory> list = this.factories;
        synchronized (list) {
            currFactories = new ArrayList<IDictionaryFactory>(this.factories);
        }
        for (IDictionaryFactory factory : currFactories) {
            if (!factory.isSupportedFile(file)) continue;
            IDictionary dict = factory.loadDict(file, this.indexLanguage);
            DictionariesManager dictionariesManager = this;
            synchronized (dictionariesManager) {
                this.dictionaries.put(file.getPath(), dict);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIgnoreWords(File file) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            this.ignoreWords.clear();
            lines.stream().map(String::trim).forEach(line -> this.ignoreWords.add((String)line));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreWord(String word) {
        List<String> words = Collections.emptyList();
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            this.ignoreWords.add(word);
            words = new ArrayList<String>(this.ignoreWords);
        }
        if (this.monitor != null) {
            DictionariesManager.saveIgnoreWords(words, new File(this.monitor.getDir(), IGNORE_FILE));
        }
    }

    private static void saveIgnoreWords(Collection<String> words, File outFile) {
        try {
            File outFileTmp = new File(outFile.getPath() + ".new");
            Files.write(outFileTmp.toPath(), words, new OpenOption[0]);
            outFile.delete();
            FileUtil.rename(outFileTmp, outFile);
        }
        catch (IOException ex) {
            Log.log("Error saving ignore words");
            Log.log(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIgnoreWord(String word) {
        Set<String> set = this.ignoreWords;
        synchronized (set) {
            return this.ignoreWords.contains(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DictionaryEntry> findWords(Collection<String> words) {
        ArrayList<IDictionary> dicts;
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            dicts = new ArrayList<IDictionary>(this.dictionaries.values());
            dicts.addAll(this.onlineDictionaries);
        }
        Collection queryWords = words.stream().filter(word -> !this.isIgnoreWord((String)word) && !this.isStopWord((String)word)).collect(Collectors.toList());
        return dicts.parallelStream().map(dict -> this.doLookUp((IDictionary)dict, queryWords)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DictionaryEntry> doLookUp(IDictionary dict, Collection<String> words) {
        List<DictionaryEntry> result;
        try {
            result = dict.retrieveArticles(words);
        }
        catch (Exception ex) {
            Log.log(ex);
            return Collections.emptyList();
        }
        if (!this.doFuzzyMatching()) {
            return result;
        }
        try {
            ArrayList<String> notFound = new ArrayList<String>(words);
            notFound.removeAll(result.stream().map(DictionaryEntry::getQuery).collect(Collectors.toSet()));
            ArrayList<String> predictive = new ArrayList<String>();
            for (String word : notFound) {
                String[] stemmed = this.tokenizer.tokenizeWordsToStrings(word, ITokenizer.StemmingMode.MATCHING);
                if (stemmed.length <= 1) continue;
                predictive.add(stemmed[0]);
            }
            if (predictive.size() > 0) {
                result.addAll(dict.retrieveArticlesPredictive(predictive));
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
        return result;
    }

    private boolean isStopWord(String word) {
        String[] stemmed = this.tokenizer.tokenizeWordsToStrings(word, ITokenizer.StemmingMode.MATCHING);
        return stemmed.length == 0;
    }

    public void setIndexLanguage(Language indexLanguage) {
        this.indexLanguage = indexLanguage;
    }

    public void setTokenizer(ITokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public boolean doFuzzyMatching() {
        return Preferences.isPreferenceDefault("dictionary_fuzzy_matching", true);
    }

    public String[] getStemmedWords(String word) {
        return this.tokenizer.tokenizeWordsToStrings(word, ITokenizer.StemmingMode.MATCHING);
    }
}

