/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.flash;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.flash.FlashDialect;
import org.omegat.util.OStrings;

public class FlashFilter
extends XMLFilter {
    public FlashFilter() {
        super(new FlashDialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("FLASH_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public boolean isFileSupported(BufferedReader reader) {
        try {
            char[] cbuf = new char[65536];
            int cbufLen = reader.read(cbuf);
            String buf = new String(cbuf, 0, cbufLen);
            Matcher matcher = FlashDialect.FLASH_XMLNS.matcher(buf);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

