/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class HttpConnectionUtils {
    protected static final String DEFAULT_RESPONSE_CHARSET = "ISO-8859-1";
    protected static final String CHARSET_MARK = "charset=";
    private static final int BUFFER_SIZE = 8196;
    private static final int TIMEOUT_MS = 10000;
    private static final String REGEX_URL = "(?:https?|ftp)://(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*\\.[a-z\\u00a1-\\uffff]{2,}\\.?)(?::\\d{2,5})?(?:[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|])?";
    public static final Pattern URL_PATTERN = Pattern.compile("(?:https?|ftp)://(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*\\.[a-z\\u00a1-\\uffff]{2,}\\.?)(?::\\d{2,5})?(?:[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|])?", 2);
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("\\bhttps?://\\S+\\b", 2);
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\bfile://[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    private static final URLCodec codec = new URLCodec(StandardCharsets.UTF_8.name());

    private HttpConnectionUtils() {
    }

    public static String getURL(URL url) throws IOException {
        return HttpConnectionUtils.getURL(url, 10000);
    }

    public static String getURL(URL url, int timeout) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setConnectTimeout(timeout);
        urlConn.setReadTimeout(timeout);
        try (InputStream in = urlConn.getInputStream();){
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void downloadZipFileAndExtract(URL url, File dir, List<String> expectedFiles) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try (InputStream in = conn.getInputStream();){
            List<String> extracted = StaticUtils.extractFromZip(in, dir, expectedFiles::contains);
            if (!expectedFiles.containsAll(extracted)) {
                throw new FileNotFoundException("Could not extract expected files from zip; expected: " + expectedFiles + ", extracted: " + extracted);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new FlakyDownloadException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean downloadBinaryFile(URL fileURL, Map<String, String> headers, Set<String> expectedMime, File saveFilePath) throws IOException, FlakyDownloadException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getURLasByteArray(String target) throws IOException {
        URL url = new URL(target);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200) {
            return null;
        }
        try {
            byte[] byArray;
            block10: {
                InputStream in = conn.getInputStream();
                try {
                    byArray = IOUtils.toByteArray((InputStream)in);
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String post(String address, Map<String, String> params) throws IOException {
        return HttpConnectionUtils.post(address, params, null);
    }

    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        return HttpConnectionUtils.get(address, params, additionalHeaders, DEFAULT_RESPONSE_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String address, Map<String, String> params, Map<String, String> additionalHeaders, String defaultOutputCharset) throws IOException {
        String url;
        if (params == null || params.isEmpty()) {
            url = address;
        } else {
            StringBuilder s = new StringBuilder();
            s.append(address).append('?');
            boolean next = false;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (next) {
                    s.append('&');
                } else {
                    next = true;
                }
                s.append(p.getKey());
                s.append('=');
                s.append(URLEncoder.encode(p.getValue(), StandardCharsets.UTF_8.name()));
            }
            url = s.toString();
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            conn.setRequestMethod("GET");
            if (additionalHeaders != null) {
                for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                    conn.setRequestProperty(en.getKey(), en.getValue());
                }
            }
            HttpConnectionUtils.addProxyAuthentication(conn);
            conn.setDoOutput(true);
            String string = HttpConnectionUtils.getStringContent(conn, defaultOutputCharset);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String post(String address, Map<String, String> params, Map<String, String> additionalHeaders) throws IOException {
        URL url = new URL(address);
        ByteArrayOutputStream pout = new ByteArrayOutputStream();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (pout.size() > 0) {
                    pout.write(38);
                }
                pout.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                pout.write(61);
                pout.write(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8));
            }
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(pout.size()));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        HttpConnectionUtils.addProxyAuthentication(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        try {
            String string;
            block14: {
                OutputStream outputStream = conn.getOutputStream();
                try {
                    outputStream.write(pout.toByteArray());
                    outputStream.flush();
                    string = HttpConnectionUtils.getStringContent(conn);
                    if (outputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String postJSON(String address, String json, Map<String, String> additionalHeaders) throws IOException {
        URL url = new URL(address);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", Integer.toString(json.length()));
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> en : additionalHeaders.entrySet()) {
                conn.setRequestProperty(en.getKey(), en.getValue());
            }
        }
        HttpConnectionUtils.addProxyAuthentication(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        try {
            String string;
            block11: {
                OutputStream cout = conn.getOutputStream();
                try {
                    cout.write(json.getBytes(StandardCharsets.UTF_8));
                    cout.flush();
                    string = HttpConnectionUtils.getStringContent(conn, "utf-8");
                    if (cout == null) break block11;
                }
                catch (Throwable throwable) {
                    if (cout != null) {
                        try {
                            cout.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cout.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private static void addProxyAuthentication(HttpURLConnection conn) {
        String encodedUser = Preferences.getPreference("proxy_user_name");
        if (!StringUtil.isEmpty(encodedUser)) {
            String encodedPassword = Preferences.getPreference("proxy_password");
            try {
                String userPass = StringUtil.decodeBase64(encodedUser, StandardCharsets.ISO_8859_1) + ":" + StringUtil.decodeBase64(encodedPassword, StandardCharsets.ISO_8859_1);
                String encodedUserPass = Base64.getMimeEncoder().encodeToString(userPass.getBytes(StandardCharsets.ISO_8859_1));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPass);
            }
            catch (IllegalArgumentException ex) {
                Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
                Log.log(ex);
            }
        }
    }

    private static String getStringContent(HttpURLConnection conn) throws IOException {
        return HttpConnectionUtils.getStringContent(conn, DEFAULT_RESPONSE_CHARSET);
    }

    private static String getStringContent(HttpURLConnection conn, String defaultCharset) throws IOException {
        if (conn.getResponseCode() != 200) {
            throw new ResponseError(conn);
        }
        String contentType = conn.getHeaderField("Content-Type");
        int cp = contentType != null ? contentType.indexOf(CHARSET_MARK) : -1;
        String charset = cp >= 0 ? contentType.substring(cp + CHARSET_MARK.length()) : defaultCharset;
        try (InputStream in = conn.getInputStream();){
            String string = IOUtils.toString((InputStream)in, (String)charset);
            return string;
        }
    }

    public static String encodeHttpURLs(String text) {
        UrlValidator urlValidator = new UrlValidator();
        StringBuilder result = new StringBuilder();
        Matcher m = HTTP_URL_PATTERN.matcher(text);
        int lastIndex = 0;
        while (m.find()) {
            String url = m.group();
            if (urlValidator.isValid(url)) continue;
            try {
                URI uri = new URI(url);
                String encodedPath = HttpConnectionUtils.encodePath(uri.getRawPath());
                String encodedQuery = HttpConnectionUtils.encodeQuery(uri.getRawQuery());
                result.append(text, lastIndex, m.start());
                result.append(uri.getScheme()).append("://").append(uri.getAuthority());
                if (uri.getRawUserInfo() != null) {
                    result.append(uri.getRawUserInfo()).append("@");
                }
                if (!StringUtil.isEmpty(encodedPath)) {
                    result.append(encodedPath);
                }
                if (!StringUtil.isEmpty(encodedQuery)) {
                    result.append("?").append(encodedQuery);
                }
                if (uri.getRawFragment() != null) {
                    result.append("#").append(uri.getRawFragment());
                }
            }
            catch (URISyntaxException | EncoderException ex) {
                result.append(url);
            }
            lastIndex = m.end();
        }
        result.append(text.substring(lastIndex));
        return result.toString();
    }

    public static String encodeURIComponent(String component) throws EncoderException {
        if (component == null) {
            return null;
        }
        return codec.encode(component);
    }

    public static String encodePath(String path) throws EncoderException {
        String[] pathSegments = path.split("/");
        StringBuilder encodedPath = new StringBuilder();
        for (String segment : pathSegments) {
            if (segment.isEmpty()) continue;
            encodedPath.append("/").append(codec.encode(segment));
        }
        return encodedPath.toString();
    }

    public static String encodeQuery(String query) throws EncoderException {
        if (query == null) {
            return null;
        }
        String[] querySegments = query.split("&");
        StringBuilder encodedQuery = new StringBuilder();
        for (int i = 0; i < querySegments.length; ++i) {
            String segment = querySegments[i];
            if (segment.isEmpty()) continue;
            if (i != 0) {
                encodedQuery.append("&");
            }
            String[] exp = segment.split("=");
            encodedQuery.append(codec.encode(exp[0])).append("=").append(codec.encode(exp[1]));
        }
        return encodedQuery.toString();
    }

    public static String decodeHttpURLs(String text) {
        UrlValidator urlValidator = new UrlValidator();
        StringBuilder result = new StringBuilder();
        Matcher m = HTTP_URL_PATTERN.matcher(text);
        int lastIndex = 0;
        while (m.find()) {
            String uri = m.group();
            if (!urlValidator.isValid(uri)) continue;
            result.append(text, lastIndex, m.start());
            try {
                result.append(codec.decode(uri));
            }
            catch (DecoderException ex) {
                result.append(uri);
            }
            lastIndex = m.end();
        }
        result.append(text.substring(lastIndex));
        return result.toString();
    }

    public static boolean checkUrl(String remoteUrl) {
        if (remoteUrl.isEmpty()) {
            return false;
        }
        UrlValidator urlValidator = new UrlValidator();
        return urlValidator.isValid(remoteUrl);
    }

    public static class ResponseError
    extends IOException {
        public final int code;
        public final String message;
        public final String body;

        public ResponseError(HttpURLConnection conn) throws IOException {
            super(conn.getResponseCode() + ": " + conn.getResponseMessage());
            this.code = conn.getResponseCode();
            this.message = conn.getResponseMessage();
            try (InputStream in = conn.getErrorStream();){
                this.body = IOUtils.toString((InputStream)in, (String)StandardCharsets.UTF_8.name());
            }
        }
    }

    public static class FlakyDownloadException
    extends RuntimeException {
        public FlakyDownloadException(Exception cause) {
            super(cause);
        }

        public FlakyDownloadException(String cause) {
            super(cause);
        }
    }
}

