/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.gosen.GosenBasicFormFilter;
import org.apache.lucene.analysis.gosen.GosenKatakanaStemFilter;
import org.apache.lucene.analysis.gosen.GosenPartOfSpeechStopFilter;
import org.apache.lucene.analysis.gosen.GosenPunctuationFilter;
import org.apache.lucene.analysis.gosen.GosenTokenizer;
import org.apache.lucene.analysis.gosen.GosenWidthFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;

public class GosenAnalyzer
extends StopwordAnalyzerBase {
    private final Set<String> stoptags;
    private final CharArraySet stemExclusionSet;
    private final String dictionaryDir;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public static Set<String> getDefaultStopTags() {
        return DefaultSetHolder.DEFAULT_STOP_TAGS;
    }

    public GosenAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS, CharArraySet.EMPTY_SET, null);
    }

    public GosenAnalyzer(String dictionaryDir) {
        this(DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS, CharArraySet.EMPTY_SET, dictionaryDir);
    }

    public GosenAnalyzer(CharArraySet stopwords, Set<String> stoptags, CharArraySet stemExclusionSet, String dictionaryDir) {
        super(stopwords);
        this.stoptags = stoptags;
        this.stemExclusionSet = stemExclusionSet;
        this.dictionaryDir = dictionaryDir;
    }

    protected Analyzer.TokenStreamComponents createComponents(String field) {
        GosenTokenizer tokenizer = new GosenTokenizer(null, this.dictionaryDir);
        Object stream = new GosenWidthFilter((TokenStream)tokenizer);
        stream = new GosenPunctuationFilter((TokenStream)stream);
        stream = new GosenPartOfSpeechStopFilter((TokenStream)stream, this.stoptags);
        stream = new StopFilter((TokenStream)stream, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            stream = new SetKeywordMarkerFilter((TokenStream)stream, this.stemExclusionSet);
        }
        stream = new GosenBasicFormFilter((TokenStream)stream);
        stream = new GosenKatakanaStemFilter((TokenStream)stream);
        stream = new LowerCaseFilter((TokenStream)stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = GosenAnalyzer.loadStopwordSet((boolean)false, (Class)GosenAnalyzer.class, (String)"stopwords_ja.txt", (String)"#");
                CharArraySet tagset = GosenAnalyzer.loadStopwordSet((boolean)false, (Class)GosenAnalyzer.class, (String)"stoptags_ja.txt", (String)"#");
                DEFAULT_STOP_TAGS = new HashSet<String>();
                for (Object element : tagset) {
                    char[] chars = (char[])element;
                    DEFAULT_STOP_TAGS.add(new String(chars));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

