/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.calculator.length;

import java.util.List;
import net.loomchild.maligna.calculator.length.LengthCalculator;
import net.loomchild.maligna.calculator.length.counter.Counter;

public class NormalDistributionCalculator
extends LengthCalculator {
    public static final float PARAMETER_C = 1.0f;
    public static final float PARAMETER_S_SQUARE = 6.8f;

    public NormalDistributionCalculator(Counter counter) {
        super(counter);
    }

    @Override
    protected float calculateLengthScore(List<Integer> sourceLengthList, List<Integer> targetLengthList) {
        int sourceSegmentLength = this.calculateTotalLength(sourceLengthList);
        int targetSegmentLength = this.calculateTotalLength(targetLengthList);
        return this.calculateScore(sourceSegmentLength, targetSegmentLength);
    }

    private float calculateScore(int sourceSegmentLength, int targetSegmentLength) {
        if (sourceSegmentLength == 0 && targetSegmentLength == 0) {
            return 0.0f;
        }
        double mean = (double)((float)sourceSegmentLength + (float)targetSegmentLength / 1.0f) / 2.0;
        double z = Math.abs((double)(1.0f * (float)sourceSegmentLength - (float)targetSegmentLength) / Math.sqrt((double)6.8f * mean));
        double pd = 2.0 * (1.0 - this.cumulativeNormalDistribution(z));
        pd = Math.max(pd, (double)1.4E-45f);
        assert (pd > 0.0);
        return (float)(-Math.log(pd));
    }

    private double cumulativeNormalDistribution(double z) {
        assert (z >= 0.0);
        double t = 1.0 / (1.0 + 0.2316419 * z);
        double pd = 1.0 - 0.3989423 * Math.exp(-z * z / 2.0) * ((((1.330274429 * t - 1.821255978) * t + 1.781477937) * t - 0.356563782) * t + 0.31938153) * t;
        return pd;
    }
}

