/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.aligner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;
import net.loomchild.maligna.filter.aligner.AlignmentImpossibleException;

public class UnifyAligner
implements Filter {
    private List<Alignment> referenceAlignmentList;

    public UnifyAligner(List<Alignment> referenceAlignmentList) {
        this.referenceAlignmentList = referenceAlignmentList;
    }

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        ArrayList<String> sourceSegmentList = new ArrayList<String>();
        ArrayList<String> targetSegmentList = new ArrayList<String>();
        for (Alignment alignment : alignmentList) {
            sourceSegmentList.addAll(alignment.getSourceSegmentList());
            targetSegmentList.addAll(alignment.getTargetSegmentList());
        }
        Iterator<String> sourceSegmentIterator = sourceSegmentList.iterator();
        Iterator<String> targetSegmentIterator = targetSegmentList.iterator();
        ArrayList<Alignment> newAlignmentList = new ArrayList<Alignment>(this.referenceAlignmentList.size());
        for (Alignment alignment : this.referenceAlignmentList) {
            List<String> newSourceSegmentList = this.getSegmentList(sourceSegmentIterator, alignment.getSourceSegmentList().size());
            List<String> newTargetSegmentList = this.getSegmentList(targetSegmentIterator, alignment.getTargetSegmentList().size());
            Alignment newAlignment = new Alignment(newSourceSegmentList, newTargetSegmentList, alignment.getScore());
            newAlignmentList.add(newAlignment);
        }
        return newAlignmentList;
    }

    private List<String> getSegmentList(Iterator<String> segmentIterator, int size) {
        ArrayList<String> segmentList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            try {
                String segment = segmentIterator.next();
                segmentList.add(segment);
                continue;
            }
            catch (NoSuchElementException e) {
                throw new AlignmentImpossibleException("Segment counts in input and reference alignment lists are not equal.");
            }
        }
        return segmentList;
    }
}

