import java.io.IOException;
import java.io.OutputStream;
import java.io.FileOutputStream;
import org.xml.sax.SAXException;
import com.sun.xml.tree.XmlDocument;

import com.jclark.xsl.dom.Transform;
import com.jclark.xsl.dom.TransformEngine;
import com.jclark.xsl.dom.TransformException;
import com.jclark.xsl.dom.XSLTransformEngine;

/**
 * This is a demo of using the simple, pure DOM API to XT.
 * It uses Sun's DOM implementation (Project X TR2).
 */

class DOMDemo {
  public static void main(String[] args)
    throws IOException, SAXException, TransformException {
    if (args.length != 3) {
      System.err.println("usage: java DOMDemo sourceURL stylesheetURL resultFile");
      System.exit(1);
    }
    
    XmlDocument result = new XmlDocument();
    new XSLTransformEngine()
      .createTransform(XmlDocument.createXmlDocument(args[1]))
      .transform(XmlDocument.createXmlDocument(args[0]),
		 result);
    OutputStream out = new FileOutputStream(args[2]);
    result.write(out);
    out.close();
  }
}
