/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnNameHelper {
    private static List<ByteBuffer> maybeGrow(List<ByteBuffer> l, int size) {
        if (l.size() >= size) {
            return l;
        }
        ArrayList<ByteBuffer> nl = new ArrayList<ByteBuffer>(size);
        nl.addAll(l);
        for (int i = l.size(); i < size; ++i) {
            nl.add(null);
        }
        return nl;
    }

    private static List<ByteBuffer> getComponents(Composite prefix, int size) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            l.add(prefix.get(i));
        }
        return l;
    }

    public static List<ByteBuffer> maxComponents(List<ByteBuffer> maxSeen, Composite candidate, CellNameType comparator) {
        int size = Math.min(candidate.size(), comparator.clusteringPrefixSize());
        if (maxSeen.isEmpty()) {
            return ColumnNameHelper.getComponents(candidate, size);
        }
        maxSeen = ColumnNameHelper.maybeGrow(maxSeen, size);
        for (int i = 0; i < size; ++i) {
            maxSeen.set(i, ColumnNameHelper.max(maxSeen.get(i), candidate.get(i), comparator.subtype(i)));
        }
        return maxSeen;
    }

    public static List<ByteBuffer> minComponents(List<ByteBuffer> minSeen, Composite candidate, CellNameType comparator) {
        int size = Math.min(candidate.size(), comparator.clusteringPrefixSize());
        if (minSeen.isEmpty()) {
            return ColumnNameHelper.getComponents(candidate, size);
        }
        minSeen = ColumnNameHelper.maybeGrow(minSeen, size);
        for (int i = 0; i < size; ++i) {
            minSeen.set(i, ColumnNameHelper.min(minSeen.get(i), candidate.get(i), comparator.subtype(i)));
        }
        return minSeen;
    }

    private static ByteBuffer min(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (comparator.compare(b1, b2) >= 0) {
            return b2;
        }
        return b1;
    }

    private static ByteBuffer max(ByteBuffer b1, ByteBuffer b2, AbstractType<?> comparator) {
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (comparator.compare(b1, b2) >= 0) {
            return b1;
        }
        return b2;
    }

    public static List<ByteBuffer> mergeMin(List<ByteBuffer> minColumnNames, List<ByteBuffer> candidates, CellNameType comparator) {
        if (minColumnNames.isEmpty()) {
            return ColumnNameHelper.minimalBuffersFor(candidates);
        }
        if (candidates.isEmpty()) {
            return minColumnNames;
        }
        List<ByteBuffer> biggest = minColumnNames.size() > candidates.size() ? minColumnNames : candidates;
        List<ByteBuffer> smallest = minColumnNames.size() > candidates.size() ? candidates : minColumnNames;
        List<ByteBuffer> retList = smallest.size() == biggest.size() ? new ArrayList<ByteBuffer>(smallest) : ColumnNameHelper.maybeGrow(smallest, biggest.size());
        for (int i = 0; i < biggest.size(); ++i) {
            retList.set(i, ByteBufferUtil.minimalBufferFor(ColumnNameHelper.min(retList.get(i), biggest.get(i), comparator.subtype(i))));
        }
        return retList;
    }

    private static List<ByteBuffer> minimalBuffersFor(List<ByteBuffer> candidates) {
        ArrayList<ByteBuffer> minimalBuffers = new ArrayList<ByteBuffer>(candidates.size());
        for (ByteBuffer byteBuffer : candidates) {
            minimalBuffers.add(ByteBufferUtil.minimalBufferFor(byteBuffer));
        }
        return minimalBuffers;
    }

    public static List<ByteBuffer> mergeMax(List<ByteBuffer> maxColumnNames, List<ByteBuffer> candidates, CellNameType comparator) {
        if (maxColumnNames.isEmpty()) {
            return ColumnNameHelper.minimalBuffersFor(candidates);
        }
        if (candidates.isEmpty()) {
            return maxColumnNames;
        }
        List<ByteBuffer> biggest = maxColumnNames.size() > candidates.size() ? maxColumnNames : candidates;
        List<ByteBuffer> smallest = maxColumnNames.size() > candidates.size() ? candidates : maxColumnNames;
        List<ByteBuffer> retList = smallest.size() == biggest.size() ? new ArrayList<ByteBuffer>(smallest) : ColumnNameHelper.maybeGrow(smallest, biggest.size());
        for (int i = 0; i < biggest.size(); ++i) {
            retList.set(i, ByteBufferUtil.minimalBufferFor(ColumnNameHelper.max(retList.get(i), biggest.get(i), comparator.subtype(i))));
        }
        return retList;
    }

    public static boolean overlaps(List<ByteBuffer> minColumnNames1, List<ByteBuffer> maxColumnNames1, List<ByteBuffer> minColumnNames2, List<ByteBuffer> maxColumnNames2, CellNameType comparator) {
        if (minColumnNames1.isEmpty() || maxColumnNames1.isEmpty() || minColumnNames2.isEmpty() || maxColumnNames2.isEmpty()) {
            return true;
        }
        return ColumnNameHelper.compare(maxColumnNames1, minColumnNames2, comparator) >= 0 && ColumnNameHelper.compare(minColumnNames1, maxColumnNames2, comparator) <= 0;
    }

    private static int compare(List<ByteBuffer> columnNames1, List<ByteBuffer> columnNames2, CellNameType comparator) {
        for (int i = 0; i < Math.min(columnNames1.size(), columnNames2.size()); ++i) {
            int cmp = comparator.subtype(i).compare(columnNames1.get(i), columnNames2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

