/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CommonInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;

public final class HDF5LinkInformation
extends HDF5CommonInformation {
    static final HDF5LinkInformation ROOT_LINK_INFO = new HDF5LinkInformation("/", HDF5ObjectType.GROUP, null);
    private final String symbolicLinkTargetOrNull;

    private HDF5LinkInformation(String path, HDF5ObjectType type, String symbolicLinkTargetOrNull) {
        super(path, type);
        this.symbolicLinkTargetOrNull = symbolicLinkTargetOrNull;
    }

    static HDF5LinkInformation create(String path, int typeId, String symbolicLinkTargetOrNull) {
        HDF5ObjectType type = HDF5LinkInformation.objectTypeIdToObjectType(typeId);
        return new HDF5LinkInformation(path, type, symbolicLinkTargetOrNull);
    }

    public String tryGetSymbolicLinkTarget() {
        return this.symbolicLinkTargetOrNull;
    }

    public boolean isSoftLink() {
        return HDF5ObjectType.isSoftLink(this.type);
    }

    public boolean isExternalLink() {
        return HDF5ObjectType.isExternalLink(this.type);
    }

    public boolean isSymbolicLink() {
        return HDF5ObjectType.isSymbolicLink(this.type);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5LinkInformation other = (HDF5LinkInformation)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

