/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0014\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J\u0014\u0010\u0014\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/AudioSubscription;", "", "<init>", "()V", "latestSubscription", "Lorg/jitsi/videobridge/message/ReceiverAudioSubscriptionMessage;", "wantedSsrcs", "", "", "updateSubscription", "", "subscription", "sources", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "isSsrcWanted", "", "ssrc", "onConferenceSourceAdded", "descs", "onConferenceSourceRemoved", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAudioSubscription.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSubscription.kt\norg/jitsi/videobridge/AudioSubscription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n766#2:83\n857#2,2:84\n1549#2:86\n1620#2,3:87\n819#2:90\n847#2,2:91\n1549#2:93\n1620#2,3:94\n766#2:97\n857#2,2:98\n1549#2:100\n1620#2,3:101\n819#2:104\n847#2,2:105\n1549#2:107\n1620#2,3:108\n1549#2:111\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 AudioSubscription.kt\norg/jitsi/videobridge/AudioSubscription\n*L\n35#1:83\n35#1:84,2\n37#1:86\n37#1:87,3\n40#1:90\n40#1:91,2\n42#1:93\n42#1:94,3\n60#1:97\n60#1:98,2\n62#1:100\n62#1:101,3\n69#1:104\n69#1:105,2\n71#1:107\n71#1:108,3\n79#1:111\n79#1:112,3\n*E\n"})
public final class AudioSubscription {
    @NotNull
    private ReceiverAudioSubscriptionMessage latestSubscription = ReceiverAudioSubscriptionMessage.All.INSTANCE;
    @NotNull
    private Set<Long> wantedSsrcs = SetsKt.emptySet();

    /*
     * WARNING - void declaration
     */
    public final void updateSubscription(@NotNull ReceiverAudioSubscriptionMessage subscription, @NotNull List<AudioSourceDesc> sources) {
        Intrinsics.checkNotNullParameter(subscription, "subscription");
        Intrinsics.checkNotNullParameter(sources, "sources");
        this.latestSubscription = subscription;
        ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage = subscription;
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.All) {
            return;
        }
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.None) {
            return;
        }
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.Include) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AudioSourceDesc desc;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = sources;
            AudioSubscription audioSubscription = this;
            boolean $i$f$filter = false;
            void var6_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                desc = (AudioSourceDesc)element$iv$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)((ReceiverAudioSubscriptionMessage.Include)subscription).getList(), desc.getSourceName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                desc = (AudioSourceDesc)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getSsrc());
            }
            audioSubscription.wantedSsrcs = CollectionsKt.toSet((List)destination$iv$iv);
        } else if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.Exclude) {
            AudioSourceDesc desc;
            Iterable $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Iterable $this$map$iv = sources;
            AudioSubscription audioSubscription = this;
            boolean $i$f$filterNot = false;
            void $this$mapTo$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                desc = (AudioSourceDesc)element$iv$iv;
                boolean bl = false;
                if (CollectionsKt.contains((Iterable)((ReceiverAudioSubscriptionMessage.Exclude)subscription).getList(), desc.getSourceName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                desc = (AudioSourceDesc)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getSsrc());
            }
            audioSubscription.wantedSsrcs = CollectionsKt.toSet((List)destination$iv$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final boolean isSsrcWanted(long ssrc) {
        ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage = this.latestSubscription;
        return receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.All ? true : (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.None ? false : this.wantedSsrcs.contains(ssrc));
    }

    /*
     * WARNING - void declaration
     */
    public final void onConferenceSourceAdded(@NotNull Set<AudioSourceDesc> descs) {
        Intrinsics.checkNotNullParameter(descs, "descs");
        ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage = this.latestSubscription;
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.All) {
            return;
        }
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.None) {
            return;
        }
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.Include) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AudioSourceDesc desc;
            void $this$filterTo$iv$iv;
            ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage2 = this.latestSubscription;
            Intrinsics.checkNotNull(receiverAudioSubscriptionMessage2, "null cannot be cast to non-null type org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage.Include");
            ReceiverAudioSubscriptionMessage.Include subscription = (ReceiverAudioSubscriptionMessage.Include)receiverAudioSubscriptionMessage2;
            Iterable $this$filter$iv = descs;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                desc = (AudioSourceDesc)element$iv$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)subscription.getList(), desc.getSourceName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                desc = (AudioSourceDesc)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getSsrc());
            }
            Set newSsrcs = CollectionsKt.toSet((List)destination$iv$iv);
            this.wantedSsrcs = CollectionsKt.union((Iterable)this.wantedSsrcs, newSsrcs);
            return;
        }
        if (receiverAudioSubscriptionMessage instanceof ReceiverAudioSubscriptionMessage.Exclude) {
            void $this$map$iv;
            AudioSourceDesc desc;
            void $this$filterNotTo$iv$iv;
            ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage3 = this.latestSubscription;
            Intrinsics.checkNotNull(receiverAudioSubscriptionMessage3, "null cannot be cast to non-null type org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage.Exclude");
            ReceiverAudioSubscriptionMessage.Exclude subscription = (ReceiverAudioSubscriptionMessage.Exclude)receiverAudioSubscriptionMessage3;
            Iterable $this$filterNot$iv = descs;
            boolean $i$f$filterNot = false;
            Iterable $this$mapTo$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                desc = (AudioSourceDesc)element$iv$iv;
                boolean bl = false;
                if (CollectionsKt.contains((Iterable)subscription.getList(), desc.getSourceName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                desc = (AudioSourceDesc)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getSsrc());
            }
            Set newSsrcs = CollectionsKt.toSet((List)destination$iv$iv);
            this.wantedSsrcs = CollectionsKt.union((Iterable)this.wantedSsrcs, newSsrcs);
            return;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final void onConferenceSourceRemoved(@NotNull Set<AudioSourceDesc> descs) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(descs, "descs");
        Iterable iterable = descs;
        Iterable iterable2 = this.wantedSsrcs;
        AudioSubscription audioSubscription = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AudioSourceDesc audioSourceDesc = (AudioSourceDesc)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getSsrc());
        }
        collection = (List)destination$iv$iv;
        audioSubscription.wantedSsrcs = CollectionsKt.subtract(iterable2, CollectionsKt.toSet((Iterable)collection));
    }
}

