/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    private static final String INDICATOR_TITLE = "Updating Database...";
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull DbDataSource dataSource, @Nullable SearchPath searchPath) {
        if (dataSource == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(0);
        }
        super(DGDepartment.REFACTORING, dataSource, searchPath, INDICATOR_TITLE);
        this.myRefactoringExecutor = new RefactoringExecutor(dataSource);
    }

    @NotNull
    public DatabaseRefactoringHandler setStatement(@NotNull String statement) {
        if (statement == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(1);
        }
        this.myRefactoringExecutor.setStatement(statement);
        DatabaseRefactoringHandler databaseRefactoringHandler = this;
        if (databaseRefactoringHandler == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(2);
        }
        return databaseRefactoringHandler;
    }

    @NotNull
    public String getStatement() {
        String string = this.myRefactoringExecutor.getStatement();
        if (string == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        RefactoringExecutor refactoringExecutor = this.myRefactoringExecutor;
        if (refactoringExecutor == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(4);
        }
        return refactoringExecutor;
    }

    private static int executeQueries(@NotNull Project project, @NotNull DatabaseConnection connection2, @NotNull List<String> queries, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(5);
        }
        if (connection2 == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(6);
        }
        if (queries == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            DatabaseRefactoringHandler.$$$reportNull$$$0(8);
        }
        int totalCount = queries.size();
        int count2 = 0;
        try (ReusableSmartStatement<String> statement = SmartStatements.poweredBy(connection2).simple().reuse();){
            for (String query : queries) {
                if (StringUtil.isEmptyOrSpaces((String)query)) {
                    ++count2;
                    continue;
                }
                indicator.checkCanceled();
                try {
                    statement.barren().execute(query, StandardExecutionMode.UPDATE);
                    DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.INFO).notify(project);
                    indicator.setFraction((double)(++count2) / (double)totalCount);
                }
                catch (Exception e) {
                    DatabaseNotifications.REFACTORING_GROUP.createNotification(query, MessageType.ERROR).notify(project);
                    int n = count2;
                    if (statement != null) {
                        if (var7_7 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                    return n;
                }
            }
        }
        return count2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        @NotNull
        private final DbDataSource myDataSource;

        RefactoringExecutor(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                RefactoringExecutor.$$$reportNull$$$0(0);
            }
            this.myStatement = "";
            this.myDataSource = dataSource;
        }

        public void setStatement(@NotNull String statement) {
            if (statement == null) {
                RefactoringExecutor.$$$reportNull$$$0(1);
            }
            this.myStatement = statement;
        }

        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                RefactoringExecutor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public CompletionStage<?> execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseSessionManager.Facade facade, @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(3);
            }
            if (facade == null) {
                RefactoringExecutor.$$$reportNull$$$0(4);
            }
            if (errorHandler == null) {
                RefactoringExecutor.$$$reportNull$$$0(5);
            }
            return facade.runAsync(SessionsUtil.consumer(connection2 -> {
                if (indicator == null) {
                    RefactoringExecutor.$$$reportNull$$$0(8);
                }
                indicator.setText("Updating database...");
                this.execute(indicator, (DatabaseConnection)connection2);
            }));
        }

        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection2) {
            List<String> queries;
            if (indicator == null) {
                RefactoringExecutor.$$$reportNull$$$0(6);
            }
            if (connection2 == null) {
                RefactoringExecutor.$$$reportNull$$$0(7);
            }
            return (queries = DbSqlUtil.getQueries(this.myStatement, this.myDataSource.getProject(), (Language)DbSqlUtil.getSqlDialect((DbElement)this.myDataSource))).size() == DatabaseRefactoringHandler.executeQueries(this.myDataSource.getProject(), connection2, queries, indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setStatement";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$execute$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

