/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.expr.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.expr.parser.Angular2ElementTypes;

public class Angular2Parser
extends JavaScriptParser<Angular2ExpressionParser, Angular2StatementParser, FunctionParser, JSPsiTypeParser> {
    private final boolean myIsAction;
    private final boolean myIsSimpleBinding;
    private final boolean myIsJavaScript;

    public static void parseAction(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.ACTION_STATEMENT, true, false, (Consumer<Angular2StatementParser>)((Consumer)Angular2StatementParser::parseChain));
    }

    public static void parseBinding(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.BINDING_STATEMENT, false, false, (Consumer<Angular2StatementParser>)((Consumer)parser -> {
            if (!parser.parseQuote()) {
                parser.parseChain();
            }
        }));
    }

    public static void parseTemplateBindings(PsiBuilder builder, IElementType root, String templateKey) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.createTemplateBindingsStatement(templateKey), false, false, (Consumer<Angular2StatementParser>)((Consumer)parser -> parser.parseTemplateBindings(templateKey)));
    }

    public static void parseInterpolation(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.INTERPOLATION_STATEMENT, false, false, (Consumer<Angular2StatementParser>)((Consumer)Angular2StatementParser::parseChain));
    }

    public static void parseSimpleBinding(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.SIMPLE_BINDING_STATEMENT, false, true, (Consumer<Angular2StatementParser>)((Consumer)parser -> {
            if (!parser.parseQuote()) {
                parser.parseChain();
            }
        }));
    }

    private static void parseRoot(PsiBuilder builder, IElementType root, IElementType statementType, boolean isAction, boolean isSimpleBinding, Consumer<Angular2StatementParser> parseAction) {
        PsiBuilder.Marker rootMarker = builder.mark();
        PsiBuilder.Marker statementMarker = builder.mark();
        parseAction.consume((Object)new Angular2Parser(builder, isAction, isSimpleBinding, false).getStatementParser());
        statementMarker.done(statementType);
        rootMarker.done(root);
    }

    public static void parseJS(PsiBuilder builder, IElementType root) {
        new Angular2Parser(builder).parseJS(root);
    }

    public Angular2Parser(PsiBuilder builder) {
        this(builder, false, false, true);
    }

    private Angular2Parser(PsiBuilder builder, boolean isAction, boolean isSimpleBinding, boolean isJavaScript) {
        super(JavaScriptSupportLoader.JAVASCRIPT_1_5, builder);
        this.myIsAction = isAction;
        this.myIsSimpleBinding = isSimpleBinding;
        this.myIsJavaScript = isJavaScript;
        this.myExpressionParser = new Angular2ExpressionParser();
        this.myStatementParser = new Angular2StatementParser(this);
    }

    private static void finishKey(PsiBuilder.Marker key, boolean isVariable) {
        if (isVariable) {
            key.collapse(Angular2TokenTypes.IDENTIFIER);
            key = key.precede();
            key.done(Angular2ElementTypes.TEMPLATE_BINDING_VARIABLE);
            key.precede().done((IElementType)Angular2ElementTypes.VAR_STATEMENT);
        } else {
            key.done(Angular2ElementTypes.TEMPLATE_BINDING_KEY);
        }
    }

    protected class Angular2ExpressionParser
    extends ExpressionParser<Angular2Parser> {
        public Angular2ExpressionParser() {
            super((JavaScriptParser)Angular2Parser.this);
        }

        public boolean parseAssignmentExpression(boolean allowIn) {
            return this.parsePipe();
        }

        public void parseScriptExpression(boolean isTypeContext) {
            throw new UnsupportedOperationException();
        }

        public boolean parsePipe() {
            PsiBuilder.Marker pipe = this.builder.mark();
            if (!this.parseAssignmentExpressionChecked()) {
                pipe.drop();
                return false;
            }
            while (this.builder.getTokenType() == Angular2TokenTypes.OR) {
                if (Angular2Parser.this.myIsSimpleBinding) {
                    this.builder.error("host binding expression cannot contain pipes");
                } else if (Angular2Parser.this.myIsAction) {
                    this.builder.error("action expressions cannot contain pipes");
                }
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == Angular2TokenTypes.IDENTIFIER || Angular2TokenTypes.KEYWORDS.contains(this.builder.getTokenType())) {
                    PsiBuilder.Marker pipeName = this.builder.mark();
                    this.builder.advanceLexer();
                    pipeName.done(Angular2ElementTypes.PIPE_REFERENCE_EXPRESSION);
                } else {
                    this.builder.error("expected identifier or keyword");
                }
                PsiBuilder.Marker params = this.builder.mark();
                while (this.builder.getTokenType() == Angular2TokenTypes.COLON) {
                    this.builder.advanceLexer();
                    if (this.parseAssignmentExpressionChecked()) continue;
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                params.done(Angular2ElementTypes.PIPE_ARGUMENTS_LIST);
                pipe.done(Angular2ElementTypes.PIPE_EXPRESSION);
                pipe = pipe.precede();
            }
            pipe.drop();
            return true;
        }

        public boolean parseAssignmentExpressionChecked() {
            PsiBuilder.Marker expr = this.builder.mark();
            if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                this.builder.advanceLexer();
                if (!this.parsePipe()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done((IElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
                return true;
            }
            PsiBuilder.Marker definitionExpr = this.builder.mark();
            if (!this.parseConditionalExpression(false)) {
                definitionExpr.drop();
                expr.drop();
                return false;
            }
            if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                definitionExpr.done((IElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                if (!Angular2Parser.this.myIsAction && !Angular2Parser.this.myIsJavaScript) {
                    this.builder.error("binding expressions cannot contain assignments");
                }
                this.builder.advanceLexer();
                if (!this.parsePipe()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done((IElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            } else {
                definitionExpr.drop();
                expr.drop();
            }
            return true;
        }

        public boolean parsePrimaryExpression() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == JSTokenTypes.STRING_LITERAL_PART) {
                return this.parsePartialStringLiteral(firstToken);
            }
            return super.parsePrimaryExpression();
        }

        protected boolean isIdentifierToken(IElementType tokenType) {
            return !Angular2TokenTypes.KEYWORDS.contains(tokenType) && super.isIdentifierToken(tokenType);
        }

        protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
            if (this.builder.getTokenType() == Angular2TokenTypes.OR || this.builder.getTokenType() == Angular2TokenTypes.AS_KEYWORD) {
                return -1;
            }
            return super.getCurrentBinarySignPriority(allowIn, advance);
        }

        protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
            return tokenType == Angular2TokenTypes.ELVIS || tokenType == JSTokenTypes.DOT;
        }

        protected boolean isPropertyStart(IElementType elementType) {
            if (elementType != Angular2TokenTypes.IDENTIFIER && elementType != Angular2TokenTypes.STRING_LITERAL && !Angular2TokenTypes.KEYWORDS.contains(elementType)) {
                this.builder.error("expected identifier, keyword, or string");
                return false;
            }
            return true;
        }

        protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
            if (this.builder.getTokenType() == Angular2TokenTypes.EXCL) {
                this.builder.advanceLexer();
                ((PsiBuilder.Marker)markerRef.get()).done(Angular2ElementTypes.POSTFIX_EXPRESSION);
                markerRef.set((Object)((PsiBuilder.Marker)markerRef.get()).precede());
                return true;
            }
            return false;
        }

        protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
            IElementType firstToken = this.builder.getTokenType();
            if (Angular2ElementTypes.PROPERTY_NAMES.contains(firstToken)) {
                String errorMessage = this.validateLiteral();
                this.advancePropertyName(firstToken);
                if (errorMessage != null) {
                    this.builder.error(errorMessage);
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.property.name", (Object[])new Object[0]));
                this.builder.advanceLexer();
            }
            this.parsePropertyInitializer();
            property.done((IElementType)Angular2ElementTypes.PROPERTY);
            property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }

        private boolean parsePartialStringLiteral(IElementType firstToken) {
            PsiBuilder.Marker mark = this.builder.mark();
            IElementType currentToken = firstToken;
            StringBuilder literal = new StringBuilder();
            while (currentToken == JSTokenTypes.STRING_LITERAL_PART || currentToken == Angular2TokenTypes.ESCAPE_SEQUENCE || currentToken == Angular2TokenTypes.INVALID_ESCAPE_SEQUENCE) {
                literal.append(this.builder.getTokenText());
                this.builder.advanceLexer();
                currentToken = this.builder.getTokenType();
            }
            mark.done((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
            String errorMessage = Angular2ExpressionParser.validateLiteralText((String)literal.toString());
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }
    }

    protected class Angular2StatementParser
    extends StatementParser<Angular2Parser> {
        protected Angular2StatementParser(Angular2Parser parser) {
            super((JavaScriptParser)parser);
        }

        public void parseChain() {
            assert (!Angular2Parser.this.myIsJavaScript);
            PsiBuilder.Marker chain = this.builder.mark();
            int count = 0;
            while (!this.builder.eof()) {
                ++count;
                PsiBuilder.Marker expression = this.builder.mark();
                if (!((Angular2ExpressionParser)Angular2Parser.this.getExpressionParser()).parseExpressionOptional(false, false)) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                    this.builder.advanceLexer();
                    expression.drop();
                } else if (Angular2Parser.this.myIsAction) {
                    expression.done(Angular2ElementTypes.EXPRESSION_STATEMENT);
                } else {
                    expression.drop();
                }
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == Angular2TokenTypes.SEMICOLON) {
                    if (!Angular2Parser.this.myIsAction) {
                        this.builder.error("binding expression cannot contain chained expression");
                    }
                    while (this.builder.getTokenType() == Angular2TokenTypes.SEMICOLON) {
                        this.builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == null) continue;
                this.builder.error("unexpected token '" + this.builder.getTokenText() + "'");
            }
            switch (count) {
                case 0: {
                    if (Angular2Parser.this.myIsAction) {
                        chain.done(Angular2ElementTypes.EMPTY_STATEMENT);
                        break;
                    }
                    chain.done((IElementType)Angular2ElementTypes.EMPTY_EXPRESSION);
                    break;
                }
                case 1: {
                    chain.drop();
                    break;
                }
                default: {
                    if (Angular2Parser.this.myIsAction) {
                        chain.done(Angular2ElementTypes.CHAIN_STATEMENT);
                        break;
                    }
                    chain.drop();
                }
            }
        }

        public boolean parseQuote() {
            PsiBuilder.Marker quote = this.builder.mark();
            if (this.builder.getTokenType() != Angular2TokenTypes.IDENTIFIER && !Angular2TokenTypes.KEYWORDS.contains(this.builder.getTokenType()) || this.builder.lookAhead(1) != Angular2TokenTypes.COLON) {
                quote.drop();
                return false;
            }
            this.builder.advanceLexer();
            this.builder.enforceCommentTokens(TokenSet.EMPTY);
            this.builder.advanceLexer();
            PsiBuilder.Marker rest = this.builder.mark();
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
            rest.collapse(Angular2TokenTypes.STRING_LITERAL);
            quote.done(Angular2ElementTypes.QUOTE_STATEMENT);
            return true;
        }

        public void parseTemplateBindings(String templateKey) {
            boolean firstBinding = true;
            do {
                String rawKey;
                String key;
                PsiBuilder.Marker binding = this.builder.mark();
                boolean isVar = false;
                if (firstBinding) {
                    rawKey = key = templateKey;
                    firstBinding = false;
                } else {
                    boolean bl = isVar = this.builder.getTokenType() == Angular2TokenTypes.LET_KEYWORD;
                    if (isVar) {
                        this.builder.advanceLexer();
                    }
                    rawKey = this.parseTemplateBindingKey(isVar);
                    String string = key = isVar ? rawKey : templateKey + StringUtil.capitalize((String)rawKey);
                    if (this.builder.getTokenType() == Angular2TokenTypes.COLON) {
                        this.builder.advanceLexer();
                    }
                }
                String name = null;
                if (isVar) {
                    if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                        this.builder.advanceLexer();
                        name = this.parseTemplateBindingKey(false);
                    } else {
                        name = "$implicit";
                    }
                } else if (this.builder.getTokenType() == Angular2TokenTypes.AS_KEYWORD) {
                    this.builder.advanceLexer();
                    name = rawKey;
                    key = this.parseTemplateBindingKey(true);
                    isVar = true;
                } else if (this.builder.getTokenType() != Angular2TokenTypes.LET_KEYWORD && !((Angular2ExpressionParser)Angular2Parser.this.getExpressionParser()).parsePipe()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                binding.done(Angular2ElementTypes.createTemplateBindingStatement(key, isVar, name));
                if (this.builder.getTokenType() == Angular2TokenTypes.AS_KEYWORD && !isVar) {
                    PsiBuilder.Marker localBinding = this.builder.mark();
                    this.builder.advanceLexer();
                    String letName = this.parseTemplateBindingKey(true);
                    localBinding.done(Angular2ElementTypes.createTemplateBindingStatement(letName, true, key));
                }
                if (this.builder.getTokenType() != Angular2TokenTypes.SEMICOLON && this.builder.getTokenType() != Angular2TokenTypes.COMMA) continue;
                this.builder.advanceLexer();
            } while (!this.builder.eof());
        }

        private String parseTemplateBindingKey(boolean isVariable) {
            PsiBuilder.Marker key = this.builder.mark();
            boolean operatorFound = true;
            StringBuilder result = new StringBuilder();
            do {
                if (!Angular2Parser.this.isIdentifierName(this.builder.getTokenType())) {
                    if (result.length() > 0) {
                        Angular2Parser.finishKey(key, isVariable);
                    } else {
                        key.drop();
                    }
                    this.builder.error("Identifier or keyword expected");
                    this.builder.advanceLexer();
                    return result.toString();
                }
                result.append(this.builder.getTokenText());
                if (this.builder.rawLookup(1) == Angular2TokenTypes.MINUS) {
                    this.builder.advanceLexer();
                    result.append(this.builder.getTokenText());
                } else {
                    operatorFound = false;
                }
                this.builder.advanceLexer();
            } while (operatorFound);
            Angular2Parser.finishKey(key, isVariable);
            return result.toString();
        }
    }
}

