/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider2;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitUsageIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnitCoversIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseReferenceNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableNameIndex;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIndexImpl
extends PhpIndex
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.PhpIndex");
    private final Project project;
    public static final RecursionGuard RECURSION_GUARD = RecursionManager.createGuard((String)"php.index");
    public static final Map<String, String> ARRAY_VALUE_PROVIDERS = new LinkedHashMap();
    public static final Map<String, String> ARRAY_KEY_PROVIDERS;

    PhpIndexImpl(Project project) {
        this.project = project;
    }

    @NotNull
    public <T extends PhpNamedElement> Collection<T> filterByNamespace(@NotNull Collection<T> elements, @Nullable String namespaceName) {
        if (elements == null) {
            PhpIndexImpl.$$$reportNull$$$0(0);
        }
        Collection<T> collection = this.filterByNamespace(elements, namespaceName, false);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public <T extends PhpNamedElement> Collection<T> filterByNamespace(@NotNull Collection<T> elements, @Nullable String namespaceName, boolean allowGlobal) {
        if (elements == null) {
            PhpIndexImpl.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty() || StringUtil.isEmpty((String)namespaceName)) {
            Collection<T> collection = elements;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Collection collection = ((StreamEx)StreamEx.of(elements).filter(e -> PhpCompletionUtil.hasNamespace(namespaceName, allowGlobal, e))).toCollection(THashSet::new);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public PhpType completeThis(final @NotNull PhpType rawTypeInput, final @Nullable String thisClass, final @NotNull Set<String> visited) {
        if (rawTypeInput == null) {
            PhpIndexImpl.$$$reportNull$$$0(5);
        }
        if (visited == null) {
            PhpIndexImpl.$$$reportNull$$$0(6);
        }
        PhpType out = null;
        List currentStack = RECURSION_GUARD.currentStack();
        if (currentStack.size() > 50) {
            Object top = currentStack.get(0);
            LOG.warn("completeThis RECURSION LIMIT for " + top + " on " + rawTypeInput);
        } else {
            out = (PhpType)RECURSION_GUARD.doPreventingRecursion((Object)Pair.create((Object)rawTypeInput, (Object)thisClass), true, (Computable)new Computable.NotNullCachedComputable<PhpType>(){

                @NotNull
                public PhpType internalCompute() {
                    PhpType out = new PhpType();
                    for (String raw : rawTypeInput.getTypes()) {
                        StringBuilder rawArray = new StringBuilder();
                        while (raw.endsWith("[]")) {
                            rawArray.append("[]");
                            raw = raw.substring(0, raw.length() - 2);
                        }
                        if (raw.startsWith("#")) {
                            String classRef;
                            int dot;
                            if (raw.contains("#Cstatic.")) {
                                String containingRef = "#C" + thisClass + ".";
                                raw = StringUtil.replace((String)raw, (String)"#Cstatic.", (String)containingRef);
                            }
                            classRef = (dot = (classRef = StringUtil.trimStart((String)raw, (String)"#E")).lastIndexOf(46)) < 2 ? classRef : classRef.substring(2, dot);
                            classRef = StringUtil.trimStart((String)classRef, (String)"#E");
                            PhpType global = new PhpType().add(raw).global(PhpIndexImpl.this.project);
                            PhpType aware = PhpIndexImpl.this.completeThis(global, classRef, visited);
                            out.add(aware);
                            continue;
                        }
                        if ("static".equals(raw) || "$this".equals(raw) || "self".equals(raw) || "\\___PHPSTORM_HELPERS\\static".equals(raw) || "\\___PHPSTORM_HELPERS\\this".equals(raw)) {
                            if (thisClass == null || thisClass.startsWith("#V") && !visited.add(thisClass) || thisClass.startsWith("#F") && !visited.add(thisClass)) continue;
                            PhpType aware = PhpIndexImpl.this.completeThis(new PhpType().add(thisClass), null, visited);
                            for (String s : aware.getTypes()) {
                                out.add(s + rawArray);
                            }
                            continue;
                        }
                        out.add(raw + rawArray);
                    }
                    PhpType phpType = out;
                    if (phpType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return phpType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/PhpIndexImpl$1", "internalCompute"));
                }
            });
        }
        if (out == null) {
            out = PhpType.EMPTY;
        }
        PhpType phpType = out;
        if (phpType == null) {
            PhpIndexImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @NotNull
    public PhpType completeType(@NotNull Project p, @NotNull PhpType type, @NotNull Set<String> visited) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PhpIndexImpl.$$$reportNull$$$0(9);
        }
        if (visited == null) {
            PhpIndexImpl.$$$reportNull$$$0(10);
        }
        while (!type.isComplete()) {
            PhpType completeType = new PhpType();
            for (String typeName : type.getTypes()) {
                long t = System.currentTimeMillis();
                if (typeName.length() > 1 && typeName.charAt(0) == '#') {
                    if (!visited.contains(typeName)) {
                        visited.add(typeName);
                        PhpType cacheInfo = PhpCaches.getInstance((Project)p).TYPE_COMPLETION_CACHE.get(typeName);
                        if (cacheInfo != null) {
                            completeType.add(cacheInfo);
                        } else {
                            cacheInfo = new PhpType();
                            Collection targets = PhpIndexImpl.getInstance((Project)p).getBySignature(typeName, visited, 0);
                            if (!targets.isEmpty()) {
                                for (PhpNamedElement element : targets) {
                                    PhpType elementType = element.getType();
                                    cacheInfo.add(elementType);
                                    completeType.add(elementType);
                                }
                            } else {
                                cacheInfo.add("?" + typeName);
                                completeType.add("?" + typeName);
                            }
                            PhpCaches.getInstance((Project)p).TYPE_COMPLETION_CACHE.put(typeName, cacheInfo);
                        }
                    } else {
                        completeType.add("?" + typeName);
                    }
                } else {
                    completeType.add(typeName);
                }
                t = System.currentTimeMillis() - t;
                if (t > 500L) {
                    LOG.warn("Completing type '" + typeName + "' took " + t + "ms, visited:" + new ArrayList<String>(visited));
                }
                if (completeType.size() <= 15) continue;
                break;
            }
            type = completeType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpIndexImpl.$$$reportNull$$$0(11);
        }
        return phpType;
    }

    public Collection<PhpNamespace> getNamespacesByName(String name) {
        if (name == null || name.length() == 0) {
            return Collections.emptySet();
        }
        return StubIndex.getElements(PhpNamespaceIndex.KEY, (Object)name, (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpNamespace.class);
    }

    @NotNull
    public Collection<String> getAllChildNamespacesFqns(@NotNull String parentNamespaceFqn) {
        if (parentNamespaceFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(12);
        }
        THashSet result = new THashSet();
        StubIndex.getInstance().processAllKeys(PhpNamespaceIndex.KEY, this.project, arg_0 -> PhpIndexImpl.lambda$getAllChildNamespacesFqns$1(parentNamespaceFqn, (Set)result, arg_0));
        THashSet tHashSet = result;
        if (tHashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(13);
        }
        return tHashSet;
    }

    @NotNull
    public Collection<String> getAllConstantNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpConstantNameIndex.KEY, (Processor)processor, this.project);
        Collection collection = this.filterKeys(processor.getResults(), (ID)PhpConstantNameIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllVariableNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpVariableNameIndex.KEY, (Processor)processor, this.project);
        Collection collection = this.filterKeys(processor.getResults(), (ID)PhpVariableNameIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllFunctionNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpFunctionNameIndex.KEY, (Processor)processor, this.project);
        Collection collection = this.filterKeys(processor.getResults(), (ID)PhpFunctionNameIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllClassNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpClassNameIndex.KEY, (Processor)processor, this.project);
        Collection result = this.filterKeys(processor.getResults(), (ID)PhpClassNameIndex.KEY);
        if (result.isEmpty()) {
            Collection<String> collection = this.getClassAliasesNames();
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(17);
            }
            return collection;
        }
        List list = ContainerUtil.concat((List)result, new ArrayList<String>(this.getClassAliasesNames()));
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllClassFqns(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor uniquesProcessor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpClassFqnIndex.KEY, (Processor)uniquesProcessor, this.project);
        Collection collection = uniquesProcessor.getResults();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllInterfacesFqns(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor uniquesProcessor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpInterfaceFqnIndex.KEY, (Processor)uniquesProcessor, this.project);
        Collection collection = uniquesProcessor.getResults();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getClassAliasesNames() {
        Collection collection = PhpClassAliasIndex.getInstance((Project)this.project).getClassNames();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllInterfaceNames() {
        Collection result = StubIndex.getInstance().getAllKeys(PhpInterfaceIndex.KEY, this.project);
        result.addAll(PhpClassAliasIndex.getInstance((Project)this.project).getInterfaceNames());
        Collection collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllTraitNames() {
        Collection result = StubIndex.getInstance().getAllKeys(PhpTraitIndex.KEY, this.project);
        result.addAll(PhpClassAliasIndex.getInstance((Project)this.project).getTraitNames());
        Collection collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getChildNamespacesByParentName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        List values = FileBasedIndex.getInstance().getValues(PhpNamespaceInheritanceIndex.KEY, (Object)name.toLowerCase(), this.getSearchScope());
        if (values.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(25);
            }
            return set;
        }
        if (values.size() == 1) {
            Collection collection = (Collection)values.get(0);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(26);
            }
            return collection;
        }
        THashSet strings = new THashSet();
        for (Set value : values) {
            strings.addAll(value);
        }
        THashSet tHashSet = strings;
        if (tHashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(27);
        }
        return tHashSet;
    }

    @NotNull
    public Collection<String> getTraitUsagesByFQN(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(28);
            }
            return set;
        }
        List values = FileBasedIndex.getInstance().getValues(PhpTraitUsageIndex.KEY, (Object)name, this.getSearchScope());
        if (values.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(29);
            }
            return set;
        }
        if (values.size() == 1) {
            Collection collection = (Collection)values.get(0);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(30);
            }
            return collection;
        }
        THashSet strings = new THashSet();
        for (Set value : values) {
            strings.addAll(value);
        }
        THashSet tHashSet = strings;
        if (tHashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(31);
        }
        return tHashSet;
    }

    public Collection<PhpUse> getUseAliasesByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            return Collections.emptySet();
        }
        return StubIndex.getElements(PhpUseIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpUse.class);
    }

    @NotNull
    public Collection<PhpUse> getUseAliasesByReferenceName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<PhpUse> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(32);
            }
            return set;
        }
        Collection collection = StubIndex.getElements(PhpUseReferenceNameIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpUse.class);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @NotNull
    public Collection<Constant> getConstantsByFQN(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<Constant> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(34);
            }
            return set;
        }
        int i = name.lastIndexOf(92);
        Collection<Constant> elements = this.getConstantsByName(name.substring(i + 1));
        Collection<Constant> collection = elements = this.filterByNamespace(elements, i >= 0 ? name.substring(0, i + 1) : "\\");
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @NotNull
    public Collection<Constant> getConstantsByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<Constant> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(36);
            }
            return set;
        }
        Collection sensitive = StubIndex.getElements(PhpCaseSensitiveConstantIndex.KEY, (Object)name, (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Constant.class);
        Collection insensitive = StubIndex.getElements(PhpConstantIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Constant.class);
        ArrayList<Constant> constants = new ArrayList<Constant>(sensitive);
        constants.addAll(insensitive);
        ArrayList<Constant> arrayList = constants;
        if (arrayList == null) {
            PhpIndexImpl.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public Collection<Variable> getVariablesByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<Variable> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(38);
            }
            return set;
        }
        Collection collection = StubIndex.getElements(PhpVariableIndex.KEY, (Object)name, (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Variable.class);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    public Collection<Function> getFunctionsByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<Function> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(40);
            }
            return set;
        }
        Collection collection = StubIndex.getElements(PhpFunctionIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Function.class);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @NotNull
    public Collection<Function> getFunctionsByFQN(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<Function> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(42);
            }
            return set;
        }
        int i = name.lastIndexOf(92);
        Collection<Function> elements = this.getFunctionsByName(name.substring(i + 1));
        Collection<Function> collection = elements = this.filterByNamespace(elements, i >= 0 ? name.substring(0, i + 1) : "\\");
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getInterfacesByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(44);
            }
            return set;
        }
        Collection<PhpClass> collection = this.getByName(name.toLowerCase(), PhpCaches.getInstance((Project)this.project).interfaceCache, PhpInterfaceIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(45);
        }
        return collection;
    }

    public Collection<PhpClass> getTraitsByName(String name) {
        if (name == null || name.length() == 0) {
            return Collections.emptySet();
        }
        return this.getByName(name.toLowerCase(), PhpCaches.getInstance((Project)this.project).traitCache, PhpTraitIndex.KEY);
    }

    @NotNull
    public Collection<PhpClass> getClassesByName(@Nullable String name) {
        if (name == null || name.length() == 0) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(46);
            }
            return set;
        }
        Collection<PhpClass> collection = this.getByName(name.toLowerCase(), PhpCaches.getInstance((Project)this.project).classCache, PhpClassIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getClassesByNameInScope(@Nullable String name, GlobalSearchScope scope) {
        if (name == null) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(48);
            }
            return list;
        }
        Collection collection = StubIndex.getElements(PhpClassIndex.KEY, (Object)name.toLowerCase(), (Project)this.project, (GlobalSearchScope)scope, PhpClass.class);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(49);
        }
        return collection;
    }

    @Nullable
    public PhpClass getClassByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Collection<PhpClass> classes = this.getClassesByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        classes = this.getInterfacesByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        classes = this.getTraitsByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        return null;
    }

    @NotNull
    public Collection<PhpClass> getDirectSubclasses(@Nullable String fqn) {
        if (fqn == null) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(50);
            }
            return list;
        }
        if (!StringUtil.startsWithChar((CharSequence)fqn, (char)'\\')) {
            fqn = '\\' + fqn;
        }
        Collection result = StubIndex.getElements(PhpInheritanceIndex.KEY, (Object)fqn.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpClass.class);
        for (String aliasFqn : PhpClassAliasIndex.getInstance((Project)this.project).getAliasFqnsByClass(fqn)) {
            result.addAll(StubIndex.getElements(PhpInheritanceIndex.KEY, (Object)aliasFqn.toLowerCase(), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpClass.class));
        }
        Collection collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(51);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getAllSubclasses(@Nullable String fqn) {
        Collection<PhpClass> result = PhpCaches.getInstance((Project)this.project).subclassCache.get(fqn);
        if (result != null) {
            Collection<PhpClass> collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(52);
            }
            return collection;
        }
        result = this.getAllSubclasses(fqn, null);
        PhpCaches.getInstance((Project)this.project).subclassCache.put(fqn, Collections.unmodifiableCollection(result));
        Collection<PhpClass> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(53);
        }
        return collection;
    }

    private Collection<PhpClass> getAllSubclasses(String fqn, @Nullable Collection<String> visited) {
        SmartList result = new SmartList();
        if (visited == null) {
            visited = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        }
        Collection<PhpClass> direct = this.getDirectSubclasses(fqn);
        for (PhpClass aDirect : direct) {
            String aDirectFQN = aDirect.getFQN();
            if (visited.contains(aDirectFQN)) continue;
            result.add(aDirect);
            visited.add(aDirectFQN);
            Collection<PhpClass> subclasses = this.getAllSubclasses(aDirectFQN, (Collection<String>)visited);
            result.addAll(subclasses);
        }
        return result;
    }

    public GlobalSearchScope getSearchScope() {
        return GlobalSearchScope.allScope((Project)this.project);
    }

    @NotNull
    public Collection<? extends PhpNamedElement> getBySignature(@NotNull String s) {
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(54);
        }
        Collection<? extends PhpNamedElement> collection = this.getBySignature(s, null, 0);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(55);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> getBySignature(@NotNull String s, @Nullable Set<String> visited, int depth) {
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(56);
        }
        if (s.indexOf(35, 200) > 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(57);
            }
            return set;
        }
        Collection<? extends PhpNamedElement> result = PhpCaches.getInstance((Project)this.project).SIGNATURES_CACHE.get(s);
        if (result == null) {
            result = Collections.unmodifiableCollection(this.getBySignatureInternal(s, visited, depth));
            PhpCaches.getInstance((Project)this.project).SIGNATURES_CACHE.put(s, result);
        }
        Collection<? extends PhpNamedElement> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(58);
        }
        return collection;
    }

    @NotNull
    protected Collection<? extends PhpNamedElement> getBySignatureInternal(@NotNull String s, @Nullable Set<String> visited, int depth) {
        Collection result;
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(59);
        }
        if (depth > 50) {
            LOG.warn("getBySignature recursion hit level 50 @ <<<" + s + ">>>");
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(60);
            }
            return set;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (s.length() == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(61);
            }
            return set;
        }
        if (s.length() < 2 || s.charAt(0) != '#') {
            LOG.warn("Invalid Signature '" + s + "'");
            try {
                throw new RuntimeException("Invalid Signature '" + s + "'");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                Set set = Collections.emptySet();
                if (set == null) {
                    PhpIndexImpl.$$$reportNull$$$0(62);
                }
                return set;
            }
        }
        String entityName = s.substring(2);
        char key = s.charAt(1);
        if (PhpTypeSignatureKey.VARIABLE.is(key)) {
            Collection<Variable> collection = this.getVariablesByName(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(63);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.ARRAY_KEY.is(key)) {
            SmartList elements = new SmartList();
            Collection<? extends PhpNamedElement> bySignature = this.getBySignature(entityName, (Set<String>)visited, ++depth);
            for (PsiElement psiElement : bySignature) {
                if (!(psiElement instanceof PhpTypedElement)) continue;
                PhpType phpType = ((PhpTypedElement)psiElement).getType();
                Set strings = phpType.getTypes();
                for (String name : strings) {
                    elements.addAll(this.getTypeMethods("#C" + name, (Set<String>)visited, ARRAY_KEY_PROVIDERS));
                }
            }
            SmartList smartList = elements;
            if (smartList == null) {
                PhpIndexImpl.$$$reportNull$$$0(64);
            }
            return smartList;
        }
        if (PhpTypeSignatureKey.ARRAY_ELEMENT.is(key)) {
            SmartList elements = new SmartList();
            if (entityName.endsWith("[]")) {
                Collection<? extends PhpNamedElement> collection = this.getBySignature(entityName.substring(0, entityName.length() - 2), (Set<String>)visited, ++depth);
                if (collection == null) {
                    PhpIndexImpl.$$$reportNull$$$0(65);
                }
                return collection;
            }
            Collection<? extends PhpNamedElement> bySignature = this.getBySignature(entityName, (Set<String>)visited, ++depth);
            for (PsiElement psiElement : bySignature) {
                if (!(psiElement instanceof PhpTypedElement)) continue;
                PhpType phpType2 = ((PhpTypedElement)psiElement).getType();
                phpType2 = phpType2.elementType();
                Set strings = phpType2.getTypes();
                for (String name : strings) {
                    Collection<PhpClass> interfaces;
                    if (PhpType.isUnresolved((String)name) && PhpTypeSignatureKey.ARRAY_ELEMENT.is(name.charAt(1))) {
                        elements.addAll(this.getTypeMethods(name.substring(2), (Set<String>)visited, ARRAY_VALUE_PROVIDERS));
                    }
                    if (name.equals("static")) {
                        name = "\\___PHPSTORM_HELPERS\\static";
                    } else if (name.equals("$this")) {
                        name = "\\___PHPSTORM_HELPERS\\this";
                    }
                    Collection<PhpClass> classes = this.getClassesByFQN(name);
                    if (classes.size() > 0) {
                        elements.addAll(classes);
                    }
                    if ((interfaces = this.getInterfacesByFQN(name)).size() <= 0) continue;
                    elements.addAll(interfaces);
                }
            }
            SmartList smartList = elements;
            if (smartList == null) {
                PhpIndexImpl.$$$reportNull$$$0(66);
            }
            return smartList;
        }
        if (PhpTypeSignatureKey.CONSTANT.is(key)) {
            Collection<Constant> collection = this.getConstantsByFQN(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(67);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.PARAMETER.is(key)) {
            String innerEntitySig = entityName.substring(0, entityName.length() > 2 ? entityName.length() - 2 : 0);
            Collection<? extends PhpNamedElement> elements = this.getBySignature(innerEntitySig, (Set<String>)visited, 0);
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            for (PsiElement psiElement : elements) {
                if (psiElement instanceof Function) {
                    int n = entityName.charAt(entityName.length() - 1) - 48;
                    Parameter[] parameters = ((Function)psiElement).getParameters();
                    if (parameters.length <= n) continue;
                    params.add(parameters[n]);
                    continue;
                }
                LOG.warn("Function expected in " + s + ", got " + psiElement);
            }
            ArrayList<Parameter> arrayList = params;
            if (arrayList == null) {
                PhpIndexImpl.$$$reportNull$$$0(68);
            }
            return arrayList;
        }
        if (PhpTypeSignatureKey.FUNCTION.is(key)) {
            Collection<Function> collection = this.getFunctionsByFQN(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(69);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.CLASS.is(key)) {
            Collection<PhpClass> collection = this.getAnyByFQN(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(70);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.FIELD.is(key) || PhpTypeSignatureKey.METHOD.is(key) || PhpTypeSignatureKey.CLASS_CONSTANT.is(key)) {
            int dot = s.lastIndexOf(46);
            if (dot < 2) {
                if (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException("Invalid Signature " + s);
                }
                Set set = Collections.emptySet();
                if (set == null) {
                    PhpIndexImpl.$$$reportNull$$$0(71);
                }
                return set;
            }
            String classRef = s.substring(2, dot);
            String name = s.substring(dot + 1);
            Collection<PhpClass> collection = this.getClasses((Set<String>)visited, classRef);
            THashSet tHashSet = new THashSet();
            for (PhpClass phpClass : collection) {
                Field member = null;
                if (PhpTypeSignatureKey.FIELD.is(key)) {
                    member = phpClass.findFieldByName((CharSequence)name, false);
                    if (member == null) {
                        member = phpClass.findMethodByName((CharSequence)"__get");
                    }
                } else if (PhpTypeSignatureKey.CLASS_CONSTANT.is(key)) {
                    member = phpClass.findFieldByName((CharSequence)name, true);
                } else if (PhpTypeSignatureKey.METHOD.is(key)) {
                    member = phpClass.findMethodByName((CharSequence)name);
                }
                if (member == null) continue;
                tHashSet.add(member);
            }
            THashSet tHashSet2 = tHashSet;
            if (tHashSet2 == null) {
                PhpIndexImpl.$$$reportNull$$$0(72);
            }
            return tHashSet2;
        }
        for (PhpTypeProvider3 provider : PhpTypeProvider3.EP_NAME.getExtensionList()) {
            if (provider.getKey() != key || (result = provider.getBySignature(entityName, (Set)visited, depth, this.project)) == null || result.size() <= 0) continue;
            Collection collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(73);
            }
            return collection;
        }
        for (PhpTypeProvider3 provider : PhpTypeProvider2.EP_NAME.getExtensionList()) {
            if (provider.getKey() != key || (result = provider.getBySignature(entityName, this.project)) == null || result.size() <= 0) continue;
            Collection collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(74);
            }
            return collection;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            PhpIndexImpl.$$$reportNull$$$0(75);
        }
        return set;
    }

    @NotNull
    private Collection<? extends PhpNamedElement> getTypeMethods(@NotNull String classSign, @Nullable Set<String> visited, Map<String, String> providers) {
        if (classSign == null) {
            PhpIndexImpl.$$$reportNull$$$0(76);
        }
        if (!PhpTypeSignatureKey.CLASS.is(classSign.charAt(1))) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(77);
            }
            return list;
        }
        String classRef = classSign.substring(2);
        THashSet allSupers = new THashSet();
        for (PhpClass phpClass : this.getClasses(visited, classSign)) {
            PhpClassHierarchyUtils.processSupers((PhpClass)phpClass, (boolean)true, (boolean)true, arg_0 -> PhpIndexImpl.lambda$getTypeMethods$2((Set)allSupers, arg_0));
            for (Map.Entry<String, String> arrayClass : providers.entrySet()) {
                String name;
                Collection<? extends PhpNamedElement> methods;
                if (!allSupers.contains(arrayClass.getKey().toLowerCase()) || (methods = this.getBySignature(name = arrayClass.getValue().replace("*", classRef))).isEmpty()) continue;
                Collection<? extends PhpNamedElement> collection = methods;
                if (collection == null) {
                    PhpIndexImpl.$$$reportNull$$$0(78);
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(79);
        }
        return list;
    }

    public Collection<PhpClass> getClasses(@Nullable Set<String> visited, @NotNull String classRef) {
        if (classRef == null) {
            PhpIndexImpl.$$$reportNull$$$0(80);
        }
        if (visited == null) {
            visited = new THashSet();
        }
        Collection<? extends PhpNamedElement> refs = this.getBySignature(classRef, (Set<String>)visited, 0);
        SmartList classes = new SmartList();
        for (PsiElement psiElement : refs) {
            if (psiElement instanceof PhpClass) {
                classes.add((PhpClass)psiElement);
                continue;
            }
            if (psiElement instanceof PhpTypedElement) {
                PhpType type = ((PhpTypedElement)psiElement).getType();
                PhpType phpType = this.completeThis(type, classRef, (Set<String>)visited);
                phpType.getTypes().forEach(arg_0 -> this.lambda$getClasses$3((Collection)classes, arg_0));
                continue;
            }
            throw new RuntimeException("Unknown type in " + psiElement + " " + (psiElement != null ? psiElement.getText() : null) + " for " + classRef);
        }
        return classes;
    }

    @NotNull
    private Collection<PhpClass> getByFQN(String fqn, Map<String, Collection<PhpClass>> cache, StubIndexKey<String, PhpClass> key) {
        String ns;
        Collection<PhpClass> result;
        if (StringUtil.isEmpty((String)fqn)) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(81);
            }
            return set;
        }
        if (!StringUtil.startsWithChar((CharSequence)fqn, (char)'\\')) {
            fqn = "\\" + fqn;
        }
        if ((result = cache.get(fqn)) != null) {
            Collection<PhpClass> collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(82);
            }
            return collection;
        }
        int i = fqn.lastIndexOf(92);
        String name = i >= 0 ? fqn.substring(i + 1) : fqn;
        String string = ns = i >= 0 ? fqn.substring(0, i + 1) : "\\";
        if (name.length() != 0) {
            result = this.getByName(name.toLowerCase(), cache, key);
        }
        if (result != null && result.size() > 0) {
            result = this.filterByNamespace(result, ns);
            result = Collections.unmodifiableCollection(result);
        } else {
            result = Collections.emptySet();
        }
        cache.put(fqn, result);
        Collection<PhpClass> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(83);
        }
        return collection;
    }

    @NotNull
    private Collection<PhpClass> getByName(@NotNull String name, @NotNull Map<String, Collection<PhpClass>> cache, @NotNull StubIndexKey<String, PhpClass> key) {
        List<PhpClass> elements;
        if (name == null) {
            PhpIndexImpl.$$$reportNull$$$0(84);
        }
        if (cache == null) {
            PhpIndexImpl.$$$reportNull$$$0(85);
        }
        if (key == null) {
            PhpIndexImpl.$$$reportNull$$$0(86);
        }
        if ((elements = cache.get(name)) != null) {
            List<PhpClass> list = elements;
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(87);
            }
            return list;
        }
        elements = StubIndex.getElements(key, (Object)name, (Project)this.project, (GlobalSearchScope)this.getSearchScope(), PhpClass.class);
        if (key == PhpClassIndex.KEY) {
            PhpIndexImpl.addAllWithUniqueFqn((Collection<PhpClass>)elements, PhpClassAliasIndex.getInstance((Project)this.project).getClassesByName(name));
        } else if (key == PhpInterfaceIndex.KEY) {
            PhpIndexImpl.addAllWithUniqueFqn((Collection<PhpClass>)elements, PhpClassAliasIndex.getInstance((Project)this.project).getInterfacesByName(name));
        } else if (key == PhpTraitIndex.KEY) {
            PhpIndexImpl.addAllWithUniqueFqn(elements, PhpClassAliasIndex.getInstance((Project)this.project).getTraitsByName(name));
        }
        if (elements.isEmpty()) {
            elements = Collections.emptyList();
        }
        cache.put(name, Collections.unmodifiableCollection(elements));
        List<PhpClass> list = elements;
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(88);
        }
        return list;
    }

    private static void addAllWithUniqueFqn(Collection<PhpClass> elements, Collection<PhpClassAlias> aliases) {
        if (!aliases.isEmpty()) {
            THashSet fqns = new THashSet(elements.size(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (PhpClass phpClass : elements) {
                fqns.add(phpClass.getFQN());
            }
            for (PhpClassAlias alias : aliases) {
                if (fqns.contains(alias.getFQN())) continue;
                elements.add((PhpClass)alias);
            }
        }
    }

    @NotNull
    public Collection<PhpClass> getClassesByFQN(String fqn) {
        Collection<PhpClass> collection = this.getByFQN(fqn, PhpCaches.getInstance((Project)this.project).classCache, PhpClassIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(89);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getInterfacesByFQN(String fqn) {
        Collection<PhpClass> collection = this.getByFQN(fqn, PhpCaches.getInstance((Project)this.project).interfaceCache, PhpInterfaceIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(90);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getTraitsByFQN(String fqn) {
        Collection<PhpClass> collection = this.getByFQN(fqn, PhpCaches.getInstance((Project)this.project).traitCache, PhpTraitIndex.KEY);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(91);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getAnyByFQN(String fqn) {
        if (!StringUtil.startsWithChar((CharSequence)fqn, (char)'\\')) {
            fqn = "\\" + fqn;
        }
        Collection<PhpClass> classes = this.getClassesByFQN(fqn);
        Collection<PhpClass> interfaces = this.getInterfacesByFQN(fqn);
        Collection<PhpClass> traits = this.getTraitsByFQN(fqn);
        if (classes.size() > 0 && interfaces.size() == 0 && traits.size() == 0) {
            Collection<PhpClass> collection = classes;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(92);
            }
            return collection;
        }
        if (classes.size() == 0 && interfaces.size() > 0 && traits.size() == 0) {
            Collection<PhpClass> collection = interfaces;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(93);
            }
            return collection;
        }
        if (classes.size() == 0 && interfaces.size() == 0 && traits.size() > 0) {
            Collection<PhpClass> collection = traits;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(94);
            }
            return collection;
        }
        SmartList result = new SmartList();
        if (classes.size() > 0) {
            result.addAll(classes);
        }
        if (interfaces.size() > 0) {
            result.addAll(interfaces);
        }
        if (traits.size() > 0) {
            result.addAll(traits);
        }
        Collection<PhpClass> collection = Collections.unmodifiableCollection(result);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(95);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getCoveringTestClasses(@NotNull Project project, @NotNull String targetClassFqn) {
        if (project == null) {
            PhpIndexImpl.$$$reportNull$$$0(96);
        }
        if (targetClassFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(97);
        }
        Collection collection = FileBasedIndex.getInstance().getValues(PhpUnitCoversIndex.KEY, (Object)PhpPathInfo.byClass(targetClassFqn), GlobalSearchScope.projectScope((Project)project)).stream().flatMap(Collection::stream).flatMap(s -> this.getClassesByFQN(s.getClassFQN()).stream()).filter(PhpUnitUtil::isTestClass).collect(Collectors.toList());
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(98);
        }
        return collection;
    }

    @NotNull
    private List<Method> getTestMethods(@NotNull String classFqn, @NotNull String methodName) {
        if (classFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(99);
        }
        if (methodName == null) {
            PhpIndexImpl.$$$reportNull$$$0(100);
        }
        List list = ((StreamEx)StreamEx.of(this.getClassesByFQN(classFqn)).map(testClass -> {
            if (methodName == null) {
                PhpIndexImpl.$$$reportNull$$$0(110);
            }
            return testClass.findOwnMethodByName((CharSequence)methodName);
        }).nonNull().filter(PhpUnitUtil::isTestMethod)).toList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(101);
        }
        return list;
    }

    @NotNull
    public Collection<Method> getCoveringTestMethods(@NotNull Project project, @NotNull Method method) {
        if (project == null) {
            PhpIndexImpl.$$$reportNull$$$0(102);
        }
        if (method == null) {
            PhpIndexImpl.$$$reportNull$$$0(103);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List list = StreamEx.of(PhpIndexImpl.getCoveringPaths(method)).flatMap(path -> ContainerUtil.flatten((Iterable)index.getValues(PhpUnitCoversIndex.KEY, path, scope)).stream()).toFlatList(path -> this.getTestMethods(path.getClassFQN(), path.getMethodName()));
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(104);
        }
        return list;
    }

    @NotNull
    public static List<PhpPathInfo> getCoveringPaths(@NotNull Method method) {
        PhpClass containingClass;
        if (method == null) {
            PhpIndexImpl.$$$reportNull$$$0(105);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            List<PhpPathInfo> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(106);
            }
            return list;
        }
        String classFQN = containingClass.getFQN();
        String methodAccess = method.getAccess().toString();
        List result = ((StreamEx)StreamEx.of((Object[])PhpModifier.Access.values()).map(PhpModifier.Access::toString).filter(access -> !StringUtil.equals((CharSequence)methodAccess, (CharSequence)access))).map(access -> PhpPathInfo.byAccess(classFQN, access, true)).toList();
        result.add(PhpPathInfo.byMethod(classFQN, method.getName()));
        result.add(PhpPathInfo.byAccess(classFQN, methodAccess, false));
        result.add(PhpPathInfo.byClass(classFQN));
        List list = result;
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(107);
        }
        return list;
    }

    public Collection<PhpClass> getTraitUsages(PhpClass me) {
        ArrayList<PhpClass> usages = new ArrayList<PhpClass>();
        Collection<String> traitUsagesByName = this.getTraitUsagesByFQN(me.getFQN());
        for (String usage : traitUsagesByName) {
            usages.addAll(this.getClassesByFQN(usage));
            usages.addAll(this.getTraitsByFQN(usage));
        }
        return usages;
    }

    public Collection<PhpClass> getNestedTraitUsages(PhpClass me, @Nullable Collection<String> _visited) {
        String fqn;
        SmartList result = new SmartList();
        THashSet visited = _visited != null ? _visited : new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (!visited.add(fqn = me.getFQN())) {
            return result;
        }
        Collection<PhpClass> direct = this.getTraitUsages(me);
        for (PhpClass aDirect : direct) {
            result.add(aDirect);
            if (!aDirect.isTrait()) continue;
            Collection<PhpClass> usages = this.getNestedTraitUsages(aDirect, (Collection<String>)visited);
            result.addAll(usages);
        }
        PhpClassHierarchyUtils.processSupers((PhpClass)me, (boolean)false, (boolean)true, arg_0 -> PhpIndexImpl.lambda$getNestedTraitUsages$10((Collection)visited, me, (Collection)result, arg_0));
        return result;
    }

    public boolean processNestedTraitUsages(PhpClass me, @Nullable Collection<String> _visited, Processor<? super PhpClass> processor) {
        String fqn;
        THashSet visited = _visited != null ? _visited : new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (!visited.add(fqn = me.getFQN())) {
            return true;
        }
        Collection<PhpClass> direct = this.getTraitUsages(me);
        for (PhpClass aDirect : direct) {
            if (!processor.process((Object)aDirect)) {
                return false;
            }
            if (!aDirect.isTrait() || this.processNestedTraitUsages(aDirect, (Collection<String>)visited, processor)) continue;
            return false;
        }
        PhpClassHierarchyUtils.processSupers((PhpClass)me, (boolean)false, (boolean)true, arg_0 -> PhpIndexImpl.lambda$processNestedTraitUsages$11((Collection)visited, me, processor, arg_0));
        return true;
    }

    protected List<String> filterKeys(Collection<String> keys, ID id) {
        return ContainerUtil.filter(keys, key -> this.belongToProject(id, (String)key));
    }

    private boolean belongToProject(@NotNull ID id, @NotNull String key) {
        if (id == null) {
            PhpIndexImpl.$$$reportNull$$$0(108);
        }
        if (key == null) {
            PhpIndexImpl.$$$reportNull$$$0(109);
        }
        return !FileBasedIndex.getInstance().getContainingFiles(id, (Object)key, this.getSearchScope()).isEmpty();
    }

    private static /* synthetic */ boolean lambda$processNestedTraitUsages$11(Collection visited, PhpClass me, Processor processor, PhpClass aClass) {
        return visited.add(me.getFQN()) && processor.process((Object)me);
    }

    private static /* synthetic */ boolean lambda$getNestedTraitUsages$10(Collection visited, PhpClass me, Collection result, PhpClass aClass) {
        if (visited.add(me.getFQN())) {
            result.add(me);
        }
        return true;
    }

    private /* synthetic */ void lambda$getClasses$3(Collection classes, String s) {
        classes.addAll(this.getAnyByFQN(s));
    }

    private static /* synthetic */ boolean lambda$getTypeMethods$2(Set allSupers, PhpClass aClass) {
        return allSupers.add(aClass.getFQN().toLowerCase());
    }

    private static /* synthetic */ boolean lambda$getAllChildNamespacesFqns$1(@NotNull String parentNamespaceFqn, Set result, String childFqn) {
        if (parentNamespaceFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(111);
        }
        if (childFqn.length() > parentNamespaceFqn.length() && childFqn.startsWith(parentNamespaceFqn)) {
            result.add(childFqn);
        }
        return true;
    }

    static {
        ARRAY_VALUE_PROVIDERS.put("\\Iterator", "#M#C*.current");
        ARRAY_VALUE_PROVIDERS.put("\\Traversable", "#M#C*.__iterator");
        ARRAY_VALUE_PROVIDERS.put("\\IteratorAggregate", "#E#M#C*.getIterator");
        ARRAY_VALUE_PROVIDERS.put("\\ArrayAccess", "#M#C*.offsetGet");
        ARRAY_KEY_PROVIDERS = new LinkedHashMap();
        ARRAY_KEY_PROVIDERS.put("\\Iterator", "#M#C*.key");
        ARRAY_KEY_PROVIDERS.put("\\IteratorAggregate", "#Y#M#C*.getIterator");
        ARRAY_KEY_PROVIDERS.put("\\ArrayAccess", "#M#C*.offsetGet");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 107: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 107: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpIndexImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypeInput";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNamespaceFqn";
                break;
            }
            case 54: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSign";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 86: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 96: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassFqn";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 100: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpIndexImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByNamespace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "completeThis";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "completeType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChildNamespacesFqns";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConstantNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariableNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFunctionNames";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassFqns";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfacesFqns";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAliasesNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfaceNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTraitNames";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNamespacesByParentName";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitUsagesByFQN";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseAliasesByReferenceName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsByFQN";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsByName";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesByName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsByName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsByFQN";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesByName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByNameInScope";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectSubclasses";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubclasses";
                break;
            }
            case 55: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignatureInternal";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMethods";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getByFQN";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getByName";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByFQN";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesByFQN";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitsByFQN";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyByFQN";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringTestClasses";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethods";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringTestMethods";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterByNamespace";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 107: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "completeThis";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "completeType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllChildNamespacesFqns";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getBySignature";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getBySignatureInternal";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMethods";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getByName";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringTestClasses";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethods";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringTestMethods";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringPaths";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "belongToProject";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestMethods$5";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllChildNamespacesFqns$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 107: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectFilteredUniquesProcessor
    extends CommonProcessors.CollectUniquesProcessor<String> {
        private final PrefixMatcher myPrefixMatcher;

        CollectFilteredUniquesProcessor(PrefixMatcher prefixMatcher) {
            this.myPrefixMatcher = prefixMatcher;
        }

        public boolean process(String s) {
            if (this.myPrefixMatcher != null && !this.myPrefixMatcher.prefixMatches(s)) {
                return true;
            }
            return super.process((Object)s);
        }
    }
}

