/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassAliasImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    private static final TokenSet STRINGS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE});

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        PhpClassAliasUtil.ExtractResult result;
        FunctionReference reference;
        if (element == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType(element, STRINGS) && (reference = (FunctionReference)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (result = PhpClassAliasUtil.extractClassAlias((FunctionReference)reference)) != null) {
            VirtualFile file = reference.getContainingFile().getVirtualFile();
            return new PhpClassAliasImpl(result.getAliasFqn(), result.getOriginalFqn(), reference.getProject(), file, (Lazy<? extends FunctionReference>)LazyKt.lazyOf((Object)reference));
        }
        return super.getNamedElement(element);
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference reference, int flags) {
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        return PhpTargetElementEvaluator.getElementByReference(reference);
    }

    @Nullable
    public static PhpUse getElementByReference(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (reference instanceof PhpReference && ((PhpReference)reference).isAbsolute()) {
            return null;
        }
        PsiElement element = reference.getElement();
        PsiFile file = element.getContainingFile();
        if (file instanceof PhpFile) {
            String canonicalText = reference.getCanonicalText();
            String text = reference instanceof PhpDocType ? StringUtil.trimEnd((String)canonicalText, (String)"[]") : canonicalText;
            return StreamEx.of((Collection)((PhpFile)file).getTopLevelDefs().values()).select(PhpUse.class).findFirst(declaration -> {
                if (reference == null) {
                    PhpTargetElementEvaluator.$$$reportNull$$$0(4);
                }
                return PhpTargetElementEvaluator.referenceToAlias(reference, element, text, declaration);
            }).orElse(null);
        }
        return null;
    }

    private static boolean referenceToAlias(@NotNull PsiReference reference, PsiElement element, String text, PhpUse use) {
        if (reference == null) {
            PhpTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        if (PhpTargetElementEvaluator.equals(text, use.getAliasName(), reference instanceof ConstantReference) && PhpCodeInsightUtil.findScopeForUseOperator(element) == PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)use)) {
            PhpUseList useList = PhpUseImpl.getUseList(element);
            if (useList != null) {
                return useList.isTraitImport();
            }
            if (PhpUseImpl.isOfFunction(use)) {
                return reference instanceof FunctionReference;
            }
            if (PhpUseImpl.isOfConst(use)) {
                return reference instanceof ConstantReference;
            }
            if (element instanceof PhpNamespaceReference) {
                return reference.getRangeInElement().getStartOffset() == 0 && !(element.getParent() instanceof PhpNamespace);
            }
            return reference instanceof ClassReference || reference instanceof PhpDocType;
        }
        return false;
    }

    private static boolean equals(String text, String aliasName, boolean caseSensitive) {
        return caseSensitive ? PhpLangUtil.equals(text, aliasName) : PhpLangUtil.equalsIgnoreCase(text, aliasName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/PhpTargetElementEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementByReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "referenceToAlias";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getElementByReference$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

