/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIdeDebugProcess<S extends PhpDebugConnection>
extends PhpDebugProcess<S> {
    private final String mySessionId;
    protected final PhpDebugConnectionManager<S> myConnectionsManager;
    private final Alarm myAlarm;
    private final Object myLock;

    protected PhpIdeDebugProcess(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<S> debugConnectionsManager, @NotNull PhpDebugDriver<S> driver, @NotNull PhpDebugStrategy strategy, @Nullable ConsoleView console) {
        if (session == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(0);
        }
        if (sessionId == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(1);
        }
        if (debugConnectionsManager == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(2);
        }
        if (driver == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(3);
        }
        if (strategy == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(4);
        }
        this(session, sessionId, debugConnectionsManager, driver, strategy, console, false);
    }

    protected PhpIdeDebugProcess(@NotNull XDebugSession session, @NotNull String sessionId, @NotNull PhpDebugConnectionManager<S> debugConnectionsManager, @NotNull PhpDebugDriver<S> driver, @NotNull PhpDebugStrategy strategy, @Nullable ConsoleView console, boolean withExternalStdout) {
        if (session == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(5);
        }
        if (sessionId == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(6);
        }
        if (debugConnectionsManager == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(7);
        }
        if (driver == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(8);
        }
        if (strategy == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(9);
        }
        super(session, driver, strategy, console, withExternalStdout);
        this.myLock = new Object();
        Disposer.register((Disposable)this, debugConnectionsManager);
        this.mySessionId = sessionId;
        this.myConnectionsManager = debugConnectionsManager;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public String getCurrentStateMessage() {
        if (this.isConnected()) {
            return PhpBundle.message("debug.process.status.connected", new Object[0]);
        }
        if (this.getSession().isStopped()) {
            return PhpBundle.message("debug.process.status.disconnected", new Object[0]);
        }
        return PhpBundle.message("debug.process.status.wait", this.getSessionIdName(), this.mySessionId);
    }

    @Override
    public void sessionInitialized() {
        super.sessionInitialized();
        this.updateConnection();
    }

    public void updateConnection() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            PhpDebugConnection currentConnection = null;
            Object object = this.myLock;
            synchronized (object) {
                if (!this.isConnected() && !this.isStopped()) {
                    currentConnection = (PhpDebugConnection)this.myConnectionsManager.getCurrentConnection();
                }
            }
            if (currentConnection != null) {
                if (this.ignoreConnection(currentConnection)) {
                    currentConnection.startDetach();
                } else {
                    this.connect(currentConnection);
                }
            }
            if (!this.isStopped() || !this.getSession().isStopped()) {
                this.updateConnection();
            }
        }, 100);
    }

    protected boolean ignoreConnection(@NotNull S currentConnection) {
        if (currentConnection == null) {
            PhpIdeDebugProcess.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugConnectionsManager";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentConnection";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpIdeDebugProcess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

