/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.settingsBroadcasting;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.util.connection.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ZendDebuggerBroadcastingServer
extends ServerConnection {
    private static final String RESPONSE_HEADER = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n";
    public static final String DESCRIPTIVE_NAME = PhpBundle.message("debug.zend.debugger.settings.broadcasting", new Object[0]);
    private static final String REFERENCE_PREFIX = "Referer: ";
    private static final String ZEND_SERVER = "ZendServer";
    private volatile Socket mySocket;
    private final Project myProject;
    private final int myZendDebuggerPort;
    private final Object myLock;
    private final List<PhpDebugExternalConnectionsAccepter> myConnectionListeners;

    public ZendDebuggerBroadcastingServer(@NotNull Project project, int port) {
        if (project == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myConnectionListeners = new ArrayList<PhpDebugExternalConnectionsAccepter>();
        this.myProject = project;
        this.myZendDebuggerPort = port;
    }

    @Override
    protected void registerSocket(@NotNull Socket socket) {
        if (socket == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(1);
        }
        this.mySocket = socket;
    }

    @Override
    protected void stopSocketListening(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(2);
        }
        socket.shutdownOutput();
    }

    @Override
    public synchronized void stopListening() {
        if (this.mySocket != null && this.mySocket.isOutputShutdown()) {
            Socket socket = this.mySocket;
            this.mySocket = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.stopListening();
    }

    @Override
    protected void handle(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(3);
        }
        String settingsRequest = ZendDebuggerBroadcastingServer.readSettingsRequest(socket);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(this.createResponse(settingsRequest).getBytes());
        outputStream.flush();
    }

    private static String readSettingsRequest(@NotNull Socket socket) throws IOException {
        byte[] buffer;
        InputStream input;
        int read;
        if (socket == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(4);
        }
        return (read = (input = socket.getInputStream()).read(buffer = new byte[512])) > 0 ? new String(buffer) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) throws ExecutionException {
        if (connectionsListener == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getStatus()) {
                case STARTED: {
                    this.myConnectionListeners.add(connectionsListener);
                    break;
                }
                case STOPPED: {
                    throw new ExecutionException("Cannot register handler");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) {
        if (connectionsListener == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionListeners.remove(connectionsListener);
            this.tryStop();
        }
    }

    private void tryStop() {
        if (this.myConnectionListeners.size() == 0) {
            this.stopListening();
        }
    }

    @NotNull
    private String createResponse(@NotNull String input) {
        if (input == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(7);
        }
        String host = PhpProjectDebugConfiguration.getInstance(this.myProject).getZendDebuggerHost();
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append(RESPONSE_HEADER);
        if (ZendDebuggerBroadcastingServer.isZRayRequest(input)) {
            responseBuilder.append("var zendStudioSettings = {'");
            responseBuilder.append("debug_port");
            responseBuilder.append("':");
            responseBuilder.append(this.myZendDebuggerPort);
            responseBuilder.append(",'use_ssl':0,'");
            responseBuilder.append("debug_host");
            responseBuilder.append("':'");
            responseBuilder.append(host);
            responseBuilder.append("','debug_fastfile':1,'use_tunneling':0}\n");
            responseBuilder.append("\n");
        } else {
            responseBuilder.append('&');
            responseBuilder.append("debug_port");
            responseBuilder.append("=");
            responseBuilder.append(this.myZendDebuggerPort);
            responseBuilder.append('&');
            responseBuilder.append("debug_host");
            responseBuilder.append("=");
            responseBuilder.append(host);
            responseBuilder.append("&debug_fastfile=1&use_tunneling=0");
            responseBuilder.append("\r\n\r\n");
        }
        String string = responseBuilder.toString();
        if (string == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isZRayRequest(@NotNull String settingsRequest) {
        int start;
        if (settingsRequest == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(9);
        }
        if ((start = settingsRequest.indexOf(REFERENCE_PREFIX)) == -1) {
            return false;
        }
        String request = settingsRequest.substring(start + REFERENCE_PREFIX.length());
        return StringUtil.contains((CharSequence)request, (CharSequence)ZEND_SERVER);
    }

    @Override
    @NotNull
    public String getDescriptiveName() {
        String string = DESCRIPTIVE_NAME;
        if (string == null) {
            ZendDebuggerBroadcastingServer.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int getZendDebuggerPort() {
        return this.myZendDebuggerPort;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsListener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/settingsBroadcasting/ZendDebuggerBroadcastingServer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/settingsBroadcasting/ZendDebuggerBroadcastingServer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createResponse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerSocket";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopSocketListening";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettingsRequest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerExternalConnectionListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExternalConnectionListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createResponse";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isZRayRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

