/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCodeEditUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.lang.psi.PhpCodeEditUtil");

    private PhpCodeEditUtil() {
    }

    @NotNull
    public static Statement putStatementBefore(@NotNull PsiElement point, @NotNull Statement statement) {
        PsiElement anchor;
        if (point == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(1);
        }
        if ((anchor = PsiTreeUtil.getParentOfType((PsiElement)point, Statement.class, (boolean)false)) instanceof PhpCase) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)anchor, Statement.class, (boolean)true);
        }
        if (anchor instanceof GroupStatement) {
            anchor = PhpCodeEditUtil.findChildAncestor(anchor, point);
        }
        assert (anchor != null);
        PsiElement parent = anchor.getParent();
        if (parent instanceof Statement && !(parent instanceof GroupStatement)) {
            PsiElement anchorStatementCopy = anchor.copy();
            Project project = point.getProject();
            GroupStatement groupStatement = (GroupStatement)anchor.replace((PsiElement)PhpPsiElementFactory.createFromText(project, GroupStatement.class, "if(true){}"));
            anchor = groupStatement.addAfter(anchorStatementCopy, groupStatement.getFirstChild());
        }
        Statement statement2 = (Statement)anchor.getParent().addBefore((PsiElement)statement, anchor);
        if (statement2 == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(2);
        }
        return statement2;
    }

    @NotNull
    public static PsiElement findChildAncestor(@NotNull PsiElement outerElement, @NotNull PsiElement innerElement) {
        if (outerElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(3);
        }
        if (innerElement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(4);
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)outerElement, (PsiElement)innerElement, (boolean)true));
        for (PsiElement curElement = outerElement.getFirstChild(); curElement != null; curElement = curElement.getNextSibling()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)curElement, (PsiElement)innerElement, (boolean)false)) continue;
            PsiElement psiElement = curElement;
            if (psiElement == null) {
                PhpCodeEditUtil.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        assert (false);
        if (null == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(6);
        }
        return null;
    }

    public static boolean deleteExpression(@NotNull PhpExpression expression) {
        PsiElement parent;
        IElementType parentType;
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(7);
        }
        if (PhpElementTypes.STATEMENT.equals(parentType = (parent = expression.getParent()).getNode().getElementType())) {
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling instanceof PsiWhiteSpace) {
                nextSibling.delete();
            }
            parent.getParent().deleteChildRange(parent, parent);
            return true;
        }
        return false;
    }

    @NotNull
    public static PhpExpression parenthesize(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(8);
        }
        Project project = expression.getProject();
        String newText = "(" + expression.getText() + ")";
        PhpExpression phpExpression = (PhpExpression)PhpPsiElementFactory.createPhpPsiFromText(project, ParenthesizedExpression.class, newText);
        if (phpExpression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(9);
        }
        return phpExpression;
    }

    @NotNull
    public static UnaryExpression negate(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(10);
        }
        String expressionText = expression.getText();
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append("!");
        if (!(expression instanceof PhpReference) && !(expression instanceof ParenthesizedExpression)) {
            textBuilder.append("(").append(expressionText).append(")");
        } else {
            textBuilder.append(expressionText);
        }
        UnaryExpression unaryExpression = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), UnaryExpression.class, textBuilder.toString());
        if (unaryExpression == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(11);
        }
        return unaryExpression;
    }

    public static boolean needToParenthesizeWhenReplace(@NotNull PsiElement elementToBeReplaced, @NotNull PsiElement elementToReplace) {
        PsiElement parent;
        if (elementToBeReplaced == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(12);
        }
        if (elementToReplace == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(13);
        }
        if (!((parent = elementToBeReplaced.getParent()) instanceof PhpExpression)) {
            return false;
        }
        if (elementToReplace instanceof UnaryExpression) {
            return true;
        }
        if (parent instanceof BinaryExpression) {
            if (elementToReplace instanceof BinaryExpression) {
                IElementType elementToReplaceOperationType;
                IElementType parentOperationType = ((BinaryExpression)parent).getOperationType();
                if (parentOperationType == (elementToReplaceOperationType = ((BinaryExpression)elementToReplace).getOperationType())) {
                    return !PhpCodeInsightUtil.tsASSOCIATIVE_OPS.contains(parentOperationType);
                }
                return true;
            }
        } else if (parent instanceof UnaryExpression) {
            return true;
        }
        return false;
    }

    public static PsiElement replace(@NotNull PsiElement elementToBeReplaced, @NotNull PhpExpression elementToReplace) {
        if (elementToBeReplaced == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(14);
        }
        if (elementToReplace == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(15);
        }
        if (PhpCodeEditUtil.needToParenthesizeWhenReplace(elementToBeReplaced, (PsiElement)elementToReplace)) {
            return elementToBeReplaced.replace((PsiElement)PhpCodeEditUtil.parenthesize(elementToReplace));
        }
        return elementToBeReplaced.replace((PsiElement)elementToReplace);
    }

    public static boolean isEquivalent(@NotNull PsiElement sample, @NotNull PsiElement element) {
        if (sample == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(17);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sample, (PsiElement)element)) {
            return true;
        }
        if (sample instanceof StringLiteralExpression && element instanceof StringLiteralExpression) {
            String sampleString = PhpCodeInsightUtil.toString((StringLiteralExpression)sample);
            if (sampleString == null) {
                return false;
            }
            return sampleString.equals(PhpCodeInsightUtil.toString((StringLiteralExpression)element));
        }
        return false;
    }

    public static void replaceNamespaceReference(@NotNull PhpPsiElement classReference, @Nullable String newNamespaceQualifiedName) {
        if (classReference == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(18);
        }
        PhpNamespaceReference namespaceReference = (PhpNamespaceReference)PsiTreeUtil.findChildOfType((PsiElement)classReference, PhpNamespaceReference.class);
        PhpCodeEditUtil.replaceNamespaceReference(classReference, newNamespaceQualifiedName, namespaceReference);
    }

    public static void replaceNamespaceReference(@NotNull PhpPsiElement classReference, @Nullable String newNamespaceQualifiedName, @Nullable PhpNamespaceReference namespaceReference) {
        PhpUseList useList;
        if (classReference == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(19);
        }
        if ((useList = PhpUseImpl.getUseList((PsiElement)classReference)) == null) {
            if (StringUtil.isEmpty((String)newNamespaceQualifiedName)) {
                if (namespaceReference != null) {
                    namespaceReference.delete();
                }
            } else if (PhpLangUtil.equals(newNamespaceQualifiedName, "\\")) {
                Project project = classReference.getProject();
                String newReferenceText = newNamespaceQualifiedName + classReference.getName();
                Object newClassReference = classReference instanceof PhpDocPsiElement ? PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocType.class, "/*** @var " + newReferenceText + " */\n") : PhpPsiElementFactory.createClassReference(project, newReferenceText);
                classReference.replace((PsiElement)newClassReference);
            } else {
                Project project = classReference.getProject();
                PhpNamespaceReference newNamespaceReference = classReference instanceof PhpDocPsiElement ? PhpPsiElementFactory.createNamespaceReference(project, newNamespaceQualifiedName, true) : PhpPsiElementFactory.createNamespaceReference(project, newNamespaceQualifiedName, false);
                if (namespaceReference != null) {
                    namespaceReference.replace((PsiElement)newNamespaceReference);
                } else {
                    classReference.addBefore(PsiTreeUtil.firstChild((PsiElement)classReference), (PsiElement)newNamespaceReference);
                }
            }
        } else {
            PhpCodeEditUtil.replaceNamespaceReferenceForUse(StringUtil.notNullize((String)newNamespaceQualifiedName), (PsiElement)classReference, true);
        }
    }

    public static void replaceNamespaceReferenceForUse(@NotNull String newNamespaceQualifiedName, @NotNull PsiElement nsReferenceHolder, boolean updateGlobalName) {
        block4: {
            PhpPsiElement scope;
            PhpUseList useList;
            String newNamespaceName;
            block8: {
                String newFullName;
                PhpUse use;
                block9: {
                    PhpNamespaceReference namespaceReference;
                    block7: {
                        block6: {
                            block5: {
                                if (newNamespaceQualifiedName == null) {
                                    PhpCodeEditUtil.$$$reportNull$$$0(20);
                                }
                                if (nsReferenceHolder == null) {
                                    PhpCodeEditUtil.$$$reportNull$$$0(21);
                                }
                                newNamespaceName = PhpLangUtil.concat(newNamespaceQualifiedName, "\\");
                                useList = PhpUseImpl.getUseList(nsReferenceHolder);
                                if (useList == null) break block4;
                                namespaceReference = useList.getNamespaceReference();
                                if (namespaceReference != null) break block5;
                                PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName);
                                break block4;
                            }
                            use = (PhpUse)PhpPsiUtil.getParentByCondition(nsReferenceHolder, true, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                            String globalName = namespaceReference.getFullName();
                            if (use == null || !newNamespaceName.startsWith(globalName)) break block6;
                            PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName.substring(globalName.length()));
                            break block4;
                        }
                        if (!updateGlobalName || use != null || "\\".equals(newNamespaceName)) break block7;
                        PhpCodeEditUtil.updateSingleReference(nsReferenceHolder, newNamespaceName);
                        break block4;
                    }
                    if (use == null) break block8;
                    String localName = PhpUseImpl.getReferenceText(use);
                    String className = PhpLangUtil.toShortName(use.getFQN());
                    newFullName = PhpLangUtil.concat(newNamespaceName, className);
                    int offset = newFullName.length() - localName.length();
                    if (!updateGlobalName || !newFullName.endsWith(localName) || offset == 0 || "\\".equals(newNamespaceName)) break block9;
                    PhpCodeEditUtil.replaceReference(newFullName.substring(0, offset), (PsiElement)namespaceReference);
                    break block4;
                }
                PhpPsiElement scope2 = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)useList);
                if (scope2 == null) break block4;
                PhpCodeEditUtil.createNewUseAndDeleteOld(use, useList, newFullName, scope2);
                break block4;
            }
            if ("\\".equals(newNamespaceName) && (scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)useList)) != null) {
                for (PhpUse phpUse : useList.getDeclarations()) {
                    PhpCodeEditUtil.createNewUseAndDeleteOld(phpUse, useList, PhpUseImpl.getReferenceText(phpUse), scope);
                }
            }
        }
    }

    private static void createNewUseAndDeleteOld(@NotNull PhpUse use, @NotNull PhpUseList useList, @NotNull String newFullName, @NotNull PhpPsiElement scope) {
        if (use == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(22);
        }
        if (useList == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(23);
        }
        if (newFullName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(25);
        }
        String keyword = PhpGroupUseElement.getKeyword(use, useList);
        String alias = use.getAliasName();
        PhpAliasImporter.insertUseStatementWithKeyword(keyword, PhpLangUtil.toFQN(newFullName), alias, scope);
        PhpCodeEditUtil.deleteUseOrUseList(use, useList);
    }

    private static void updateSingleReference(@NotNull PsiElement nsReferenceHolder, @NotNull String newNamespaceName) {
        PsiElement reference;
        if (nsReferenceHolder == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(26);
        }
        if (newNamespaceName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(27);
        }
        if ((reference = PhpPsiUtil.getChildOfType(nsReferenceHolder, PhpElementTypes.NS_REFERENCE)) != null) {
            PhpCodeEditUtil.replaceReference(newNamespaceName, reference);
        } else {
            PsiElement identifier = PhpPsiUtil.getChildOfType(nsReferenceHolder, PhpTokenTypes.IDENTIFIER);
            if (identifier != null) {
                Project project = nsReferenceHolder.getProject();
                String name = PhpLangUtil.toName(newNamespaceName);
                nsReferenceHolder.addBefore((PsiElement)PhpPsiElementFactory.createNamespaceReference(project, name, false), identifier);
            }
        }
    }

    private static void replaceReference(@NotNull String newNamespaceName, @NotNull PsiElement reference) {
        String name;
        if (newNamespaceName == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(28);
        }
        if (reference == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(29);
        }
        if (StringUtil.isEmpty((String)(name = PhpLangUtil.toName(newNamespaceName)))) {
            reference.delete();
        } else {
            reference.replace((PsiElement)PhpPsiElementFactory.createNamespaceReference(reference.getProject(), name, false));
        }
    }

    public static void deleteUseOrUseList(@Nullable PhpUse use, @NotNull PhpUseList useList) {
        if (useList == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(30);
        }
        if (use == null) {
            useList.delete();
        } else {
            Object prev = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUse.INSTANCEOF);
            if (prev != null) {
                use.getParent().deleteChildRange(prev.getNextSibling(), (PsiElement)use);
            } else {
                Object next = PhpPsiUtil.getNextSiblingByCondition((PsiElement)use, (Condition<? super PsiElement>)PhpUse.INSTANCEOF);
                if (next != null) {
                    use.getParent().deleteChildRange((PsiElement)use, next.getPrevSibling());
                } else {
                    useList.delete();
                }
            }
        }
    }

    public static void removeStatementWithDelivery(@NotNull PsiElement element, @Nullable IElementType delivery) {
        PsiElement parentElement;
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(31);
        }
        if ((parentElement = element.getParent()) == null) {
            return;
        }
        if (delivery == null) {
            parentElement.deleteChildRange(element, element);
            return;
        }
        if (parentElement.getChildren().length == 1) {
            parentElement.delete();
            return;
        }
        PsiElement prevElement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true);
        if (PhpPsiUtil.isOfType(prevElement, delivery)) {
            PsiElement prevPrevElement = PhpPsiUtil.getPrevSibling(prevElement, new Condition[0]);
            parentElement.deleteChildRange(prevPrevElement instanceof PsiWhiteSpace ? prevPrevElement : prevElement, element);
        } else {
            PsiElement nextElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true);
            if (PhpPsiUtil.isOfType(nextElement, delivery)) {
                PsiElement nextNextElement = PhpPsiUtil.getNextSibling(nextElement, new Condition[0]);
                parentElement.deleteChildRange(element, nextNextElement instanceof PsiWhiteSpace ? nextNextElement : nextElement);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PsiElement insertDocMethodBeforeClass(@NotNull PhpClass clazz, PsiElement docMethod) {
        PhpDocComment docComment;
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(32);
        }
        if ((docComment = clazz.getDocComment()) != null) {
            PhpDocMethod[] methods = docComment.getMethods();
            int docOffset = docComment.getTextRange().getStartOffset();
            if (methods.length > 0) {
                PhpDocMethod method = methods[0];
                if (method == null) return null;
                PsiElement parent = method.getParent();
                int methodOffset = parent.getTextRange().getStartOffset();
                int offset = methodOffset - docOffset;
                return PhpCodeEditUtil.insertDocMethod(docMethod, docComment, offset, true);
            }
            int lastChildOffset = docComment.getLastChild().getTextRange().getStartOffset();
            int offset = lastChildOffset - docOffset;
            return PhpCodeEditUtil.insertDocMethod(docMethod, docComment, offset, false);
        }
        PhpDocComment element = PhpPsiElementFactory.createFromText(clazz.getProject(), PhpDocComment.class, " /**\n" + docMethod.getText() + "\n*/");
        if (element == null) return element;
        PsiElement parent = clazz.getParent();
        parent.addBefore((PsiElement)element, (PsiElement)clazz);
        PsiElement singleLineSeparator = element.getPrevSibling();
        if (!PhpPsiUtil.isOfType(singleLineSeparator, TokenType.WHITE_SPACE)) return element;
        parent.addBefore(singleLineSeparator, (PsiElement)clazz);
        return element;
    }

    private static PsiElement insertDocMethod(PsiElement docMethod, PhpDocComment docComment, int offset, boolean withAsteriks) {
        String text = docComment.getText();
        String firstPart = text.substring(0, offset);
        String secondPart = text.substring(offset);
        PhpDocComment newDoc = PhpPsiElementFactory.createFromText(docComment.getProject(), PhpDocComment.class, firstPart + docMethod.getText() + "\n" + (withAsteriks ? "* " : "") + secondPart);
        if (newDoc != null) {
            docComment.replace((PsiElement)newDoc);
        }
        return newDoc;
    }

    public static PsiElement insertClassMemberWithPhpDoc(@NotNull PhpClass clazz, @NotNull PsiElement member, @Nullable PhpDocComment comment) {
        PsiElement inserted;
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(33);
        }
        if (member == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(34);
        }
        if ((inserted = PhpCodeEditUtil.insertClassMember(clazz, member)) != null && comment != null) {
            inserted.getParent().addBefore((PsiElement)comment, inserted);
        }
        return inserted;
    }

    public static PsiElement insertClassMember(@NotNull PhpClass clazz, @NotNull PsiElement member) {
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(35);
        }
        if (member == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(36);
        }
        CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)clazz.getContainingFile(), (Language)PhpLanguage.INSTANCE);
        MemberOrderService service = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor(member, settings, (PsiElement)clazz);
        if (anchor == null || anchor == clazz) {
            return clazz.addBefore(member, PhpCodeEditUtil.getBeforeAnchorForClassMember(clazz));
        }
        return clazz.addAfter(member, anchor);
    }

    @Nullable
    private static PsiElement getBeforeAnchorForClassMember(@NotNull PhpClass clazz) {
        Field field;
        PsiElement firstChild;
        PsiElement firstMember;
        if (clazz == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(37);
        }
        PsiElement psiElement = firstMember = (firstChild = clazz.getFirstChild()) == null ? null : PhpPsiUtil.findNextSiblingOfAnyType(firstChild, new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS, PhpStubElementTypes.CLASS_METHOD});
        if (firstMember == null) {
            return clazz.getLastChild();
        }
        PhpDocComment comment = null;
        if (firstMember instanceof PhpNamedElement) {
            comment = ((PhpNamedElement)firstMember).getDocComment();
        } else if ((PhpPsiUtil.isOfType(firstMember, PhpElementTypes.CLASS_FIELDS) || PhpPsiUtil.isOfType(firstMember, PhpElementTypes.CLASS_CONSTANTS)) && (field = (Field)PhpPsiUtil.getChildByCondition(firstMember, (Condition<? super PsiElement>)Field.INSTANCEOF)) != null) {
            comment = field.getDocComment();
        }
        return comment == null ? firstMember : comment;
    }

    @Nullable
    public static PhpClass findClassAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(38);
        }
        if (file == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(39);
        }
        return (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PhpClass.class, (boolean)false);
    }

    @Deprecated
    public static void insertDocCommentBefore(@NotNull PsiElement element, @NotNull PhpDocComment docComment) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(40);
        }
        if (docComment == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(41);
        }
        PsiElement parent = element.getParent();
        PsiElement added = parent.addBefore((PsiElement)docComment, element);
        PhpCodeEditUtil.reformatDocComment(element.getProject(), parent, added);
    }

    public static TextRange insertDocCommentBeforeAndGetTextRange(@NotNull PsiElement element, @NotNull PhpDocComment docComment) {
        if (element == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(42);
        }
        if (docComment == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(43);
        }
        PsiElement parent = element.getParent();
        PsiElement added = parent.addBefore((PsiElement)docComment, element);
        return PhpCodeEditUtil.reformatDocComment(element.getProject(), parent, added);
    }

    private static TextRange reformatDocComment(Project project, PsiElement parent, PsiElement docComment) {
        if (docComment == null) {
            return null;
        }
        PsiFile psiFile = parent.getContainingFile();
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        Document doc = docManager.getDocument(psiFile);
        if (doc != null) {
            PsiElement docStart;
            RangeMarker rangeMarker = doc.createRangeMarker(docComment.getTextRange());
            if (docManager.isDocumentBlockedByPsi(doc)) {
                docManager.doPostponedOperationsAndUnblockDocument(doc);
                docManager.commitDocument(doc);
            }
            if (PhpPsiUtil.isOfType(docStart = psiFile.findElementAt(rangeMarker.getStartOffset()), PhpDocTokenTypes.DOC_COMMENT_START)) {
                ASTNode newDocNode = docStart.getParent().getNode();
                CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(newDocNode.getTreeParent(), newDocNode);
            }
            TextRange result = TextRange.create((int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset());
            rangeMarker.dispose();
            return result;
        }
        return docComment.getTextRange();
    }

    @Deprecated
    public static void insertUseStatement(@NotNull String fqn, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(44);
        }
        if (scopeForUseOperator == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(45);
        }
        PhpAliasImporter.insertUseStatement(fqn, scopeForUseOperator);
    }

    @Deprecated
    public static void insertUseStatement(@NotNull String fqn, @Nullable String alias, @NotNull PhpPsiElement scopeForUseOperator) {
        if (fqn == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(46);
        }
        if (scopeForUseOperator == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(47);
        }
        PhpAliasImporter.insertUseStatement(fqn, alias, scopeForUseOperator);
    }

    public static void setupMethodBody(@NotNull Project project) {
        Editor editor;
        if (project == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(48);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                PhpCodeEditUtil.$$$reportNull$$$0(51);
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Method method = (Method)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(caretModel.getOffset() - 1), Method.class, (boolean)false);
            GroupStatement methodBody = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class);
            if (methodBody == null) {
                return;
            }
            List<PsiElement> statements = PhpCodeEditUtil.collectStatements(methodBody);
            if (statements.isEmpty()) {
                PsiElement openBrace = PhpPsiUtil.getChildOfType((PsiElement)methodBody, PhpTokenTypes.chLBRACE);
                if (openBrace == null) {
                    return;
                }
                int offset = openBrace.getTextRange().getEndOffset();
                caretModel.moveToOffset(offset + 1);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.notNullize((String)CodeStyleManager.getInstance((Project)project).getLineIndent(file, offset)));
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n", (boolean)false, (boolean)false);
            } else {
                int startOffset = statements.get(0).getTextRange().getStartOffset();
                int endOffset = statements.get(statements.size() - 1).getTextRange().getEndOffset();
                caretModel.moveToOffset(startOffset);
                editor.getSelectionModel().setSelection(startOffset, endOffset);
            }
        });
    }

    @NotNull
    private static List<PsiElement> collectStatements(@NotNull GroupStatement bodyStatement) {
        if (bodyStatement == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(49);
        }
        List result = ContainerUtil.newSmartList();
        PsiElement s = bodyStatement.getFirstChild();
        while (s != null) {
            if (!PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) {
                result.add(s);
            }
            s = PhpPsiUtil.getNextSiblingIgnoreWhitespace(s, true);
        }
        List list = result;
        if (list == null) {
            PhpCodeEditUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpCodeEditUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerElement";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToBeReplaced";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 17: 
            case 31: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceQualifiedName";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsReferenceHolder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFullName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpCodeEditUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "putStatementBefore";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildAncestor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parenthesize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putStatementBefore";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 50: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChildAncestor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parenthesize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "needToParenthesizeWhenReplace";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceNamespaceReference";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceNamespaceReferenceForUse";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createNewUseAndDeleteOld";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleReference";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "deleteUseOrUseList";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeStatementWithDelivery";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "insertDocMethodBeforeClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "insertClassMemberWithPhpDoc";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "insertClassMember";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAnchorForClassMember";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findClassAtCaret";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "insertDocCommentBefore";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "insertDocCommentBeforeAndGetTextRange";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setupMethodBody";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "collectStatements";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setupMethodBody$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

