/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileReferenceSet
extends FileReferenceSet {
    private final boolean myFromPhar;
    private final PhpPsiElement argument;

    public PhpFileReferenceSet(@NotNull PsiElement element, @Nullable PhpPsiElement argument, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(PhpFileReferenceSet.cutTrailingSlashOrPharPrefix(FileUtil.toSystemIndependentName((String)PhpFilePathUtils.getStaticPath(argument))), element, PhpFileReferenceSet.getOffset(element, argument), provider, SystemInfo.isFileSystemCaseSensitive);
        String staticPath = PhpFilePathUtils.getStaticPath(argument);
        this.myFromPhar = staticPath.startsWith("phar://") || staticPath.contains(".phar");
        this.argument = argument;
    }

    private static int getOffset(PsiElement element, PhpPsiElement argument) {
        int offset = PhpFilePathUtils.getFilePathRelativeOffset(element.getTextOffset(), argument);
        String staticPath = PhpFilePathUtils.getStaticPath(argument);
        if (staticPath.startsWith("phar://")) {
            offset += "phar://".length();
        }
        return offset;
    }

    private static String cutTrailingSlashOrPharPrefix(String path) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        path = StringUtil.trimStart((String)path, (String)"phar://");
        return path;
    }

    protected boolean isSoft() {
        return false;
    }

    public PhpFileReference createFileReference(TextRange range, int index, String text) {
        return new PhpFileReference(this, range, index, text);
    }

    @NotNull
    public String getPathString() {
        String string = PhpFilePathUtils.getStaticPath(this.argument);
        if (string == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String pathString = PhpFilePathUtils.getFileName((PsiElement)this.argument);
        return PhpFileReferenceSet.isAbsolutePathAllowFileProtocol(pathString);
    }

    public static boolean isAbsolutePathAllowFileProtocol(String pathString) {
        if (pathString == null) {
            return false;
        }
        if ((pathString = StringUtil.trimStart((String)pathString, (String)"file://")).length() >= 1 && (pathString.charAt(0) == '/' || pathString.charAt(0) == '\\')) {
            return true;
        }
        return FileUtil.isAbsolute((String)pathString);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile containingFile = this.getElement().getContainingFile().getOriginalFile();
        if (!(containingFile instanceof PhpFile)) {
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                PhpFileReferenceSet.$$$reportNull$$$0(2);
            }
            return collection;
        }
        ArrayList files = ContainerUtil.newArrayList();
        String dynamicPath = PhpFilePathUtils.getDynamicPath(this.argument);
        if (!StringUtil.isEmptyOrSpaces((String)dynamicPath)) {
            if (!this.isAbsolutePathReference()) {
                PsiDirectory containingDirectory;
                block14: {
                    Collection collection;
                    try {
                        containingDirectory = containingFile.getContainingDirectory();
                        if (containingDirectory != null) break block14;
                        collection = super.computeDefaultContexts();
                    }
                    catch (Exception e) {
                        throw new Error(e.getClass().getName() + ": " + e.getMessage() + " while processing element " + this.getElement() + " '" + this.getElement().getText() + "'", e);
                    }
                    if (collection == null) {
                        PhpFileReferenceSet.$$$reportNull$$$0(3);
                    }
                    return collection;
                }
                VirtualFile file = containingDirectory.getVirtualFile();
                dynamicPath = file.getPath() + "/" + dynamicPath;
            }
            String target = PathUtil.getCanonicalPath((String)dynamicPath);
            files.add(VirtualFileManager.getInstance().findFileByUrl(containingFile.getVirtualFile().getFileSystem().getProtocol() + "://" + target));
        } else if (this.isAbsolutePathReference()) {
            ContainerUtil.addAll((Collection)files, (Object[])ManagingFS.getInstance().getLocalRoots());
            ContainerUtil.addAll((Collection)files, (Object[])new VirtualFile[]{containingFile.getVirtualFile().getFileSystem().findFileByPath("/")});
        } else {
            VirtualFile vFile = containingFile.getVirtualFile().getParent();
            if (vFile != null) {
                files.add(vFile);
            }
            if (!PhpFilePathUtils.getStaticPath(this.argument).startsWith("..")) {
                ContainerUtil.addAll((Collection)files, PhpIncludePathManager.getInstance(this.getElement().getProject()).getRoots());
            }
        }
        Collection collection = this.toFileSystemItems(files);
        if (collection == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    private static ResolveResult getCorrespondingPharFileResult(ResolveResult result) {
        PsiElement element = result.getElement();
        if (!(element instanceof PsiFile)) {
            return null;
        }
        VirtualFile vFile = ((PsiFile)element).getVirtualFile();
        if (vFile == null || !PharFileType.isPhar(vFile)) {
            return null;
        }
        VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(vFile.getPath());
        if (realPharFile == null) {
            return null;
        }
        PsiDirectory dir = element.getManager().findDirectory(realPharFile);
        if (dir == null) {
            return null;
        }
        return new PsiElementResolveResult((PsiElement)dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PhpFileReference
    extends FileReference {
        PhpFileReference(PhpFileReferenceSet set, TextRange range, int index, String text) {
            super((FileReferenceSet)set, range, index, text);
        }

        @Nullable
        public String getText() {
            String _path = PhpFilePathUtils.computeFilePath(super.getText(), super.getRangeInElement(), this.getElement().getNode(), this.getElement().getText());
            String text = FileUtil.toSystemIndependentName((String)_path);
            return text.endsWith("/") ? text.substring(0, text.length() - "/".length()) : text;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "File " + this.getCanonicalRepresentationText() + " does not exists";
            if (string == null) {
                PhpFileReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public String getCanonicalRepresentationText() {
            String value = this.getCanonicalText();
            return PhpFilePathUtils.computeFilePath(value, super.getRangeInElement(), this.getElement().getNode(), this.getElement().getText());
        }

        @NotNull
        protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                PhpFileReference.$$$reportNull$$$0(1);
            }
            ResolveResult[] results = super.innerResolve(caseSensitive, containingFile);
            if (PhpFileReferenceSet.this.myFromPhar) {
                for (int i = 0; i < results.length; ++i) {
                    ResolveResult result = results[i];
                    ResolveResult pharResult = PhpFileReferenceSet.getCorrespondingPharFileResult(result);
                    if (pharResult == null) continue;
                    results[i] = pharResult;
                }
            }
            if (results == null) {
                PhpFileReference.$$$reportNull$$$0(2);
            }
            return results;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpFileReference.$$$reportNull$$$0(3);
            }
            String text = this.getElement().getText();
            String newText = text.substring(0, this.getRangeInElement().getStartOffset()) + newElementName + text.substring(this.getRangeInElement().getEndOffset()) + ";";
            Object newElement = PhpPsiElementFactory.createFromText(this.getElement().getProject(), this.getElement().getClass(), newText);
            assert (newElement != null) : newText;
            return this.getElement().replace(newElement);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                PhpFileReference.$$$reportNull$$$0(4);
            }
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " '" + this.getText() + "' " + this.getRangeInElement() + " = <" + this.getRangeInElement().substring(this.getElement().getText()) + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet$PhpFileReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet$PhpFileReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "innerResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolve";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

