/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitTestRunLineMarkerProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement leaf) {
        PhpNamedElement element;
        if (leaf == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType(leaf, PhpTokenTypes.IDENTIFIER) && (element = (PhpNamedElement)ObjectUtils.tryCast((Object)leaf.getParent(), PhpNamedElement.class)) != null && element.getNameIdentifier() == leaf) {
            PhpClass containingClass;
            if (element instanceof PhpClass && PhpUnitUtil.isRunnableTestClass((PhpClass)element)) {
                return PhpUnitTestRunLineMarkerProvider.getInfo(PhpUnitTestRunLineMarkerProvider.getLocationHint((PhpClass)element), leaf.getProject(), true);
            }
            if (element instanceof Method && PhpUnitUtil.isTestMethod((Method)element) && (containingClass = ((Method)element).getContainingClass()) != null) {
                return PhpUnitTestRunLineMarkerProvider.getInfo(PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass, (Method)element), leaf.getProject(), false);
            }
        }
        return null;
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(String url, Project project, boolean isClass) {
        RunLineMarkerContributor.Info info = new RunLineMarkerContributor.Info(PhpUnitTestRunLineMarkerProvider.getTestStateIcon((String)url, (Project)project, (boolean)isClass), ExecutorAction.getActions((int)1), RunLineMarkerContributor.RUN_TEST_TOOLTIP_PROVIDER);
        if (info == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return info;
    }

    @NotNull
    private static String getLocationHint(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        String string = "php_qn://" + PhpUnitTestRunLineMarkerProvider.getFilePathDeploymentAware(phpClass) + "::" + phpClass.getFQN();
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getFilePathDeploymentAware(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        String localPath = phpClass.getContainingFile().getVirtualFile().getPath();
        PhpCommandLinePathProcessor remoteMapper = PhpUnitTestRunLineMarkerProvider.createPathMapper(phpClass.getProject());
        String string = remoteMapper.canProcess(localPath) ? remoteMapper.process(localPath) : localPath;
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static PhpCommandLinePathProcessor createPathMapper(@NotNull Project project) {
        PhpCommandLinePathProcessor phpCommandLinePathProcessor;
        PhpInterpreter interpreter;
        if (project == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        PhpSdkAdditionalData data = (interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter()) != null && interpreter.isRemote() ? interpreter.getPhpSdkAdditionalData() : null;
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        try {
            phpCommandLinePathProcessor = manager != null && data != null ? manager.createPathMapper(project, data) : PhpCommandLinePathProcessor.LOCAL;
        }
        catch (ExecutionException e) {
            PhpCommandLinePathProcessor phpCommandLinePathProcessor2 = PhpCommandLinePathProcessor.LOCAL;
            if (phpCommandLinePathProcessor2 == null) {
                PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(8);
            }
            return phpCommandLinePathProcessor2;
        }
        if (phpCommandLinePathProcessor == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(7);
        }
        return phpCommandLinePathProcessor;
    }

    @NotNull
    private static String getLocationHint(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (method == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(10);
        }
        String string = PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass) + "::" + method.getName();
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestRunLineMarkerProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestRunLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 3: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathDeploymentAware";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocationHint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathDeploymentAware";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

