/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureHandler
implements ChangeSignatureHandler {
    private static final String CAN_REFACTOR_ONLY_FUNCTIONS = PhpBundle.message("change.signature.error.wrong.caret.position", new Object[0]);

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiElement function;
        Object parameters;
        if (element == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if ((parameters = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)ParameterList.INSTANCEOF)) != null && (function = parameters.getParent()) instanceof Function) {
            return function;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof Function && (((Function)parent).getNameIdentifier() == element || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN))) {
            return parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        PhpChangeSignatureHandler.invokeOnElement(project, editor, element, context);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        PsiElement context = PhpChangeSignatureHandler.getContextElement(dataContext);
        PhpChangeSignatureHandler.invokeOnElement(project, editor, elements[0], context == null ? elements[0] : context);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return null;
    }

    @Nullable
    private static PsiElement getContextElement(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    private static void invokeOnElement(Project project, Editor editor, PsiElement element, PsiElement context) {
        String message = PhpChangeSignatureHandler.refactorStatus(project, element);
        if (StringUtil.isEmpty((String)message)) {
            Function newFunction = PhpChangeSignatureHandler.getSuperMethod((Function)element, REFACTORING_NAME, RefactoringBundle.message((String)"to.refactor"));
            if (newFunction == null) {
                return;
            }
            if (!newFunction.equals(element)) {
                PhpChangeSignatureHandler.invokeOnElement(project, editor, (PsiElement)newFunction, context);
            } else {
                PhpMethodDescriptor method = new PhpMethodDescriptor((Function)element);
                PhpChangeSignatureDialog dialog = new PhpChangeSignatureDialog(project, method, context);
                dialog.show();
            }
        } else {
            PhpChangeSignatureHandler.showErrorMessage(editor, element, message);
        }
    }

    @Nullable
    public static String refactorStatus(Project project, PsiElement element) {
        if (!(element instanceof Function)) {
            return RefactoringBundle.getCannotRefactorMessage((String)CAN_REFACTOR_ONLY_FUNCTIONS);
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            if (element.isPhysical()) {
                String message = RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)element)});
                return RefactoringBundle.getCannotRefactorMessage((String)message);
            }
            if (!element.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.common.file.read.only", new Object[0]));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)element)) {
            String message = RefactoringBundle.message((String)"error.in.injected.lang.prefix.suffix", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)element)});
            return RefactoringBundle.getCannotRefactorMessage((String)message);
        }
        return null;
    }

    private static void showErrorMessage(Editor editor, PsiElement element, String message) {
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
    }

    @Nullable
    protected static Function getSuperMethod(@Nullable Function function, String actionTitle, String questionText) {
        Method method;
        PhpClass clazz;
        PhpClass phpClass = clazz = function instanceof Method ? ((Method)function).getContainingClass() : null;
        if (clazz == null) {
            return function;
        }
        Method deepestSuperMethod = PhpChangeSignatureUsageSearcher.findDeepestSuperMethod(method, (method = (Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR);
        if (deepestSuperMethod == null) {
            return function;
        }
        assert (deepestSuperMethod instanceof Method);
        Method superMethod = deepestSuperMethod;
        PhpClass baseClass = superMethod.getContainingClass();
        assert (baseClass != null);
        String functionText = PhpFunctionCodeGenerator.CALL.generate((Function)method);
        String message = PhpBundle.message(baseClass.isInterface() ? "change.signature.find.usages.of.base.interface" : "change.signature.find.usages.of.base.class", functionText, PhpChangeSignatureHandler.getFormattedClass(clazz), PhpChangeSignatureHandler.getFormattedClass(baseClass), questionText);
        int choice = ApplicationManagerEx.getApplicationEx().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)actionTitle, (Icon)Messages.getQuestionIcon());
        switch (choice) {
            case 0: {
                return deepestSuperMethod;
            }
            case 1: {
                return function;
            }
        }
        return null;
    }

    private static String getFormattedClass(PhpClass clazz) {
        String namespaceName = clazz.getNamespaceName();
        return clazz.getName() + ("\\".equals(namespaceName) ? "" : " (" + namespaceName + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

