/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Alarm;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DialogWrapperWithValidation
extends DialogWrapper {
    private static final int VALIDATION_DELAY = 400;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    protected final Project myProject;

    protected DialogWrapperWithValidation(Project project) {
        super(project);
        this.myProject = project;
    }

    protected void init() {
        super.init();
        this.setOKActionEnabled(this.isOKActionEnabledOnInit());
    }

    @NotNull
    protected abstract ValidationResult doValidateForm();

    protected abstract boolean isOKActionEnabledOnInit();

    private boolean doValidation() {
        ValidationResult result = this.doValidateForm();
        this.setOKActionEnabled(result.isValid());
        this.setErrorText(result.getErrorMessage());
        return result.isValid();
    }

    protected final void doOKAction() {
        if (!this.doValidation()) {
            return;
        }
        super.doOKAction();
    }

    protected final void scheduleInitialValidation() {
        SwingUtilities.invokeLater(() -> this.scheduleValidation());
    }

    protected final void scheduleValidation() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.doValidation(), this.getValidationDelay(), ModalityState.current());
    }

    protected int getValidationDelay() {
        return 400;
    }

    @Nullable
    public final Project getProject() {
        return this.myProject;
    }

    public static class ValidationResult {
        public static final ValidationResult VALID = new ValidationResult(true, null);
        private final boolean myIsValid;
        private final String myErrorMessage;

        public ValidationResult(boolean valid, @Nullable String errorMessage) {
            this.myIsValid = valid;
            this.myErrorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @Nullable
        public String getErrorMessage() {
            return this.myErrorMessage;
        }
    }
}

