/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffLineSeparatorRenderer
implements LineMarkerRendererEx,
LineSeparatorRenderer {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    public static final ColorKey BACKGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BACKGROUND");

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull BooleanGetter condition) {
        if (editor == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myCondition = condition;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(2);
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        int start1 = y1 + (lineHeight - height - step) / 2 + step / 2;
        int start2 = y2 + (lineHeight - height - step) / 2 + step / 2;
        int end1 = start1 + height - 1;
        int end2 = start2 + height - 1;
        Color color = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
        DiffDrawUtil.drawCurveTrapezium(g, x1, x2, start1, end1, start2, end2, color, null);
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            g.setColor(editor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND));
            g.fillRect(annotationsOffset, y, annotationsWidth, lineHeight);
        }
        DiffLineSeparatorRenderer.draw(g, 0, y, lineHeight, this.myEditor.getColorsScheme());
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        if (!this.myCondition.get()) {
            return;
        }
        ++y;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        int interval = DiffLineSeparatorRenderer.getStepSize(lineHeight) * 2;
        int shiftX = -interval;
        if (DiffUtil.isMirrored(this.myEditor)) {
            int contentWidth = ((EditorEx)this.myEditor).getScrollPane().getViewport().getWidth();
            shiftX += contentWidth % interval - interval;
            shiftX += gutterWidth % interval - interval;
        } else {
            shiftX += -gutterWidth % interval - interval;
        }
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, this.myEditor.getColorsScheme());
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(3);
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(4);
        }
        int step = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        Rectangle clip = g.getClipBounds();
        if (clip.width <= 0) {
            return;
        }
        int count = clip.width / step + 3;
        int shift = (clip.x - shiftX) / step;
        int[] xPoints = new int[count];
        int[] yPoints = new int[count];
        shiftY += (lineHeight - height - step) / 2;
        for (int index = 0; index < count; ++index) {
            int absIndex = index + shift;
            int xPos = absIndex * step + shiftX;
            int yPos = absIndex == 0 ? step / 2 + shiftY : (absIndex % 2 == 0 ? shiftY : step + shiftY);
            xPoints[index] = xPos;
            yPoints[index] = yPos;
        }
        GraphicsConfig config2 = GraphicsUtil.disableAAPainting((Graphics)g);
        try {
            DiffLineSeparatorRenderer.paintLine(g, xPoints, yPoints, lineHeight, scheme2);
        }
        finally {
            config2.restore();
        }
    }

    private static void paintLine(@NotNull Graphics g, @NotNull int[] xPoints, @NotNull int[] yPoints, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(5);
        }
        if (xPoints == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(6);
        }
        if (yPoints == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(7);
        }
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        g.setColor(DiffLineSeparatorRenderer.getBackgroundColor(scheme2));
        Graphics2D gg = (Graphics2D)g;
        AffineTransform oldTransform = gg.getTransform();
        for (int i = 0; i < height; ++i) {
            gg.drawPolyline(xPoints, yPoints, xPoints.length);
            gg.translate(0, 1);
        }
        gg.setTransform(oldTransform);
    }

    private static int getStepSize(int lineHeight) {
        return Math.max(lineHeight / 3, 1);
    }

    private static int getHeight(int lineHeight) {
        return Math.max(lineHeight / 2, 1);
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull EditorColorsScheme scheme2) {
        Color color;
        if (scheme2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(8);
        }
        Color color2 = (color = scheme2.getColor(BACKGROUND)) != null ? color : Gray._128;
        if (color2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(9);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xPoints";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yPoints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drawConnectorLine";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

