/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor<F>
implements SearchEverywhereContributor<F> {
    protected static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([\\.\\w]+)((\\$[\\d]+)*(\\$)?)");
    protected static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    protected static final Pattern patternToDetectSignatures = Pattern.compile("(.+#.*)\\(.*\\)");
    private static final String fullMatchSearchSuffix = " ";
    @Nullable
    protected final Project myProject;
    @Nullable
    protected final PsiElement psiContext;
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);

    protected AbstractGotoSEContributor(@Nullable Project project, @Nullable PsiElement context) {
        this.myProject = project;
        this.psiContext = context;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<F> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(3);
        }
        if (this.myProject == null) {
            return;
        }
        if (!this.isDumbModeSupported() && DumbService.getInstance((Project)this.myProject).isDumb()) {
            return;
        }
        String suffix = pattern.endsWith(fullMatchSearchSuffix) ? fullMatchSearchSuffix : "";
        String searchString = this.filterControlSymbols(pattern) + suffix;
        FilteringGotoByModel<F> model = this.createModel(this.myProject);
        if (filter != null) {
            model.setFilterItems(filter.getSelectedElements());
        }
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (progressIndicator == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(15);
            }
            if (consumer == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(16);
            }
            PsiElement context = this.psiContext != null && this.psiContext.isValid() ? this.psiContext : null;
            ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, (ChooseByNameModel)model, context);
            try {
                popup2.getProvider().filterElements(popup2, searchString, everywhere, progressIndicator, (Processor<Object>)((Processor)element -> {
                    if (progressIndicator == null) {
                        AbstractGotoSEContributor.$$$reportNull$$$0(17);
                    }
                    if (consumer == null) {
                        AbstractGotoSEContributor.$$$reportNull$$$0(18);
                    }
                    if (progressIndicator.isCanceled()) {
                        return false;
                    }
                    if (element == null) {
                        LOG.error("Null returned from " + model + " in " + this);
                        return true;
                    }
                    return (Boolean)consumer.apply(element);
                }));
            }
            finally {
                Disposer.dispose((Disposable)popup2);
            }
        }, progressIndicator);
    }

    @NotNull
    protected abstract FilteringGotoByModel<F> createModel(@NotNull Project var1);

    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (pattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(4);
        }
        if (StringUtil.containsAnyChar((String)pattern, (String)":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            String string = AbstractGotoSEContributor.applyPatternFilter(pattern, patternToDetectLinesAndColumns);
            if (string == null) {
                AbstractGotoSEContributor.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    public boolean showInFindResults() {
        return true;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        if (selected == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(7);
        }
        if (searchText == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(8);
        }
        if (selected instanceof PsiElement) {
            if (!((PsiElement)selected).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)selected), (boolean)true, (boolean)AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return true;
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(9);
        }
        if (dataId == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(10);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element instanceof PsiElement) {
                return element;
            }
            if (element instanceof DataProvider) {
                return ((DataProvider)element).getData(dataId);
            }
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element instanceof PsiElement) {
            return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element);
        }
        return null;
    }

    public boolean isMultiselectSupported() {
        return true;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        if (list2 == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(11);
        }
        SERenderer sERenderer = new SERenderer(list2);
        if (sERenderer == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(12);
        }
        return sERenderer;
    }

    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(13);
        }
        if (searchPattern == null) {
            AbstractGotoSEContributor.$$$reportNull$$$0(14);
        }
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(psi.getProject(), file2, ((Integer)position.first).intValue(), ((Integer)position.second).intValue());
            return descriptor.setUseCurrentWindow(AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text, 3);
        if (line == -1 && column != -1) {
            line = 0;
        }
        return new Pair((Object)line, (Object)column);
    }

    private static int getLineAndColumnRegexpGroup(String text, int groupNumber) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(text);
        if (matcher.matches()) {
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected static boolean openInCurrentWindow(int modifiers) {
        return (modifiers & 1) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/AbstractGotoSEContributor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterControlSymbols";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterControlSymbols";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementsRenderer";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchElements$1";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class SERenderer
    extends SearchEverywherePsiRenderer {
        public SERenderer(JList list2) {
            super(list2);
        }

        @Override
        public String getElementText(PsiElement element) {
            if (element instanceof NavigationItem) {
                return Optional.ofNullable(((NavigationItem)element).getPresentation()).map(presentation -> presentation.getPresentableText()).orElse(super.getElementText(element));
            }
            return super.getElementText(element);
        }
    }
}

