/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class XmlParser
implements PsiParser {
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> REPARSE_XML_TAG_BY_NAME = (oldNode, newNode, structure) -> {
        if (oldNode instanceof XmlTag && newNode.getTokenType() == XmlElementType.XML_TAG) {
            String oldName = ((XmlTag)oldNode).getName();
            Ref childrenRef = Ref.create(null);
            int count = structure.getChildren(newNode, childrenRef);
            if (count < 3) {
                return ThreeState.UNSURE;
            }
            LighterASTNode[] children2 = (LighterASTNode[])childrenRef.get();
            if (children2[0].getTokenType() != XmlTokenType.XML_START_TAG_START) {
                return ThreeState.UNSURE;
            }
            if (children2[1].getTokenType() != XmlTokenType.XML_NAME) {
                return ThreeState.UNSURE;
            }
            if (children2[2].getTokenType() != XmlTokenType.XML_TAG_END) {
                return ThreeState.UNSURE;
            }
            LighterASTTokenNode name = (LighterASTTokenNode)children2[1];
            CharSequence newName = name.getText();
            if (!Comparing.equal((CharSequence)oldName, (CharSequence)newName)) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    };

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder2) {
        builder2.enforceCommentTokens(TokenSet.EMPTY);
        builder2.putUserData(PsiBuilderImpl.CUSTOM_COMPARATOR, REPARSE_XML_TAG_BY_NAME);
        PsiBuilder.Marker file2 = builder2.mark();
        new XmlParsing(builder2).parseDocument();
        file2.done(root);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            XmlParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/xml/XmlParser", "parse"));
    }
}

