/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogIndexService;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsForwardIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TByteObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsIndexableDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId storageId, @NotNull VcsLogStorage storage2, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (fatalErrorHandler == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        super(storageId, PATHS, new PathsIndexer(storage2, VcsLogPathsIndex.createPathsEnumerator(storageId), VcsLogPathsIndex.createRenamesMap(storageId)), new ChangeKindListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<Exception>)((Consumer)e -> {
            if (fatalErrorHandler == null) {
                VcsLogPathsIndex.$$$reportNull$$$0(16);
            }
            fatalErrorHandler.consume(this, (Throwable)e);
        }));
    }

    @Override
    @NotNull
    protected ForwardIndex<Integer, List<ChangeKind>> createForwardIndex(@NotNull IndexExtension<Integer, List<ChangeKind>, VcsIndexableDetails> extension) throws IOException {
        if (extension == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        if (!VcsLogIndexService.isPathsForwardIndexRequired()) {
            ForwardIndex<Integer, List<ChangeKind>> forwardIndex = super.createForwardIndex(extension);
            if (forwardIndex == null) {
                VcsLogPathsIndex.$$$reportNull$$$0(5);
            }
            return forwardIndex;
        }
        VcsLogPathsForwardIndex vcsLogPathsForwardIndex = new VcsLogPathsForwardIndex(extension){

            @NotNull
            public PersistentHashMap<Integer, List<Collection<Integer>>> createMap() throws IOException {
                File storageFile = VcsLogPathsIndex.this.myStorageId.getStorageFile(VcsLogPathsIndex.this.myName + ".idx");
                PersistentHashMap persistentHashMap = new PersistentHashMap(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new VcsLogPathsForwardIndex.IntCollectionListExternalizer(), Page.PAGE_SIZE);
                if (persistentHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return persistentHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$1", "createMap"));
            }
        };
        if (vcsLogPathsForwardIndex == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(6);
        }
        return vcsLogPathsForwardIndex;
    }

    @NotNull
    private static PersistentEnumeratorBase<LightFilePath> createPathsEnumerator(@NotNull StorageId storageId) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        File storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        PersistentBTreeEnumerator persistentBTreeEnumerator = new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(), Page.PAGE_SIZE, null, storageId.getVersion());
        if (persistentBTreeEnumerator == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        return persistentBTreeEnumerator;
    }

    @NotNull
    private static PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> createRenamesMap(@NotNull StorageId storageId) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(9);
        }
        File storageFile = storageId.getStorageFile(RENAMES_MAP);
        PersistentHashMap persistentHashMap = new PersistentHashMap(storageFile, (KeyDescriptor)new CoupleKeyDescriptor(), (DataExternalizer)new CollectionDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
        if (persistentHashMap == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(10);
        }
        return persistentHashMap;
    }

    @Nullable
    public FilePath getPath(int pathId) {
        try {
            return VcsLogPathsIndex.toFilePath((LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId));
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @Nullable
    public Couple<FilePath> iterateRenames(int parent, int child2, @NotNull BooleanFunction<Couple<FilePath>> accept) throws IOException {
        Collection renames;
        if (accept == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(11);
        }
        if ((renames = (Collection)this.myPathsIndexer.myRenamesMap.get((Object)Couple.of((Object)parent, (Object)child2))) == null) {
            return null;
        }
        for (Couple rename : renames) {
            FilePath path2;
            FilePath path1 = this.getPath((Integer)rename.first);
            Couple paths = Couple.of((Object)path1, (Object)(path2 = this.getPath((Integer)rename.second)));
            if (!accept.fun((Object)paths)) continue;
            return paths;
        }
        return null;
    }

    @NotNull
    public Set<FilePath> getPathsChangedInCommit(int commit, int parentIndex) throws IOException {
        List keysForCommit = (List)this.getKeysForCommit(commit);
        if (keysForCommit == null || keysForCommit.size() <= parentIndex) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                VcsLogPathsIndex.$$$reportNull$$$0(12);
            }
            return set;
        }
        HashSet paths = ContainerUtil.newHashSet();
        for (Integer pathId : ContainerUtil.newHashSet((Iterable)((Iterable)keysForCommit.get(parentIndex)))) {
            LightFilePath lightFilePath = (LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId.intValue());
            if (lightFilePath.isDirectory()) continue;
            paths.add(VcsLogPathsIndex.toFilePath(lightFilePath));
        }
        HashSet hashSet = paths;
        if (hashSet == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    public void iterateCommits(@NotNull FilePath path, @NotNull ObjIntConsumer<List<ChangeKind>> consumer) throws IOException, StorageException {
        if (path == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(15);
        }
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(path));
        this.iterateCommitIdsAndValues(pathId, consumer);
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myRenamesMap.close();
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static FilePath toFilePath(@Nullable LightFilePath lightFilePath) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)lightFilePath.getPath(), (boolean)lightFilePath.isDirectory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accept";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createForwardIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathsEnumerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamesMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsChangedInCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndex";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPathsEnumerator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRenamesMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "iterateRenames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectionDataExternalizer
    implements DataExternalizer<Collection<Couple<Integer>>> {
        private CollectionDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<Couple<Integer>> value) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Couple<Integer> v : value) {
                out.writeInt((Integer)v.first);
                out.writeInt((Integer)v.second);
            }
        }

        public Collection<Couple<Integer>> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            SmartList result2 = new SmartList();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result2.add(Couple.of((Object)in.readInt(), (Object)in.readInt()));
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CoupleKeyDescriptor
    implements KeyDescriptor<Couple<Integer>> {
        private CoupleKeyDescriptor() {
        }

        public int getHashCode(Couple<Integer> value) {
            return value.hashCode();
        }

        public boolean isEqual(Couple<Integer> val1, Couple<Integer> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Couple<Integer> value) throws IOException {
            if (out == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.writeInt((Integer)value.first);
            out.writeInt((Integer)value.second);
        }

        public Couple<Integer> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CoupleKeyDescriptor.$$$reportNull$$$0(1);
            }
            return Couple.of((Object)in.readInt(), (Object)in.readInt());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$CoupleKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        private LightFilePathKeyDescriptor() {
        }

        public int getHashCode(LightFilePath path) {
            return path.hashCode();
        }

        public boolean isEqual(LightFilePath path1, LightFilePath path2) {
            return path1.equals(path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value) throws IOException {
            if (out == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(0);
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.getPath());
            out.writeBoolean(value.myIsDirectory);
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(1);
            }
            String path = IOUtil.readUTF((DataInput)in);
            boolean isDirectory = in.readBoolean();
            return new LightFilePath(path, isDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LightFilePath {
        @NotNull
        private final String myPath;
        private final boolean myIsDirectory;

        private LightFilePath(@NotNull String path, boolean directory) {
            if (path == null) {
                LightFilePath.$$$reportNull$$$0(0);
            }
            this.myPath = path;
            this.myIsDirectory = directory;
        }

        private LightFilePath(@NotNull FilePath filePath) {
            if (filePath == null) {
                LightFilePath.$$$reportNull$$$0(1);
            }
            this(filePath.getPath(), filePath.isDirectory());
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                LightFilePath.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path = (LightFilePath)o;
            return this.myIsDirectory == path.myIsDirectory && this.myPath.equals(path.myPath);
        }

        public int hashCode() {
            int result2 = this.myPath.hashCode();
            result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final TByteObjectHashMap<ChangeKind> KINDS;

        private ChangeKind(byte id) {
            this.id = id;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id) {
            ChangeKind changeKind = (ChangeKind)((Object)KINDS.get(id));
            if (changeKind == null) {
                ChangeKind.$$$reportNull$$$0(0);
            }
            return changeKind;
        }

        static {
            KINDS = new TByteObjectHashMap();
            for (ChangeKind kind : ChangeKind.values()) {
                KINDS.put(kind.id, (Object)kind);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind", "getChangeKindById"));
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value) throws IOException {
            if (out == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeKind data : value) {
                out.writeByte(data.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(1);
            }
            List value = ContainerUtil.newSmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKindListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsIndexableDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumeratorBase<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> myRenamesMap;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        private PathsIndexer(@NotNull VcsLogStorage storage2, @NotNull PersistentEnumeratorBase<LightFilePath> enumerator2, @NotNull PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> renamesMap) {
            if (storage2 == null) {
                PathsIndexer.$$$reportNull$$$0(0);
            }
            if (enumerator2 == null) {
                PathsIndexer.$$$reportNull$$$0(1);
            }
            if (renamesMap == null) {
                PathsIndexer.$$$reportNull$$$0(2);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myStorage = storage2;
            this.myPathsEnumerator = enumerator2;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                PathsIndexer.$$$reportNull$$$0(3);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsIndexableDetails inputData) {
            if (inputData == null) {
                PathsIndexer.$$$reportNull$$$0(4);
            }
            THashMap result2 = new THashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    THashSet processedParents = new THashSet();
                    SmartList renames = new SmartList();
                    for (Pair pair : inputData.getRenamedPaths(parentIndex)) {
                        int beforeId = this.myPathsEnumerator.enumerate((Object)new LightFilePath((String)pair.first, false));
                        int afterId = this.myPathsEnumerator.enumerate((Object)new LightFilePath((String)pair.second, false));
                        renames.add(Couple.of((Object)beforeId, (Object)afterId));
                        PathsIndexer.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, beforeId, parentsCount).set(parentIndex, ChangeKind.REMOVED);
                        PathsIndexer.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, afterId, parentsCount).set(parentIndex, ChangeKind.ADDED);
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)pair.second, inputData.getRoot(), (Set<String>)processedParents);
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)pair.first, inputData.getRoot(), (Set<String>)processedParents);
                    }
                    if (renames.size() > 0) {
                        int commit = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int n = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)Couple.of((Object)n, (Object)commit), (Object)renames);
                    }
                    for (Map.Entry entry : inputData.getModifiedPaths(parentIndex).entrySet()) {
                        this.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, new LightFilePath((String)entry.getKey(), false), parentsCount).set(parentIndex, PathsIndexer.createChangeData((Change.Type)entry.getValue()));
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)entry.getKey(), inputData.getRoot(), (Set<String>)processedParents);
                    }
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.consume((Object)e);
                }
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                PathsIndexer.$$$reportNull$$$0(5);
            }
            return tHashMap;
        }

        private void addParentsToResult(@NotNull Map<Integer, List<ChangeKind>> result2, int parent, int parentsCount, @NotNull String path, @NotNull VirtualFile root, @NotNull Set<String> processedParents) throws IOException {
            if (result2 == null) {
                PathsIndexer.$$$reportNull$$$0(6);
            }
            if (path == null) {
                PathsIndexer.$$$reportNull$$$0(7);
            }
            if (root == null) {
                PathsIndexer.$$$reportNull$$$0(8);
            }
            if (processedParents == null) {
                PathsIndexer.$$$reportNull$$$0(9);
            }
            String parentPath = PathUtil.getParentPath((String)path);
            while (!processedParents.contains(parentPath) && !FileUtil.PATH_HASHING_STRATEGY.equals((Object)root.getPath(), (Object)parentPath)) {
                processedParents.add(parentPath);
                this.getOrCreateChangeKindList(result2, new LightFilePath(parentPath, true), parentsCount).set(parent, ChangeKind.MODIFIED);
                parentPath = PathUtil.getParentPath((String)parentPath);
            }
        }

        @NotNull
        private List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, @NotNull LightFilePath path, int parentsCount) throws IOException {
            if (pathIdToChangeDataListsMap == null) {
                PathsIndexer.$$$reportNull$$$0(10);
            }
            if (path == null) {
                PathsIndexer.$$$reportNull$$$0(11);
            }
            int pathId = this.myPathsEnumerator.enumerate((Object)path);
            List<ChangeKind> list2 = PathsIndexer.getOrCreateChangeKindList(pathIdToChangeDataListsMap, pathId, parentsCount);
            if (list2 == null) {
                PathsIndexer.$$$reportNull$$$0(12);
            }
            return list2;
        }

        @NotNull
        private static List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            List changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathsIndexer.$$$reportNull$$$0(13);
            }
            if ((changeDataList = pathIdToChangeDataListsMap.get(pathId)) == null) {
                changeDataList = ContainerUtil.newSmartList();
                for (int i = 0; i < parentsCount; ++i) {
                    changeDataList.add(ChangeKind.NOT_CHANGED);
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            List list2 = changeDataList;
            if (list2 == null) {
                PathsIndexer.$$$reportNull$$$0(14);
            }
            return list2;
        }

        @NotNull
        private static ChangeKind createChangeData(@NotNull Change.Type type) {
            if (type == null) {
                PathsIndexer.$$$reportNull$$$0(15);
            }
            switch (type) {
                case NEW: {
                    ChangeKind changeKind = ChangeKind.ADDED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(16);
                    }
                    return changeKind;
                }
                case DELETED: {
                    ChangeKind changeKind = ChangeKind.REMOVED;
                    if (changeKind == null) {
                        PathsIndexer.$$$reportNull$$$0(17);
                    }
                    return changeKind;
                }
            }
            ChangeKind changeKind = ChangeKind.MODIFIED;
            if (changeKind == null) {
                PathsIndexer.$$$reportNull$$$0(18);
            }
            return changeKind;
        }

        @NotNull
        public PersistentEnumeratorBase<LightFilePath> getPathsEnumerator() {
            PersistentEnumeratorBase<LightFilePath> persistentEnumeratorBase = this.myPathsEnumerator;
            if (persistentEnumeratorBase == null) {
                PathsIndexer.$$$reportNull$$$0(19);
            }
            return persistentEnumeratorBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renamesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 5: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processedParents";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathsIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeKindList";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangeData";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsEnumerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 5: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addParentsToResult";
                    break;
                }
                case 10: 
                case 11: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeKindList";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangeData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

