/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.output;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PhingTextOutputView {
    private final Project myProject;
    private final ConsoleView myConsole;

    public PhingTextOutputView(Project project) {
        this.myProject = project;
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder.addFilter((Filter)new PhingPathFilter());
        this.myConsole = builder.getConsole();
    }

    public void attachProcessHandler(OSProcessHandler handler) {
        this.myConsole.attachToProcess((ProcessHandler)handler);
    }

    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    public void addSystemMessage(String message) {
        this.print(message + "\n");
    }

    private void print(String text) {
        this.myConsole.print(text, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void clearAllMessages() {
        this.myConsole.clear();
    }

    public boolean isOutputPaused() {
        return this.myConsole.isOutputPaused();
    }

    public void setOutputPaused(boolean outputPaused) {
        this.myConsole.setOutputPaused(outputPaused);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myConsole);
    }

    private final class PhingPathFilter
    implements Filter {
        @NonNls
        private static final String WRAPPED_TEXT = "wrapped: ";

        private PhingPathFilter() {
        }

        public Filter.Result applyFilter(String line, int entireLength) {
            Filter.Result wrappedResult = this.getWrappedResult(line, entireLength);
            return wrappedResult == null ? this.getLineResult(line, entireLength) : wrappedResult;
        }

        private Filter.Result getWrappedResult(String line, int entireLength) {
            int wrappedIndex = line.indexOf(WRAPPED_TEXT);
            if (wrappedIndex == -1) {
                return null;
            }
            int afterLineNumberIndex = line.indexOf(": ", wrappedIndex += WRAPPED_TEXT.length());
            if (afterLineNumberIndex == -1) {
                return null;
            }
            String fileAndLineNumber = line.substring(wrappedIndex, afterLineNumberIndex);
            return this.createResult(line, entireLength, afterLineNumberIndex, fileAndLineNumber, wrappedIndex);
        }

        private Filter.Result getLineResult(String line, int entireLength) {
            int afterLineNumberIndex = line.indexOf(": ");
            if (afterLineNumberIndex == -1) {
                return null;
            }
            String fileAndLineNumber = line.substring(0, afterLineNumberIndex);
            return this.createResult(line, entireLength, afterLineNumberIndex, fileAndLineNumber, 0);
        }

        @Nullable
        private Filter.Result createResult(String line, int entireLength, int afterLineNumberIndex, String fileAndLineNumber, int startOffset) {
            VirtualFile file;
            int lineNumber;
            int lastColonIndex = fileAndLineNumber.lastIndexOf(":");
            if (lastColonIndex == -1) {
                return null;
            }
            int pathEndIndex = fileAndLineNumber.lastIndexOf(":", lastColonIndex - 1);
            int index = pathEndIndex != -1 ? pathEndIndex : lastColonIndex;
            int lineNumberEnd = pathEndIndex != -1 ? lastColonIndex : fileAndLineNumber.length();
            String fileName = fileAndLineNumber.substring(0, index);
            String lineNumberStr = fileAndLineNumber.substring(index + 1, lineNumberEnd).trim();
            try {
                lineNumber = Integer.parseInt(lineNumberStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
            int colNumber = -1;
            if (pathEndIndex != -1) {
                try {
                    colNumber = Integer.parseInt(fileAndLineNumber.substring(lastColonIndex + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((file = LocalFileSystem.getInstance().findFileByPath(fileName.replace(File.separatorChar, '/'))) == null) {
                return null;
            }
            int textStartOffset = entireLength - line.length() + startOffset;
            int highlightEndOffset = textStartOffset + afterLineNumberIndex - startOffset;
            OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(PhingTextOutputView.this.myProject, file, lineNumber - 1, colNumber == -1 ? 0 : colNumber);
            return new Filter.Result(textStartOffset, highlightEndOffset, (HyperlinkInfo)info);
        }
    }
}

