/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.dql.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.dql.DqlTypes;
import com.jetbrains.php.dql.lexer._DqlLexer;
import com.jetbrains.php.dql.parser.DqlParserDefinition;
import com.jetbrains.php.dql.psi.DqlTokenType;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DqlLexer
extends LookAheadLexer {
    private static final Map<String, IElementType> myKeywordMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    public static final IElementType DQL_STRING_UNCLOSED;

    public DqlLexer() {
        super((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _DqlLexer()), DqlParserDefinition.WS));
    }

    public Set<String> getKeywords() {
        return myKeywordMap.keySet();
    }

    public static Map<String, IElementType> getKeywordMap() {
        return myKeywordMap;
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        IElementType elementType;
        if (baseLexer == null) {
            DqlLexer.$$$reportNull$$$0(0);
        }
        IElementType iElementType = elementType = baseLexer.getTokenType() == DqlTypes.DQL_ID ? myKeywordMap.get(baseLexer.getTokenText()) : null;
        if (elementType != null) {
            this.advanceAs(baseLexer, elementType);
        }
        super.lookAhead(baseLexer);
    }

    static {
        myKeywordMap.put("SELECT", DqlTypes.DQL_SELECT);
        myKeywordMap.put("FROM", DqlTypes.DQL_FROM);
        myKeywordMap.put("UPDATE", DqlTypes.DQL_UPDATE);
        myKeywordMap.put("DELETE", DqlTypes.DQL_DELETE);
        myKeywordMap.put("WHERE", DqlTypes.DQL_WHERE);
        myKeywordMap.put("INDEX", DqlTypes.DQL_INDEX);
        myKeywordMap.put("WHEN", DqlTypes.DQL_WHEN);
        myKeywordMap.put("NULLIF", DqlTypes.DQL_NULLIF);
        myKeywordMap.put("CASE", DqlTypes.DQL_CASE);
        myKeywordMap.put("THEN", DqlTypes.DQL_THEN);
        myKeywordMap.put("ELSE", DqlTypes.DQL_ELSE);
        myKeywordMap.put("END", DqlTypes.DQL_END);
        myKeywordMap.put("AS", DqlTypes.DQL_AS);
        myKeywordMap.put("HIDDEN", DqlTypes.DQL_HIDDEN);
        myKeywordMap.put("AVG", DqlTypes.DQL_AVG);
        myKeywordMap.put("MAX", DqlTypes.DQL_MAX);
        myKeywordMap.put("MIN", DqlTypes.DQL_MIN);
        myKeywordMap.put("SUM", DqlTypes.DQL_SUM);
        myKeywordMap.put("COUNT", DqlTypes.DQL_COUNT);
        myKeywordMap.put("DISTINCT", DqlTypes.DQL_DISTINCT);
        myKeywordMap.put("JOIN", DqlTypes.DQL_JOIN);
        myKeywordMap.put("LEFT", DqlTypes.DQL_LEFT);
        myKeywordMap.put("INNER", DqlTypes.DQL_INNER);
        myKeywordMap.put("OUTER", DqlTypes.DQL_OUTER);
        myKeywordMap.put("PARTIAL", DqlTypes.DQL_PARTIAL);
        myKeywordMap.put("SET", DqlTypes.DQL_SET);
        myKeywordMap.put("INSTANCE", DqlTypes.DQL_INSTANCE);
        myKeywordMap.put("MEMBER", DqlTypes.DQL_MEMBER);
        myKeywordMap.put("LIKE", DqlTypes.DQL_LIKE);
        myKeywordMap.put("ESCAPE", DqlTypes.DQL_ESCAPE);
        myKeywordMap.put("OF", DqlTypes.DQL_OF);
        myKeywordMap.put("BETWEEN", DqlTypes.DQL_BETWEEN);
        myKeywordMap.put("NOT", DqlTypes.DQL_NOT);
        myKeywordMap.put("IS", DqlTypes.DQL_IS);
        myKeywordMap.put("EMPTY", DqlTypes.DQL_EMPTY);
        myKeywordMap.put("EXISTS", DqlTypes.DQL_EXISTS);
        myKeywordMap.put("OR", DqlTypes.DQL_OR);
        myKeywordMap.put("AND", DqlTypes.DQL_AND);
        myKeywordMap.put("IN", DqlTypes.DQL_IN);
        myKeywordMap.put("LENGTH", DqlTypes.DQL_LENGTH);
        myKeywordMap.put("SIZE", DqlTypes.DQL_SIZE);
        myKeywordMap.put("LOCATE", DqlTypes.DQL_LOCATE);
        myKeywordMap.put("ABS", DqlTypes.DQL_ABS);
        myKeywordMap.put("SQRT", DqlTypes.DQL_SQRT);
        myKeywordMap.put("MOD", DqlTypes.DQL_MOD);
        myKeywordMap.put("DATE_DIFF", DqlTypes.DQL_DATE_DIFF);
        myKeywordMap.put("BIT_AND", DqlTypes.DQL_BIT_AND);
        myKeywordMap.put("BIT_OR", DqlTypes.DQL_BIT_OR);
        myKeywordMap.put("WITH", DqlTypes.DQL_WITH);
        myKeywordMap.put("ASC", DqlTypes.DQL_ASC);
        myKeywordMap.put("DESC", DqlTypes.DQL_DESC);
        myKeywordMap.put("ORDER", DqlTypes.DQL_ORDER);
        myKeywordMap.put("GROUP", DqlTypes.DQL_GROUP);
        myKeywordMap.put("BY", DqlTypes.DQL_BY);
        myKeywordMap.put("HAVING", DqlTypes.DQL_HAVING);
        myKeywordMap.put("NULL", DqlTypes.DQL_NULL);
        myKeywordMap.put("ALL", DqlTypes.DQL_ALL);
        myKeywordMap.put("ANY", DqlTypes.DQL_ANY);
        myKeywordMap.put("SOME", DqlTypes.DQL_SOME);
        myKeywordMap.put("COALESCE", DqlTypes.DQL_COALESCE);
        myKeywordMap.put("CONCAT", DqlTypes.DQL_CONCAT);
        myKeywordMap.put("SUBSTRING", DqlTypes.DQL_SUBSTRING);
        myKeywordMap.put("TRIM", DqlTypes.DQL_TRIM);
        myKeywordMap.put("LEADING", DqlTypes.DQL_LEADING);
        myKeywordMap.put("TRAILING", DqlTypes.DQL_TRAILING);
        myKeywordMap.put("BOTH", DqlTypes.DQL_BOTH);
        myKeywordMap.put("LOWER", DqlTypes.DQL_LOWER);
        myKeywordMap.put("UPPER", DqlTypes.DQL_UPPER);
        myKeywordMap.put("IDENTITY", DqlTypes.DQL_IDENTITY);
        myKeywordMap.put("NEW", DqlTypes.DQL_NEW);
        DQL_STRING_UNCLOSED = new DqlTokenType("unclosed string");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/jetbrains/php/dql/lexer/DqlLexer", "lookAhead"));
    }
}

