/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import a.b.lb;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesForm
implements Disposable {
    private final JLabel h;
    private final JLabel f;
    private final JPanel m;
    @NonNls
    private static final String i = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String n = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String a = "find.locateDuplicates.result";
    private final JBSplitter d;
    private final Tree b;
    private final MyDuplicatesModelListener q;
    private final DupInfo p;
    private final Map<DuplicatesPresentation, DuplicatesView> l;
    private final Map<Editor, List<RangeHighlighter>> r;
    private DuplicatesModel o;
    private final Project g;
    private static final DataKey<DuplicatesModel> j;
    private static final String k = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter c;
    private static DupInfo e;
    private static final long s;

    private DuplicatesForm(Project project, DupInfo dupInfo) {
        long l3 = s ^ 0x3852C344402DL;
        this.h = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.f = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.m = new JPanel(new BorderLayout());
        this.b = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.q = new MyDuplicatesModelListener();
        this.l = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.r = new HashMap<Editor, List<RangeHighlighter>>();
        this.c = new MyGlassPanePainter();
        this.g = project;
        this.p = dupInfo;
        DataProvider dataProvider = new DataProvider(){
            private static final long a = lb.a(-5926570054156112185L, 7981544486285615127L, MethodHandles.lookup().lookupClass()).a(205258601971602L);

            public Object getData(@NotNull String dataId) {
                long l3 = a ^ 0x21459E1129D9L;
                if (dataId == null) {
                    1.a(0);
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return DuplicatesForm.a;
                }
                if (j.is(dataId)) {
                    return DuplicatesForm.this.o;
                }
                if (DuplicatesForm.this.o == null) {
                    return null;
                }
                if (CommonDataKeys.NAVIGATABLE.getName().equals(dataId)) {
                    CodeNode codeNode = DuplicatesForm.this.o.getSelectedCodeNode();
                    return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
                }
                return null;
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x341E169B545CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$1", "getData"));
            }
        };
        this.d = new MySplitter(this, dataProvider);
        this.d.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.b));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.b);
        SelectInEditorHandler.installKeyListener((JComponent)this.b);
        this.b();
        this.b.setShowsRootHandles(true);
        this.b.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.b.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installUnknownPopupHandler((JComponent)this.b, (ActionGroup)DuplicatesForm.a(this.getComponent()), (ActionManager)ActionManager.getInstance());
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.b.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.b.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.h, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.h.getWidth(), rectangle.y), DuplicatesForm.this.f, 1);
                    }
                }
            }
        });
        this.m.add((Component)this.h, "West");
        this.m.add((Component)this.f, "East");
        this.m.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.b, (Painter)this.c, (Disposable)this);
        this.b.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.b.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.b.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.b.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.h.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.f.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.c.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.c.setPaint(null, null);
            }
        });
    }

    private void b() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.b);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.a();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.g, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.g).openTextEditor(openFileDescriptor, false);
                    if (editor != null) {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)DuplicatesForm.this.g);
                        List list2 = (List)DuplicatesForm.this.r.get(editor);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                highlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor, psiFragment, highlightManager, 0);
                        DuplicatesForm.this.r.put(editor, list3);
                    }
                }
                return true;
            }
        }.installOn((Component)this.b);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.o.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.o.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.b;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l3 = s ^ 0x362C31B5F40FL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(i);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(n);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel) {
        panel.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = lb.a(-31019129918640503L, 6828385362487638056L, MethodHandles.lookup().lookupClass()).a(265655540731268L);

            protected boolean isAutoScrollMode() {
                long l3 = a ^ 0x4BCFE819ED15L;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.k);
            }

            protected void setAutoScrollMode(boolean state) {
                long l3 = a ^ 0x7D317024BD9DL;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.k, state);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.b);
        panel.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.c()) {
            panel.addAction(new EliminateDuplicatesAction(this));
        }
        panel.addAction(new ExportHTMLAction(this.o.getRoot()));
    }

    private static boolean c() {
        for (int i10 = 0; i10 < e.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentationCache.getPresentation(e, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode a() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.o.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.b.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.o != null) {
            this.o.removeListener(this.q);
        }
        this.o = duplicatesModel;
        this.b.setModel(duplicatesModel.getTreeModel());
        this.b.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.q);
        this.q.a();
    }

    public JComponent getComponent() {
        return this.d;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        e = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project, duplicates);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.g);
        for (Editor editor : this.r.keySet()) {
            List<RangeHighlighter> list2 = this.r.get(editor);
            for (RangeHighlighter rangeHighlighter : list2) {
                highlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
            }
        }
        DuplicatesProfileCache.clear(this.p);
        DuplicatesPresentationCache.clear(this.p);
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, n2, n3, textAttributes, false, arrayList);
        }
        return arrayList;
    }

    static {
        s = lb.a(7156776569386405620L, -7965892249989851334L, MethodHandles.lookup().lookupClass()).a(273394417307966L);
        long l3 = s ^ 0x2ED0BEF126C8L;
        j = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = lb.a(-115315706071233149L, -1813598280159705953L, MethodHandles.lookup().lookupClass()).a(128300684234733L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l3 = a ^ 0x22639B9201C8L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.message("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.a();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.a()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l3 = a ^ 0x48D1C8D9B4E2L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon b;
        private Point a;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.b = (Icon)this.setNeedsRepaint(this.b, icon);
            this.a = (Point)this.setNeedsRepaint(this.a, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.b == null) {
                return;
            }
            this.b.paintIcon(component, g10, this.a.x, this.a.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm a = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.a.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.o;
            this.a.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.o && DuplicatesForm.this.d.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.o.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.o.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = (DuplicatesView)DuplicatesForm.this.l.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.g);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.l.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.d.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.d.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.b.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int a;
        private static final long b = lb.a(-345195176926694138L, -7979447239886285819L, MethodHandles.lookup().lookupClass()).a(209660327100775L);

        SendToAction(String text, String description, Icon icon, String actionId, int diffIndex) {
            super(text, description, icon);
            this.a = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)j.getData(e10.getDataContext());
            duplicatesModel.setDiff(this.a, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)j.getData(e10.getDataContext());
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l3 = b ^ 0x1264D630626CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider a;
        final /* synthetic */ DuplicatesForm this$0;
        private static final long b = lb.a(-5544151061249690038L, -6114610643740639831L, MethodHandles.lookup().lookupClass()).a(95663002620611L);

        MySplitter(DuplicatesForm duplicatesForm, DataProvider dataProvider) {
            long l3 = b ^ 0x9E0B52D2DE0L;
            this.this$0 = duplicatesForm;
            super("DuplicatesForm.settings", 0.3f);
            this.a = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.a.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l3 = b ^ 0x59EE7B454CCFL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = lb.a(-4060228757148695158L, -2165613005465217037L, MethodHandles.lookup().lookupClass()).a(126286713494469L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l3 = a ^ 0x6CFC150C20F7L;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.m, "West");
                DuplicatesForm.this.h.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.f.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long c = lb.a(-8763690416834011450L, 3444498918921826344L, MethodHandles.lookup().lookupClass()).a(83146116018376L);

        public SendToLeftAction() {
            long l3 = c ^ 0x57759CEE03EFL;
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.i, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long c = lb.a(-1660297794809424674L, 7826009232516884987L, MethodHandles.lookup().lookupClass()).a(241721642623731L);

        public SendToRightAction() {
            long l3 = c ^ 0x6504747AE00L;
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.n, 1);
        }
    }
}

