/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class V8HeapInMemoryIndexes
implements Externalizable {
    private final Flags myFlags;
    private TIntArrayList myParents;
    private TIntArrayList myDistances;
    private TIntArrayList myUnreachable;
    private TIntArrayList myOnlyWeak;
    private List<Integer> myBiggest;
    private TreeMap<Long, Aggregate> myAggregateMap;
    private TLongArrayList myRetainedSizes;

    public V8HeapInMemoryIndexes() {
        this.myFlags = new Flags();
    }

    public V8HeapInMemoryIndexes(Flags flags, TLongArrayList retainedSizes, TIntArrayList parents, List<Integer> biggest, TIntArrayList distances, Map<Long, Aggregate> aggregateMap, TIntArrayList unreachable, TIntArrayList onlyWeak) {
        this.myFlags = flags;
        this.myRetainedSizes = retainedSizes;
        this.myParents = parents;
        this.myBiggest = biggest;
        this.myDistances = distances;
        this.myAggregateMap = new TreeMap<Long, Aggregate>(aggregateMap);
        this.myUnreachable = unreachable;
        this.myOnlyWeak = onlyWeak;
    }

    public Flags getFlags() {
        return this.myFlags;
    }

    public TLongArrayList getRetainedSizes() {
        return this.myRetainedSizes;
    }

    public TIntArrayList getParents() {
        return this.myParents;
    }

    public List<Integer> getBiggest() {
        return this.myBiggest;
    }

    public TIntArrayList getDistances() {
        return this.myDistances;
    }

    public TreeMap<Long, Aggregate> getAggregateMap() {
        return this.myAggregateMap;
    }

    public TIntArrayList getUnreachable() {
        return this.myUnreachable;
    }

    public TIntArrayList getOnlyWeak() {
        return this.myOnlyWeak;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.myFlags.writeExternal(out);
        V8Utils.writeIntList(this.myParents, out);
        V8Utils.writeIntList(this.myDistances, out);
        V8Utils.writeIntList(this.myUnreachable, out);
        V8Utils.writeIntList(this.myOnlyWeak, out);
        out.writeInt(this.myBiggest.size());
        for (Integer n : this.myBiggest) {
            out.writeInt(n);
        }
        out.writeInt(this.myAggregateMap.size());
        for (Map.Entry entry : this.myAggregateMap.entrySet()) {
            out.writeLong((Long)entry.getKey());
            ((Aggregate)entry.getValue()).writeExternal(out);
        }
        out.writeInt(this.myRetainedSizes.size());
        for (int i = 0; i < this.myRetainedSizes.size(); ++i) {
            out.writeLong(this.myRetainedSizes.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.myFlags.readExternal(in);
        this.myParents = V8Utils.readIntList(in);
        this.myDistances = V8Utils.readIntList(in);
        this.myUnreachable = V8Utils.readIntList(in);
        this.myOnlyWeak = V8Utils.readIntList(in);
        int biggestSize = in.readInt();
        this.myBiggest = new ArrayList<Integer>();
        for (int i = 0; i < biggestSize; ++i) {
            this.myBiggest.add(in.readInt());
        }
        int aggregateSize = in.readInt();
        this.myAggregateMap = new TreeMap();
        for (int i = 0; i < aggregateSize; ++i) {
            long key = in.readLong();
            Aggregate aggregate = new Aggregate();
            aggregate.readExternal(in);
            this.myAggregateMap.put(key, aggregate);
        }
        int retainedSize = in.readInt();
        this.myRetainedSizes = new TLongArrayList(retainedSize);
        for (int i = 0; i < retainedSize; ++i) {
            this.myRetainedSizes.add(in.readLong());
        }
    }

    public void sortAggregates(Comparator<Long> comparator) {
        TreeMap<Long, Aggregate> map = this.myAggregateMap;
        this.myAggregateMap = new TreeMap(comparator);
        this.myAggregateMap.putAll(map);
    }
}

