/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.sym;

import org.codehaus.jackson.util.InternCache;

public final class CharsToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final boolean INTERN_STRINGS = true;
    static final int MAX_SYMBOL_TABLE_SIZE = 6000;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer(64);
    protected CharsToNameCanonicalizer _parent;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected boolean _dirty;

    public static CharsToNameCanonicalizer createRoot() {
        return sBootstrapSymbolTable.makeOrphan();
    }

    public CharsToNameCanonicalizer(int n) {
        int n2;
        this._dirty = true;
        if (n < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + n);
        }
        for (n2 = 4; n2 < n; n2 += n2) {
        }
        n = n2;
        this.initTables(n);
    }

    private void initTables(int n) {
        this._symbols = new String[n];
        this._buckets = new Bucket[n >> 1];
        this._indexMask = n - 1;
        this._size = 0;
        this._sizeThreshold = n - (n >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, String[] stringArray, Bucket[] bucketArray, int n) {
        this._parent = charsToNameCanonicalizer;
        this._symbols = stringArray;
        this._buckets = bucketArray;
        this._size = n;
        int n2 = stringArray.length;
        this._sizeThreshold = n2 - (n2 >> 2);
        this._indexMask = n2 - 1;
        this._dirty = false;
    }

    public synchronized CharsToNameCanonicalizer makeChild() {
        return new CharsToNameCanonicalizer(this, this._symbols, this._buckets, this._size);
    }

    private CharsToNameCanonicalizer makeOrphan() {
        return new CharsToNameCanonicalizer(null, this._symbols, this._buckets, this._size);
    }

    private synchronized void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 6000) {
            this.initTables(64);
        } else {
            if (charsToNameCanonicalizer.size() <= this.size()) {
                return;
            }
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
        }
        this._dirty = false;
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public String findSymbol(char[] cArray, int n, int n2, int n3) {
        Object object;
        if (n2 < 1) {
            return "";
        }
        String string = this._symbols[n3 &= this._indexMask];
        if (string != null) {
            if (string.length() == n2) {
                int n4 = 0;
                while (string.charAt(n4) == cArray[n + n4] && ++n4 < n2) {
                }
                if (n4 == n2) {
                    return string;
                }
            }
            if ((object = this._buckets[n3 >> 1]) != null && (string = ((Bucket)object).find(cArray, n, n2)) != null) {
                return string;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n3 = CharsToNameCanonicalizer.calcHash(cArray, n, n2) & this._indexMask;
        }
        ++this._size;
        object = new String(cArray, n, n2);
        object = InternCache.instance.intern((String)object);
        if (this._symbols[n3] == null) {
            this._symbols[n3] = object;
        } else {
            int n5 = n3 >> 1;
            this._buckets[n5] = new Bucket((String)object, this._buckets[n5]);
        }
        return object;
    }

    public static int calcHash(char[] cArray, int n, int n2) {
        int n3 = cArray[0];
        for (int i = 1; i < n2; ++i) {
            n3 = n3 * 31 + cArray[i];
        }
        return n3;
    }

    public static int calcHash(String string) {
        int n = string.charAt(0);
        int n2 = string.length();
        for (int i = 1; i < n2; ++i) {
            n = n * 31 + string.charAt(i);
        }
        return n;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        int n = stringArray.length;
        this._symbols = new String[n];
        System.arraycopy(stringArray, 0, this._symbols, 0, n);
        Bucket[] bucketArray = this._buckets;
        n = bucketArray.length;
        this._buckets = new Bucket[n];
        System.arraycopy(bucketArray, 0, this._buckets, 0, n);
    }

    private void rehash() {
        int n;
        Object object;
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold += this._sizeThreshold;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            object = stringArray[n2];
            if (object == null) continue;
            ++n5;
            int n6 = CharsToNameCanonicalizer.calcHash((String)object) & this._indexMask;
            if (this._symbols[n6] == null) {
                this._symbols[n6] = object;
                continue;
            }
            n = n6 >> 1;
            this._buckets[n] = new Bucket((String)object, this._buckets[n]);
        }
        n3 >>= 1;
        for (n2 = 0; n2 < n3; ++n2) {
            for (object = bucketArray[n2]; object != null; object = ((Bucket)object).getNext()) {
                ++n5;
                String string = ((Bucket)object).getSymbol();
                n = CharsToNameCanonicalizer.calcHash(string) & this._indexMask;
                if (this._symbols[n] == null) {
                    this._symbols[n] = string;
                    continue;
                }
                int n7 = n >> 1;
                this._buckets[n7] = new Bucket(string, this._buckets[n7]);
            }
        }
        if (n5 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n5 + ".");
        }
    }

    static final class Bucket {
        private final String _symbol;
        private final Bucket mNext;

        public Bucket(String string, Bucket bucket) {
            this._symbol = string;
            this.mNext = bucket;
        }

        public String getSymbol() {
            return this._symbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public String find(char[] cArray, int n, int n2) {
            String string = this._symbol;
            Bucket bucket = this.mNext;
            while (true) {
                if (string.length() == n2) {
                    int n3 = 0;
                    while (string.charAt(n3) == cArray[n + n3] && ++n3 < n2) {
                    }
                    if (n3 == n2) {
                        return string;
                    }
                }
                if (bucket == null) break;
                string = bucket.getSymbol();
                bucket = bucket.getNext();
            }
            return null;
        }
    }
}

