/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class Utilities {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Enumeration EMPTY_ENUM = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };

    public static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static Object put(Hashtable hashtable, Object object, Object object2) {
        return object2 == null ? hashtable.remove(object) : hashtable.put(object, object2);
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return Utilities.indexOf(objectArray, object) != -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        if (objectArray == null) {
            throw new IllegalArgumentException("The specified array may not be null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!Utilities.areEqual(object, objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException("The specified array may not be null");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append("; ");
        }
        if (objectArray.length > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public static String hashtableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            stringBuffer.append(k.toString());
            stringBuffer.append(" -> ");
            stringBuffer.append(v.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static int max(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The specified array may not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("The specified array must have at least one element");
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int hashCode(double d) {
        return Utilities.hashCode(Double.doubleToLongBits(d));
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static String getPackageName(Class clazz) {
        return Utilities.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    public static String getClassName(Class clazz) {
        return Utilities.getClassName(clazz.getName());
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(n + 1);
    }
}

