/*
 * Decompiled with CFR 0.152.
 */
package free.freechess;

import free.freechess.DeltaBoardStruct;
import free.freechess.GameInfoStruct;
import free.freechess.Ivar;
import free.freechess.SeekInfoStruct;
import free.freechess.Style12Struct;
import free.util.Connection;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FreechessConnection
extends Connection {
    protected static final String USERNAME_REGEX = "[A-z]{3,17}";
    protected static final String TITLES_REGEX = "\\([A-Z\\*\\(\\)]*\\)";
    private final PrintStream logStream;
    private int style = 1;
    private final BitSet requestedIvarStates = new BitSet();
    private BitSet ivarStates = null;
    private final Hashtable linesToFilter = new Hashtable();
    private String interfaceVar = "Java freechess.org library by Alexander Maryanovsky";
    private static final Pattern IVAR_SET_REGEX = Pattern.compile("^(\\w+) (un)?set.$");
    private static final Pattern LOGIN_REGEX = Pattern.compile("^\\*\\*\\*\\* Starting FICS session as ([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? \\*\\*\\*\\*");
    private static final Pattern WRONG_PASSWORD_REGEX = Pattern.compile("^\\*\\*\\*\\* Invalid password! \\*\\*\\*\\*");
    private static final Pattern PERSONAL_TELL_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? tells you: (.*)");
    private static final Pattern SAY_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))?(\\[(\\d+)\\])? says: (.*)");
    private static final Pattern PTELL_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? \\(your partner\\) tells you: (.*)");
    private static final Pattern CHANNEL_TELL_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))?\\((\\d+)\\): (.*)");
    private static final Pattern KIBITZ_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))?\\( {0,3}([\\-0-9]+)\\)\\[(\\d+)\\] kibitzes: (.*)");
    private static final Pattern WHISPER_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))?\\( {0,3}([\\-0-9]+)\\)\\[(\\d+)\\] whispers: (.*)");
    private static final Pattern QTELL_REGEX = Pattern.compile("^:(.*)");
    private static final Pattern SHOUT_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? shouts: (.*)");
    private static final Pattern ISHOUT_REGEX = Pattern.compile("^--> ([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? ?(.*)");
    private static final Pattern TSHOUT_REGEX = Pattern.compile("^:([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? t-shouts: (.*)");
    private static final Pattern CSHOUT_REGEX = Pattern.compile("^([A-z]{3,17})(\\([A-Z\\*\\(\\)]*\\))? c-shouts: (.*)");
    private static final Pattern ANNOUNCEMENT_REGEX = Pattern.compile("^    \\*\\*ANNOUNCEMENT\\*\\* from ([A-z]{3,17}): (.*)");
    private static final Pattern GAME_END_REGEX = Pattern.compile("^\\{Game (\\d+) \\(([A-z]{3,17}) vs\\. ([A-z]{3,17})\\) ([^\\}]+)\\} (.*)");
    private static final Pattern STOPPED_OBSERVING_REGEX = Pattern.compile("^Removing game (\\d+) from observation list\\.$");
    private static final Pattern STOPPED_EXAMINING_REGEX = Pattern.compile("^You are no longer examining game (\\d+)\\.$");
    private static final Pattern ILLEGAL_MOVE_REGEX = Pattern.compile("^Illegal move \\((.*)\\)\\.(.*)");
    private static final Pattern NOT_YOUR_TURN_REGEX = Pattern.compile("^(It is not your move\\.)$");
    private static final Pattern MOVED_WHEN_GAME_PAUSED = Pattern.compile("^(The clock is paused, use \"unpause\" to resume\\.)$");
    private static final Pattern OFFER_PARSER = Pattern.compile("^(\\d+) w=([A-z]{3,17}) t=(\\S+) p=(.*)");
    private static final Pattern OFFER_REGEX = Pattern.compile("^<p([tf])> (.*)");
    private static final Pattern PLAYER_OFFERED_DRAW_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) offers a draw\\.$");
    private static final Pattern PLAYER_OFFERED_ABORT_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) requests to abort the game\\.$");
    private static final Pattern PLAYER_OFFERED_ADJOURN_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) requests to adjourn the game\\.$");
    private static final Pattern PLAYER_OFFERED_TAKEBACK_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) requests to take back (\\d+) half move\\(s\\)\\.$");
    private static final Pattern PLAYER_DECLINED_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) declines the (\\w+) request\\.$");
    private static final Pattern PLAYER_WITHDREW_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) withdraws the (\\w+) request\\.$");
    private static final Pattern PLAYER_COUNTER_TAKEBACK_OFFER_REGEX = Pattern.compile("^Game (\\d+): ([A-z]{3,17}) proposes a different number \\((\\d+)\\) of half-move\\(s\\) to take back\\.$");
    private static final Pattern AT_BOARD_REGEX = Pattern.compile("^You are now at ([A-z]{3,17})'s board \\(game (\\d+)\\)\\.$");
    private static final Pattern PRIMARY_GAME_CHANGED_REGEX = Pattern.compile("^Your primary game is now game (\\d+)\\.$");

    public FreechessConnection(String string, String string2, PrintStream printStream) {
        super(string, string2);
        this.logStream = printStream;
        this.setIvarState(Ivar.NOWRAP, true);
        this.setIvarState(Ivar.DEFPROMPT, true);
        this.setIvarState(Ivar.MS, true);
        this.setIvarState(Ivar.NOHIGHLIGHT, true);
    }

    public void filterLine(String string) {
        this.linesToFilter.put(string, string);
    }

    public final synchronized boolean setIvarState(Ivar ivar, boolean bl) {
        if (!bl && this.isEssentialIvar(ivar)) {
            return false;
        }
        if (bl) {
            this.requestedIvarStates.set(ivar.getIndex());
        } else {
            this.requestedIvarStates.clear(ivar.getIndex());
        }
        if (this.isLoggedIn()) {
            this.sendCommand("$$iset " + ivar.getName() + " " + (bl ? "1" : "0"));
            this.filterLine(ivar.getName() + " " + (bl ? "" : "un") + "set.");
        }
        return true;
    }

    public final synchronized boolean getIvarState(Ivar ivar) {
        return (this.ivarStates == null ? this.requestedIvarStates : this.ivarStates).get(ivar.getIndex());
    }

    public final synchronized boolean getRequestedIvarState(Ivar ivar) {
        return this.requestedIvarStates.get(ivar.getIndex());
    }

    protected boolean isEssentialIvar(Ivar ivar) {
        return ivar == Ivar.NOWRAP || ivar == Ivar.MS || ivar == Ivar.NOHIGHLIGHT;
    }

    public final synchronized void setStyle(int n) {
        this.style = n;
        if (this.isLoggedIn()) {
            this.sendCommand("$set style " + n);
            this.filterLine("Style " + n + " set.");
        }
    }

    public final synchronized void setInterface(String string) {
        if (this.isLoggedIn()) {
            throw new IllegalStateException();
        }
        this.interfaceVar = string;
    }

    protected void handleConnected() {
        this.sendCommand(FreechessConnection.createLoginIvarsSettingString(this.requestedIvarStates));
        this.ivarStates = (BitSet)this.requestedIvarStates.clone();
        super.handleConnected();
    }

    protected void sendLoginSequence() {
        this.sendCommand(this.getRequestedUsername());
        if (this.getPassword() != null) {
            this.sendCommand(this.getPassword(), false);
        }
    }

    private static String createLoginIvarsSettingString(BitSet bitSet) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%b");
        for (n = bitSet.size(); n >= 0 && !bitSet.get(n); --n) {
        }
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(bitSet.get(i) ? "1" : "0");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLoginSucceeded() {
        super.handleLoginSucceeded();
        FreechessConnection freechessConnection = this;
        synchronized (freechessConnection) {
            if (this.ivarStates.get(Ivar.SEEKINFO.getIndex())) {
                this.sendCommand("$$iset seekinfo 1");
                this.filterLine("seekinfo set.");
            }
            for (int i = 0; i < this.requestedIvarStates.size(); ++i) {
                boolean bl = this.requestedIvarStates.get(i);
                Ivar ivar = Ivar.getByIndex(i);
                if (bl == this.ivarStates.get(i)) continue;
                this.sendCommand("$$iset " + ivar.getName() + " " + (bl ? "1" : "0"));
                this.filterLine(ivar.getName() + " " + (bl ? "" : "un") + "set.");
            }
            this.sendCommand("$set style " + this.style);
            this.filterLine("Style " + this.style + " set.");
            this.sendCommand("$set interface " + this.interfaceVar);
            this.sendCommand("$set ptime 0");
            this.filterLine("Your prompt will now not show the time.");
        }
    }

    public void sendCommand(String string) {
        this.sendCommand(string, true);
    }

    public synchronized void sendCommand(String string, boolean bl) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (bl) {
            System.out.println("SENDING COMMAND: " + string);
        }
        try {
            OutputStream outputStream = this.getOutputStream();
            outputStream.write(string.getBytes("ASCII"));
            outputStream.write(10);
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.connectionInterrupted(iOException);
        }
    }

    protected void processLine(String string) {
    }

    protected void processDisconnection() {
    }

    protected InputStream createInputStream(InputStream inputStream) {
        return new PushbackInputStream(new BufferedInputStream(inputStream));
    }

    protected Object readMessage(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = (PushbackInputStream)inputStream;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            int n;
            if ((n = pushbackInputStream.read()) < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n == 10) {
                n = pushbackInputStream.read();
                if (n > 0 && n != 13) {
                    pushbackInputStream.unread(n);
                }
                if (!bl || stringBuffer.length() != 0) break;
                bl = false;
                continue;
            }
            stringBuffer.append((char)n);
            if (!stringBuffer.toString().equals("fics% ")) continue;
            stringBuffer.setLength(0);
            bl = true;
        }
        return stringBuffer.toString();
    }

    protected void handleMessage(Object object) {
        String string = (String)object;
        if (this.logStream != null) {
            this.logStream.println(string);
        }
        if (this.handleGameInfo(string)) {
            return;
        }
        if (this.handleStyle12(string)) {
            return;
        }
        if (this.handleDeltaBoard(string)) {
            return;
        }
        if (this.handleSeeksCleared(string)) {
            return;
        }
        if (this.handleSeekAdded(string)) {
            return;
        }
        if (this.handleSeeksRemoved(string)) {
            return;
        }
        if (this.handleBughouseHoldings(string)) {
            return;
        }
        if (this.handleGameEnd(string)) {
            return;
        }
        if (this.handleStoppedObserving(string)) {
            return;
        }
        if (this.handleStoppedExamining(string)) {
            return;
        }
        if (this.handleEnteredBSetupMode(string)) {
            return;
        }
        if (this.handleExitedBSetupMode(string)) {
            return;
        }
        if (this.handleIllegalMove(string)) {
            return;
        }
        if (this.handleChannelTell(string)) {
            return;
        }
        if (this.handleLogin(string)) {
            return;
        }
        if (this.handleIvarStateChanged(string)) {
            return;
        }
        if (this.handlePersonalTell(string)) {
            return;
        }
        if (this.handleSayTell(string)) {
            return;
        }
        if (this.handlePTell(string)) {
            return;
        }
        if (this.handleShout(string)) {
            return;
        }
        if (this.handleIShout(string)) {
            return;
        }
        if (this.handleTShout(string)) {
            return;
        }
        if (this.handleCShout(string)) {
            return;
        }
        if (this.handleAnnouncement(string)) {
            return;
        }
        if (this.handleKibitz(string)) {
            return;
        }
        if (this.handleWhisper(string)) {
            return;
        }
        if (this.handleQTell(string)) {
            return;
        }
        if (this.handleOffer(string)) {
            return;
        }
        if (this.handleOfferRemoved(string)) {
            return;
        }
        if (this.handlePlayerOffered(string)) {
            return;
        }
        if (this.handlePlayerDeclined(string)) {
            return;
        }
        if (this.handlePlayerWithdrew(string)) {
            return;
        }
        if (this.handlePlayerCounteredTakebackOffer(string)) {
            return;
        }
        if (this.handleSimulCurrentBoardChanged(string)) {
            return;
        }
        if (this.handlePrimaryGameChanged(string)) {
            return;
        }
        if (this.linesToFilter.remove(string) == null) {
            this.processLine(string);
        }
    }

    private boolean handleIvarStateChanged(String string) {
        if (string.indexOf("set") == -1) {
            return false;
        }
        Matcher matcher = IVAR_SET_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        boolean bl = matcher.group(2) == null || "".equals(matcher.group(2));
        Ivar ivar = Ivar.getByName(string2);
        if (ivar == null) {
            return false;
        }
        this.ivarStates.set(ivar.getIndex());
        return this.processIvarStateChanged(ivar, bl);
    }

    protected boolean processIvarStateChanged(Ivar ivar, boolean bl) {
        return false;
    }

    private boolean handleLogin(String string) {
        Matcher matcher = LOGIN_REGEX.matcher(string);
        if (!this.isLoggedIn() && matcher.matches()) {
            this.loginSucceeded(matcher.group(1));
            this.processLine(string);
            return true;
        }
        if (!this.isLoggedIn() && WRONG_PASSWORD_REGEX.matcher(string).matches()) {
            this.loginFailed("Invalid password");
        }
        return false;
    }

    private boolean handlePersonalTell(String string) {
        String string2;
        String string3;
        if (string.indexOf("tells you: ") == -1) {
            return false;
        }
        Matcher matcher = PERSONAL_TELL_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processPersonalTell(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPersonalTell(String string, String string2, String string3) {
        return false;
    }

    private boolean handleSayTell(String string) {
        int n;
        if (string.indexOf("says: ") == -1) {
            return false;
        }
        Matcher matcher = SAY_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(4);
        String string5 = matcher.group(5);
        int n2 = n = string4 == null ? -1 : Integer.parseInt(string4);
        if (!this.processSayTell(string2, string3, n, string5)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processSayTell(String string, String string2, int n, String string3) {
        return false;
    }

    private boolean handlePTell(String string) {
        String string2;
        String string3;
        if (string.indexOf("(your partner) tells you: ") == -1) {
            return false;
        }
        Matcher matcher = PTELL_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processPTell(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPTell(String string, String string2, String string3) {
        return false;
    }

    private boolean handleChannelTell(String string) {
        if (string.indexOf("): ") == -1) {
            return false;
        }
        Matcher matcher = CHANNEL_TELL_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        int n = Integer.parseInt(string4);
        if (!this.processChannelTell(string2, string3, n, string5)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processChannelTell(String string, String string2, int n, String string3) {
        return false;
    }

    private boolean handleKibitz(String string) {
        int n;
        if (string.indexOf("kibitzes: ") == -1) {
            return false;
        }
        Matcher matcher = KIBITZ_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        String string6 = matcher.group(5);
        int n2 = string4 != null && !string4.equals("----") ? Integer.parseInt(string4) : -1;
        if (!this.processKibitz(string2, string3, n2, n = Integer.parseInt(string5), string6)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processKibitz(String string, String string2, int n, int n2, String string3) {
        return false;
    }

    private boolean handleWhisper(String string) {
        int n;
        if (string.indexOf("whispers: ") == -1) {
            return false;
        }
        Matcher matcher = WHISPER_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        String string6 = matcher.group(5);
        int n2 = string4 != null && !string4.equals("----") ? Integer.parseInt(string4) : -1;
        if (!this.processWhisper(string2, string3, n2, n = Integer.parseInt(string5), string6)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processWhisper(String string, String string2, int n, int n2, String string3) {
        return false;
    }

    private boolean handleQTell(String string) {
        if (!string.startsWith(":")) {
            return false;
        }
        Matcher matcher = QTELL_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        if (!this.processQTell(string2)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processQTell(String string) {
        return false;
    }

    private boolean handleShout(String string) {
        String string2;
        String string3;
        if (string.indexOf("shouts: ") == -1) {
            return false;
        }
        Matcher matcher = SHOUT_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processShout(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processShout(String string, String string2, String string3) {
        return false;
    }

    private boolean handleIShout(String string) {
        String string2;
        String string3;
        if (!string.startsWith("--> ")) {
            return false;
        }
        Matcher matcher = ISHOUT_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processIShout(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processIShout(String string, String string2, String string3) {
        return false;
    }

    private boolean handleTShout(String string) {
        String string2;
        String string3;
        if (string.indexOf("t-shouts: ") == -1) {
            return false;
        }
        Matcher matcher = TSHOUT_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processTShout(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processTShout(String string, String string2, String string3) {
        return false;
    }

    private boolean handleCShout(String string) {
        String string2;
        String string3;
        if (string.indexOf("c-shouts: ") == -1) {
            return false;
        }
        Matcher matcher = CSHOUT_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string4 = matcher.group(1);
        if (!this.processCShout(string4, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processCShout(String string, String string2, String string3) {
        return false;
    }

    private boolean handleAnnouncement(String string) {
        String string2;
        if (!string.startsWith("    **ANNOUNCEMENT** from ")) {
            return false;
        }
        Matcher matcher = ANNOUNCEMENT_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string3 = matcher.group(1);
        if (!this.processAnnouncement(string3, string2 = matcher.group(2))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processAnnouncement(String string, String string2) {
        return false;
    }

    private boolean handleGameInfo(String string) {
        if (!string.startsWith("<g1> ")) {
            return false;
        }
        GameInfoStruct gameInfoStruct = GameInfoStruct.parseGameInfoLine(string);
        if (!this.processGameInfo(gameInfoStruct)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processGameInfo(GameInfoStruct gameInfoStruct) {
        return false;
    }

    private boolean handleStyle12(String string) {
        if (!string.startsWith("<12> ")) {
            return false;
        }
        Style12Struct style12Struct = Style12Struct.parseStyle12Line(string);
        if (!this.processStyle12(style12Struct)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processStyle12(Style12Struct style12Struct) {
        return false;
    }

    private boolean handleDeltaBoard(String string) {
        if (!string.startsWith("<d1> ")) {
            return false;
        }
        DeltaBoardStruct deltaBoardStruct = DeltaBoardStruct.parseDeltaBoardLine(string);
        if (!this.processDeltaBoard(deltaBoardStruct)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processDeltaBoard(DeltaBoardStruct deltaBoardStruct) {
        return false;
    }

    private boolean handleBughouseHoldings(String string) {
        return string.startsWith("<b1> ");
    }

    private boolean handleGameEnd(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        if (!string.startsWith("{Game ")) {
            return false;
        }
        Matcher matcher = GAME_END_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processGameEnd(n, string5 = matcher.group(2), string4 = matcher.group(3), string3 = matcher.group(4), string2 = matcher.group(5))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processGameEnd(int n, String string, String string2, String string3, String string4) {
        return false;
    }

    private boolean handleStoppedObserving(String string) {
        if (!string.startsWith("Removing game ")) {
            return false;
        }
        Matcher matcher = STOPPED_OBSERVING_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processStoppedObserving(n)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processStoppedObserving(int n) {
        return false;
    }

    private boolean handleStoppedExamining(String string) {
        if (!string.startsWith("You are no longer examining game ")) {
            return false;
        }
        Matcher matcher = STOPPED_EXAMINING_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processStoppedExamining(n)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processStoppedExamining(int n) {
        return false;
    }

    private boolean handleEnteredBSetupMode(String string) {
        if (!string.equals("Entering setup mode.")) {
            return false;
        }
        if (!this.processBSetupMode(true)) {
            this.processLine(string);
        }
        return true;
    }

    private boolean handleExitedBSetupMode(String string) {
        if (!string.equals("Game is validated - entering examine mode.")) {
            return false;
        }
        if (!this.processBSetupMode(false)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processBSetupMode(boolean bl) {
        return false;
    }

    private boolean handleIllegalMove(String string) {
        if (!(string.startsWith("Illegal move ") || string.equals("It is not your move.") || string.equals("The clock is paused, use \"unpause\" to resume."))) {
            return false;
        }
        Matcher matcher = ILLEGAL_MOVE_REGEX.matcher(string);
        Matcher matcher2 = NOT_YOUR_TURN_REGEX.matcher(string);
        Matcher matcher3 = MOVED_WHEN_GAME_PAUSED.matcher(string);
        if (matcher.matches()) {
            String string2;
            String string3 = matcher.group(1);
            if (!this.processIllegalMove(string3, string2 = matcher.group(2))) {
                this.processLine(string);
            }
            return true;
        }
        if (matcher2.matches()) {
            String string4 = null;
            String string5 = matcher2.group(1);
            if (!this.processIllegalMove(string4, string5)) {
                this.processLine(string);
            }
            return true;
        }
        if (matcher3.matches()) {
            String string6 = null;
            String string7 = matcher3.group(1);
            if (!this.processIllegalMove(string6, string7)) {
                this.processLine(string);
            }
            return true;
        }
        return false;
    }

    protected boolean processIllegalMove(String string, String string2) {
        return false;
    }

    private boolean handleSeeksCleared(String string) {
        if (!string.equals("<sc>")) {
            return false;
        }
        if (!this.processSeeksCleared()) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processSeeksCleared() {
        return false;
    }

    private boolean handleSeekAdded(String string) {
        if (!string.startsWith("<s> ") && !string.startsWith("<sn> ")) {
            return false;
        }
        SeekInfoStruct seekInfoStruct = SeekInfoStruct.parseSeekInfoLine(string);
        if (!this.processSeekAdded(seekInfoStruct)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processSeekAdded(SeekInfoStruct seekInfoStruct) {
        return false;
    }

    private boolean handleSeeksRemoved(String string) {
        if (!string.startsWith("<sr> ")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (!this.processSeeksRemoved(nArray)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processSeeksRemoved(int[] nArray) {
        return false;
    }

    private boolean handleOffer(String string) {
        String string2;
        if (!string.startsWith("<pt> ") && !string.startsWith("<pf> ")) {
            return false;
        }
        Matcher matcher = OFFER_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        boolean bl = "f".equals(matcher.group(1));
        Matcher matcher2 = OFFER_PARSER.matcher(matcher.group(2));
        if (!matcher2.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher2.group(1));
        String string3 = matcher2.group(2);
        String string4 = matcher2.group(3);
        if (!this.processOffer(bl, string4, n, string3, string2 = matcher2.group(4))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processOffer(boolean bl, String string, int n, String string2, String string3) {
        if ("match".equals(string)) {
            return this.processMatchOffered(bl, n, string2, string3);
        }
        if ("takeback".equals(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return this.processTakebackOffered(bl, n, string2, n2);
        }
        if ("draw".equals(string)) {
            return this.processDrawOffered(bl, n, string2);
        }
        if ("abort".equals(string)) {
            return this.processAbortOffered(bl, n, string2);
        }
        if ("adjourn".equals(string)) {
            return this.processAdjournOffered(bl, n, string2);
        }
        return false;
    }

    protected boolean processMatchOffered(boolean bl, int n, String string, String string2) {
        return false;
    }

    protected boolean processTakebackOffered(boolean bl, int n, String string, int n2) {
        return false;
    }

    protected boolean processDrawOffered(boolean bl, int n, String string) {
        return false;
    }

    protected boolean processAbortOffered(boolean bl, int n, String string) {
        return false;
    }

    protected boolean processAdjournOffered(boolean bl, int n, String string) {
        return false;
    }

    private boolean handleOfferRemoved(String string) {
        if (!string.startsWith("<pr> ")) {
            return false;
        }
        int n = Integer.parseInt(string.substring("<pr> ".length()));
        if (!this.processOfferRemoved(n)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processOfferRemoved(int n) {
        return false;
    }

    private boolean handlePlayerOffered(String string) {
        String string2;
        if (!string.startsWith("Game ")) {
            return false;
        }
        Matcher matcher = PLAYER_OFFERED_DRAW_REGEX.matcher(string);
        if (matcher.matches()) {
            string2 = "draw";
        } else {
            matcher = PLAYER_OFFERED_ADJOURN_REGEX.matcher(string);
            if (matcher.matches()) {
                string2 = "adjourn";
            } else {
                matcher = PLAYER_OFFERED_ABORT_REGEX.matcher(string);
                if (matcher.matches()) {
                    string2 = "abort";
                } else {
                    matcher = PLAYER_OFFERED_TAKEBACK_REGEX.matcher(string);
                    if (matcher.matches()) {
                        string2 = "takeback";
                    } else {
                        return false;
                    }
                }
            }
        }
        int n = Integer.parseInt(matcher.group(1));
        String string3 = matcher.group(2);
        if ("takeback".equals(string2)) {
            int n2 = Integer.parseInt(matcher.group(3));
            if (!this.processPlayerOfferedTakeback(n, string3, n2)) {
                this.processLine(string);
            }
        } else if (!this.processPlayerOffered(n, string3, string2)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPlayerOffered(int n, String string, String string2) {
        return false;
    }

    protected boolean processPlayerOfferedTakeback(int n, String string, int n2) {
        return false;
    }

    private boolean handlePlayerDeclined(String string) {
        String string2;
        String string3;
        if (!string.startsWith("Game ") || string.indexOf("declines the ") == -1) {
            return false;
        }
        Matcher matcher = PLAYER_DECLINED_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processPlayerDeclined(n, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPlayerDeclined(int n, String string, String string2) {
        return false;
    }

    private boolean handlePlayerWithdrew(String string) {
        String string2;
        String string3;
        if (!string.startsWith("Game ") || string.indexOf("withdraws the ") == -1) {
            return false;
        }
        Matcher matcher = PLAYER_WITHDREW_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processPlayerWithdrew(n, string3 = matcher.group(2), string2 = matcher.group(3))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPlayerWithdrew(int n, String string, String string2) {
        return false;
    }

    private boolean handlePlayerCounteredTakebackOffer(String string) {
        int n;
        String string2;
        if (!string.startsWith("Game ") || string.indexOf("proposes a different number ") == -1) {
            return false;
        }
        Matcher matcher = PLAYER_COUNTER_TAKEBACK_OFFER_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n2 = Integer.parseInt(matcher.group(1));
        if (!this.processPlayerCounteredTakebackOffer(n2, string2 = matcher.group(2), n = Integer.parseInt(matcher.group(3)))) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPlayerCounteredTakebackOffer(int n, String string, int n2) {
        return false;
    }

    private boolean handleSimulCurrentBoardChanged(String string) {
        if (!string.startsWith("You are now at ")) {
            return false;
        }
        Matcher matcher = AT_BOARD_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        int n = Integer.parseInt(matcher.group(2));
        if (!this.processSimulCurrentBoardChanged(n, string2)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processSimulCurrentBoardChanged(int n, String string) {
        return false;
    }

    private boolean handlePrimaryGameChanged(String string) {
        if (!string.startsWith("Your primary game is now game ")) {
            return false;
        }
        Matcher matcher = PRIMARY_GAME_CHANGED_REGEX.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        if (!this.processPrimaryGameChanged(n)) {
            this.processLine(string);
        }
        return true;
    }

    protected boolean processPrimaryGameChanged(int n) {
        return true;
    }
}

