/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.Jin;
import free.jin.Server;
import free.jin.ui.DialogPanel;
import free.util.BrowserControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerChoicePanel
extends DialogPanel {
    private final DefaultListModel serverListModel = new DefaultListModel();

    public ServerChoicePanel() {
        Server[] serverArray = Jin.getInstance().getServers();
        for (int i = 0; i < serverArray.length; ++i) {
            this.serverListModel.addElement(serverArray[i]);
        }
        this.createUI();
    }

    public Server askServer() {
        return (Server)super.askResult();
    }

    protected String getTitle() {
        return I18n.get(ServerChoicePanel.class).getString("title");
    }

    private void createUI() {
        I18n i18n = I18n.get(ServerChoicePanel.class);
        final JList jList = new JList(this.serverListModel);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(Math.max(5, Math.min(this.serverListModel.getSize(), 10)));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JLabel jLabel = i18n.createLabel("chooseServerLabel");
        jLabel.setLabelFor(jList);
        final JButton jButton = i18n.createButton("okButton");
        JButton jButton2 = i18n.createButton("cancelButton");
        final JButton jButton3 = i18n.createButton("serverWebsiteButton");
        jButton.setEnabled(false);
        jButton3.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = jList.getSelectedIndex();
                boolean bl = n != -1;
                jButton.setEnabled(bl);
                jButton3.setEnabled(bl);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerChoicePanel.this.close(jList.getSelectedValue());
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object e;
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16 && (e = jList.getSelectedValue()) != null) {
                    ServerChoicePanel.this.close(e);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerChoicePanel.this.close(null);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Server server = (Server)jList.getSelectedValue();
                String string = server.getWebsite();
                if (!BrowserControl.displayURL(string)) {
                    BrowserControl.showDisplayBrowserFailedDialog(string, ServerChoicePanel.this, true);
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jLabel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
        this.setDefaultButton(jButton);
    }
}

