/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnRecursiveStatusWalker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnRecursiveStatusWalker");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final StatusReceiver myReceiver;
    @NotNull
    private final LinkedList<MyItem> myQueue;
    @NotNull
    private final MyHandler myHandler;
    @Nullable
    private MultiMap<FilePath, FilePath> myNonRecursiveScope;

    public SvnRecursiveStatusWalker(@NotNull SvnVcs vcs, @NotNull StatusReceiver receiver, @Nullable ProgressIndicator progress) {
        if (vcs == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(0);
        }
        if (receiver == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(1);
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myReceiver = receiver;
        this.myProgress = progress;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void setNonRecursiveScope(@Nullable MultiMap<FilePath, FilePath> nonRecursiveScope) {
        this.myNonRecursiveScope = nonRecursiveScope;
    }

    public void go(@NotNull FilePath rootPath, @NotNull Depth depth) throws SvnBindException {
        if (rootPath == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(2);
        }
        if (depth == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(3);
        }
        this.myQueue.add(this.createItem(rootPath, depth, false));
        while (!this.myQueue.isEmpty()) {
            this.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            try {
                if (item.getPath().isDirectory()) {
                    this.processDirectory(item);
                    continue;
                }
                this.processFile(item);
            }
            catch (SvnBindException e) {
                this.handleStatusException(item, e);
            }
        }
    }

    private void processDirectory(@NotNull MyItem item) throws SvnBindException {
        if (item == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(4);
        }
        File ioFile = item.getPath().getIOFile();
        this.myHandler.setCurrentItem(item);
        item.getClient().doStatus(ioFile, Revision.WORKING, item.getDepth(), false, false, true, true, this.myHandler);
        if (!this.myHandler.myMetCurrentItem) {
            this.myHandler.checkIfCopyRootWasReported(this.myHandler.getCurrentItemStatus());
        }
    }

    private void processFile(@NotNull MyItem item) throws SvnBindException {
        if (item == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(5);
        }
        this.myReceiver.process(item.getPath(), item.getClient().doStatus(item.getPath().getIOFile(), false));
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    public boolean isIgnoredByVcs(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(6);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (vFile == null) {
                SvnRecursiveStatusWalker.$$$reportNull$$$0(16);
            }
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return this.myVcsManager.isIgnored(vFile);
        });
    }

    public boolean isIgnoredIdeaLevel(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(7);
        }
        return this.myChangeListManager.isIgnoredFile(vFile);
    }

    private void handleStatusException(@NotNull MyItem item, @NotNull SvnBindException e) throws SvnBindException {
        if (item == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(8);
        }
        if (e == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(9);
        }
        if (e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.WC_NOT_FILE) || e.contains(ErrorCode.WC_PATH_NOT_FOUND)) {
            VirtualFile virtualFile = item.getPath().getVirtualFile();
            if (virtualFile != null && !this.isIgnoredByVcs(virtualFile)) {
                this.myReceiver.processUnversioned(virtualFile);
                if (virtualFile.isDirectory()) {
                    this.processRecursively(virtualFile, item.getDepth());
                }
            }
        } else {
            throw e;
        }
    }

    private void processRecursively(@NotNull VirtualFile vFile, @NotNull Depth prevDepth) {
        if (vFile == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(10);
        }
        if (prevDepth == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(11);
        }
        if (Depth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        final Depth newDepth = Depth.INFINITY.equals((Object)prevDepth) ? Depth.INFINITY : Depth.EMPTY;
        VirtualFileVisitor.Option[] options = newDepth.equals((Object)Depth.EMPTY) ? (VirtualFileVisitor.Option[])ContainerUtil.ar((Object[])new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, VirtualFileVisitor.ONE_LEVEL_DEEP}) : new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(options){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SvnRecursiveStatusWalker.this.isIgnoredIdeaLevel(file)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(file);
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (file.isDirectory() && file.findChild(SvnUtil.SVN_ADMIN_DIR_NAME) != null) {
                    SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)file), newDepth, true));
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(file);
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    private MyItem createItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot) {
        if (path == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(12);
        }
        if (depth == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(13);
        }
        StatusClient statusClient = this.myVcs.getFactory(path.getIOFile()).createStatusClient(this.myNonRecursiveScope, this.createEventHandler());
        MyItem myItem = new MyItem(path, depth, isInnerCopyRoot, statusClient);
        if (myItem == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(14);
        }
        return myItem;
    }

    @NotNull
    public ProgressTracker createEventHandler() {
        ProgressTracker progressTracker = new ProgressTracker(){

            public void consume(ProgressEvent event) {
            }

            @Override
            public void checkCancelled() throws ProcessCanceledException {
                SvnRecursiveStatusWalker.this.checkCanceled();
            }
        };
        if (progressTracker == null) {
            SvnRecursiveStatusWalker.$$$reportNull$$$0(15);
        }
        return progressTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depth";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevDepth";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "go";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredByVcs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredIdeaLevel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleStatusException";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRecursively";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isIgnoredByVcs$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyHandler
    implements StatusConsumer {
        private MyItem myCurrentItem;
        private boolean myMetCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(@NotNull MyItem currentItem) {
            if (currentItem == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            this.myCurrentItem = currentItem;
            this.myMetCurrentItem = false;
        }

        public void checkIfCopyRootWasReported(@Nullable Status status) {
            if (!this.myMetCurrentItem && status != null && FileUtil.filesEqual((File)status.getFile(), (File)this.myCurrentItem.getPath().getIOFile())) {
                this.myMetCurrentItem = true;
                this.processCurrentItem(status);
            }
        }

        @Nullable
        public Status getCurrentItemStatus() {
            Status result = null;
            try {
                result = this.myCurrentItem.getClient().doStatus(this.myCurrentItem.getPath().getIOFile(), false);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
            return result;
        }

        public void processCurrentItem(@NotNull Status status) {
            if (status == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            StatusType nodeStatus = status.getNodeStatus();
            FilePath path = this.myCurrentItem.getPath();
            VirtualFile vf = path.getVirtualFile();
            if (vf != null) {
                if (StatusType.STATUS_IGNORED.equals((Object)nodeStatus)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                } else if (StatusType.STATUS_UNVERSIONED.equals((Object)nodeStatus) || StatusType.UNKNOWN.equals((Object)nodeStatus)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                    SvnRecursiveStatusWalker.this.processRecursively(vf, this.myCurrentItem.getDepth());
                } else if (!StatusType.OBSTRUCTED.equals((Object)nodeStatus) && !StatusType.STATUS_NONE.equals((Object)nodeStatus)) {
                    if (this.myCurrentItem.isIsInnerCopyRoot()) {
                        SvnRecursiveStatusWalker.this.myReceiver.processCopyRoot(vf, status.getURL(), SvnRecursiveStatusWalker.this.myVcs.getWorkingCopyFormat(path.getIOFile()), status.getRepositoryRootURL());
                    } else {
                        SvnRecursiveStatusWalker.this.myReceiver.bewareRoot(vf, status.getURL());
                    }
                }
            }
        }

        public void consume(Status status) throws SvnBindException {
            SvnRecursiveStatusWalker.this.checkCanceled();
            File ioFile = status.getFile();
            this.checkIfCopyRootWasReported(status);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            if (vFile != null && SvnRecursiveStatusWalker.this.isIgnoredByVcs(vFile)) {
                return;
            }
            if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null && status.is(StatusType.STATUS_UNVERSIONED)) {
                if (vFile.isDirectory()) {
                    if (!FileUtil.filesEqual((File)this.myCurrentItem.getPath().getIOFile(), (File)ioFile)) {
                        SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)vFile), Depth.INFINITY, true));
                    }
                } else {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                }
            } else {
                SvnRecursiveStatusWalker.this.myReceiver.process(VcsUtil.getFilePath((File)ioFile, (boolean)status.getKind().isDirectory()), status);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setCurrentItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCurrentItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyItem {
        @NotNull
        private final FilePath myPath;
        @NotNull
        private final Depth myDepth;
        @NotNull
        private final StatusClient myStatusClient;
        private final boolean myIsInnerCopyRoot;

        private MyItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot, @NotNull StatusClient statusClient) {
            if (path == null) {
                MyItem.$$$reportNull$$$0(0);
            }
            if (depth == null) {
                MyItem.$$$reportNull$$$0(1);
            }
            if (statusClient == null) {
                MyItem.$$$reportNull$$$0(2);
            }
            this.myPath = path;
            this.myDepth = depth;
            this.myStatusClient = statusClient;
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                MyItem.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        @NotNull
        public Depth getDepth() {
            Depth depth = this.myDepth;
            if (depth == null) {
                MyItem.$$$reportNull$$$0(4);
            }
            return depth;
        }

        @NotNull
        public StatusClient getClient() {
            StatusClient statusClient = this.myStatusClient;
            if (statusClient == null) {
                MyItem.$$$reportNull$$$0(5);
            }
            return statusClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "depth";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusClient";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/SvnRecursiveStatusWalker$MyItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDepth";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

