/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.pico.DefaultPicoContainer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisablePCEAction
extends DumbAwareToggleAction {
    private static final String STATUS_BAR_WIDGET_ID = "PCEDisabledStatus";

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            DisablePCEAction.$$$reportNull$$$0(0);
        }
        return ProgressManager.getInstance().getClass() != ProgressManagerImpl.class;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            DisablePCEAction.$$$reportNull$$$0(1);
        }
        DisablePCEAction.changePCEEnabledStatus(!state);
    }

    private static void changePCEEnabledStatus(boolean enabled) {
        ProgressManager newManager = DisablePCEAction.createDebugManager(enabled);
        DisablePCEAction.replaceServiceInstance((ComponentManager)ApplicationManager.getApplication(), ProgressManager.class, newManager);
        CachedSingletonsRegistry.cleanupCachedFields();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) continue;
            if (statusBar.getWidget(STATUS_BAR_WIDGET_ID) == null) {
                if (enabled) continue;
                statusBar.addWidget((StatusBarWidget)new StatusWidget(), "before Position");
                statusBar.updateWidget(STATUS_BAR_WIDGET_ID);
                continue;
            }
            if (!enabled) continue;
            statusBar.removeWidget(STATUS_BAR_WIDGET_ID);
        }
    }

    @NotNull
    private static ProgressManager createDebugManager(boolean enabledPCE) {
        ProgressManagerImpl progressManagerImpl = enabledPCE ? new ProgressManagerImpl() : new ProgressManagerImpl(){

            @Override
            protected void doCheckCanceled() throws ProcessCanceledException {
                1.runCheckCanceledHooks(this.getProgressIndicator());
            }
        };
        if (progressManagerImpl == null) {
            DisablePCEAction.$$$reportNull$$$0(2);
        }
        return progressManagerImpl;
    }

    private static <T> void replaceServiceInstance(ComponentManager componentManager, Class<T> interfaceClass, T instance) {
        DefaultPicoContainer container = (DefaultPicoContainer)componentManager.getPicoContainer();
        String key = interfaceClass.getName();
        Object old = container.getComponentInstance((Object)key);
        container.unregisterComponent((Object)key);
        Disposer.dispose((Disposable)((Disposable)old));
        container.registerComponentInstance((Object)key, instance);
        Disposer.register((Disposable)componentManager, (Disposable)((Disposable)instance));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/DisablePCEAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/DisablePCEAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StatusWidget
    implements StatusBarWidget,
    StatusBarWidget.TextPresentation {
        private StatusWidget() {
        }

        @NotNull
        public String ID() {
            if (DisablePCEAction.STATUS_BAR_WIDGET_ID == null) {
                StatusWidget.$$$reportNull$$$0(0);
            }
            return DisablePCEAction.STATUS_BAR_WIDGET_ID;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
            if (type == null) {
                StatusWidget.$$$reportNull$$$0(1);
            }
            return this;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                StatusWidget.$$$reportNull$$$0(2);
            }
        }

        public void dispose() {
        }

        @Nullable
        public String getTooltipText() {
            return "Click to re-enable ProcessCanceledException";
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> DisablePCEAction.changePCEEnabledStatus(true);
        }

        @NotNull
        public String getText() {
            if ("WARNING: PCE is disabled!" == null) {
                StatusWidget.$$$reportNull$$$0(3);
            }
            return "WARNING: PCE is disabled!";
        }

        public float getAlignment() {
            return 0.5f;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/DisablePCEAction$StatusWidget";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ID";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/DisablePCEAction$StatusWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

