/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ContentEntryTreeCellRenderer
extends NodeRenderer {
    protected final ContentEntryTreeEditor myTreeEditor;
    private final List<? extends ModuleSourceRootEditHandler<?>> myEditHandlers;

    public ContentEntryTreeCellRenderer(@NotNull ContentEntryTreeEditor treeEditor, List<? extends ModuleSourceRootEditHandler<?>> editHandlers) {
        if (treeEditor == null) {
            ContentEntryTreeCellRenderer.$$$reportNull$$$0(0);
        }
        this.myTreeEditor = treeEditor;
        this.myEditHandlers = editHandlers;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        ContentEntry contentEntry;
        VirtualFile file2;
        Object element;
        Object userObject;
        if (tree == null) {
            ContentEntryTreeCellRenderer.$$$reportNull$$$0(1);
        }
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row2, hasFocus);
        ContentEntryEditor editor = this.myTreeEditor.getContentEntryEditor();
        if (editor != null && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof NodeDescriptor && (element = ((NodeDescriptor)userObject).getElement()) instanceof FileElement && (file2 = ((FileElement)element).getFile()) != null && file2.isDirectory() && (contentEntry = editor.getContentEntry()) != null) {
            String prefix = ContentEntryTreeCellRenderer.getPresentablePrefix(contentEntry, file2);
            if (!prefix.isEmpty()) {
                this.append(" (" + prefix + ")", new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
            this.setIcon(this.updateIcon(contentEntry, file2, this.getIcon()));
        }
    }

    private static String getPresentablePrefix(ContentEntry entry, VirtualFile file2) {
        for (SourceFolder sourceFolder : entry.getSourceFolders()) {
            if (!file2.equals(sourceFolder.getFile())) continue;
            JpsModuleSourceRoot element = sourceFolder.getJpsElement();
            JavaSourceRootProperties properties = (JavaSourceRootProperties)element.getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties != null) {
                return properties.getPackagePrefix();
            }
            JavaResourceRootProperties resourceRootProperties = (JavaResourceRootProperties)element.getProperties(JavaModuleSourceRootTypes.RESOURCES);
            if (resourceRootProperties == null) continue;
            return resourceRootProperties.getRelativeOutputPath();
        }
        return "";
    }

    protected Icon updateIcon(ContentEntry entry, VirtualFile file2, Icon originalIcon) {
        SourceFolder[] sourceFolders;
        if (ContentEntryEditor.isExcludedOrUnderExcludedDirectory(this.myTreeEditor.getProject(), entry, file2)) {
            return AllIcons.Modules.ExcludeRoot;
        }
        for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
            if (!file2.equals(sourceFolder.getFile())) continue;
            return SourceRootPresentation.getSourceRootIcon(sourceFolder);
        }
        Icon icon = originalIcon;
        VirtualFile currentRoot = null;
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile sourcePath = sourceFolder.getFile();
            if (sourcePath == null || !VfsUtilCore.isAncestor((VirtualFile)sourcePath, (VirtualFile)file2, (boolean)true) || currentRoot != null && VfsUtilCore.isAncestor((VirtualFile)sourcePath, currentRoot, (boolean)false)) continue;
            Icon folderIcon = this.getSourceFolderIcon(sourceFolder.getRootType());
            if (folderIcon != null) {
                icon = folderIcon;
            }
            currentRoot = sourcePath;
        }
        return icon;
    }

    @Nullable
    private Icon getSourceFolderIcon(JpsModuleSourceRootType<?> type) {
        for (ModuleSourceRootEditHandler<?> handler2 : this.myEditHandlers) {
            if (!handler2.getRootType().equals(type)) continue;
            return handler2.getFolderUnderRootIcon();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryTreeCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

