/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameLogicalRootWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<LogicalRoot, ProximityLocation> LOGICAL_ROOT_KEY = NullableLazyKey.create((String)"logicalRoot", proximityLocation -> SameLogicalRootWeigher.findLogicalRoot(proximityLocation.getPosition()));

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            SameLogicalRootWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SameLogicalRootWeigher.$$$reportNull$$$0(1);
        }
        if (location.getPosition() == null) {
            return null;
        }
        LogicalRoot contextRoot = (LogicalRoot)LOGICAL_ROOT_KEY.getValue((UserDataHolder)location);
        if (contextRoot == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(contextRoot.equals(SameLogicalRootWeigher.findLogicalRoot(element)));
    }

    @Nullable
    private static LogicalRoot findLogicalRoot(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return LogicalRootsManager.getLogicalRootsManager((Project)element.getProject()).findLogicalRoot(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/SameLogicalRootWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

