/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class RenameToIgnoredDirectoryFileInputValidator
implements RenameInputValidatorEx {
    @Nullable
    public String getErrorMessage(String newName, Project project) {
        if (FileTypeManager.getInstance().isFileIgnored(newName)) {
            return "Trying to create a directory with ignored name, result will not be visible";
        }
        return null;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PsiDirectory.class), PlatformPatterns.psiElement(PsiFile.class)});
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        return newName != null && newName.length() > 0 && newName.indexOf(92) < 0 && newName.indexOf(47) < 0 && newName.indexOf(10) < 0;
    }
}

