/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.SqlSpacing;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlCortegeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlSymbol;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.NotNullList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0014J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0014J\b\u0010!\u001a\u00020\u001bH\u0014J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0015\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0010\u00a2\u0006\u0002\b(J\u001f\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\u0015\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0010\u00a2\u0006\u0002\b3J\u001a\u00104\u001a\u00020\u001b2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u00107\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'J\u001a\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020'2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010'J\u0016\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u001e\u0010=\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020#2\u0006\u0010>\u001a\u00020/2\u0006\u0010&\u001a\u00020'J\u0016\u0010?\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0018\u00010@H\u0014J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u000bH\u0016J\u0018\u0010F\u001a\u00020D2\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010H\u001a\u00020DH\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020LH\u0016J\u001a\u0010M\u001a\u0004\u0018\u00010*2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020OJ\n\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\b\u0010S\u001a\u00020\u001bH&J\b\u0010T\u001a\u00020\u0004H\u0016J\u0010\u0010U\u001a\u00020\u00012\u0006\u00101\u001a\u000202H\u0016J\u0010\u0010V\u001a\u00020\u00012\u0006\u00101\u001a\u000202H\u0002J*\u0010W\u001a\u00020\u001b2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002020Y2\b\b\u0002\u0010Z\u001a\u00020\u000b2\b\b\u0002\u0010[\u001a\u00020\u000bH\u0004J-\u0010\\\u001a\u0004\u0018\u00010R2\b\u0010]\u001a\u0004\u0018\u00010R2\b\u0010^\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b`J#\u0010\\\u001a\u0004\u0018\u00010R2\b\u0010]\u001a\u0004\u0018\u00010R2\b\b\u0001\u0010$\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b`J#\u0010\\\u001a\u0004\u0018\u00010R2\b\u0010^\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010_\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b`J\u0019\u0010\\\u001a\u0004\u0018\u00010R2\b\b\u0001\u0010$\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b`J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00010bJ\b\u0010c\u001a\u00020\u0004H\u0014J\b\u0010d\u001a\u00020\u001bH\u0016J\b\u0010e\u001a\u00020\u0004H\u0016J\u0015\u0010f\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\bgJ\u0018\u0010h\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0002J\u000e\u0010i\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'J\u0016\u0010j\u001a\u00020\u001b2\u0006\u0010k\u001a\u00020'2\u0006\u0010l\u001a\u00020'J\b\u0010m\u001a\u00020\u001bH\u0014J\b\u0010n\u001a\u00020\u0004H\u0016J\b\u0010o\u001a\u00020\u000bH\u0017J\b\u0010p\u001a\u00020\u000bH\u0016J\b\u0010q\u001a\u00020\u0004H\u0016J\b\u0010r\u001a\u00020\u000bH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002st\u00a8\u0006u"}, d2={"Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "()V", "analyzed", "", "firstNestedBlock", "getFirstNestedBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "lastNestedBlock", "getLastNestedBlock", "minLength", "", "getMinLength", "()I", "setMinLength", "(I)V", "nestedBlocks", "", "getNestedBlocks", "()Ljava/util/List;", "<set-?>", "parent", "getParent", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "refined", "addNestedBlock", "", "block", "addNestedBlock$intellij_database_sql_impl", "analyseOriginalCodeStyle", "analyze", "analyzeFlow", "configureFormattingAttributes", "convertWrapSettingToWrapType", "Lcom/intellij/formatting/WrapType;", "setting", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "decideSpacing$intellij_database_sql_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "distributeAlign", "align", "Lcom/intellij/formatting/Alignment;", "distributeLeftAlign", "distributeRightAlign", "role1", "role2", "distributeWrap", "type", "distributeWrapIndent", "indent", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "getChildAttributesForNewElementAfter", "index", "getChildAttributesForNewElementAtTheEnd", "getNewLineIdent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getSpacing", "child1", "Lcom/intellij/formatting/Block;", "child2", "getTransitiveWrap", "Lcom/intellij/formatting/Wrap;", "grow", "incomplete", "makeBlock", "makeDefaultBlock", "makeDefaultBlocks", "nodes", "", "since", "till", "makeWrap", "parentWrap", "wrapType", "wrapFirst", "makeWrap$intellij_database_sql_impl", "nestedBlocksIter", "Lcom/intellij/util/containers/JBIterable;", "preserveUserLineBreaks", "refine", "requiresFollowingBreak", "setup", "setup$intellij_database_sql_impl", "shouldBeSpace", "tabify", "tabifyInner", "outerRole", "innerRole", "tuneNestedNodesAfterAnalysis", "userBreakFirstElement", "userDelimiterSetting", "userElementsLineSetting", "userRequiresExpand", "userWrapSetting", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "intellij.database.sql.impl"})
public abstract class SqlFlowBlock
extends SqlBlock {
    @NotNull
    protected SqlBlock parent;
    @NotNull
    private final List<SqlBlock> nestedBlocks = (List)new NotNullList();
    private int minLength;
    private boolean analyzed;
    private boolean refined;

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        return sqlBlock;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkParameterIsNotNull((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @NotNull
    public final List<SqlBlock> getNestedBlocks() {
        return this.nestedBlocks;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public final void setup$intellij_database_sql_impl(@NotNull SqlBlock parent2) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        boolean bl = Intrinsics.areEqual((Object)parent2, (Object)this) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.setParent(parent2);
    }

    public abstract void grow();

    @Nullable
    protected Map<IElementType, FlowPattern> flowPatterns() {
        return null;
    }

    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return SqlFormattingFunKt.usualRole(node);
    }

    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
    }

    public final void addNestedBlock$intellij_database_sql_impl(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Collection collection = this.nestedBlocks;
        collection.add(block);
        this.countRole$intellij_database_sql_impl(block.getRole());
    }

    @Override
    public void analyze() {
        if (!this.analyzed) {
            boolean bl;
            boolean bl2 = bl = this.getContext() != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "The context is not initialized yet for block " + this;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.grow();
            for (SqlBlock b2 : this.nestedBlocks) {
                if (!(b2 instanceof SqlFlowBlock)) continue;
                b2.analyze();
            }
            this.analyzeFlow();
            this.analyzed = true;
        }
    }

    protected void analyzeFlow() {
        int n = this.nestedBlocks.size();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                SqlBlock nestedBlock = (SqlBlock)CollectionsKt.first(this.nestedBlocks);
                this.setMinLength(nestedBlock.getMinLength());
                this.setShape(nestedBlock.getShape());
                break;
            }
            default: {
                this.analyseOriginalCodeStyle();
                int len = n / 2;
                boolean broken = false;
                boolean hasRoles = false;
                for (SqlBlock b2 : this.nestedBlocks) {
                    len += b2.getMinLength();
                    broken = broken || b2.getShape().getExpanding() || b2 instanceof SqlLeafBlock && SqlFormattingFunKt.MUST_FOLLOWED_BY_NL_TYPES.contains(((SqlLeafBlock)b2).getElementType());
                    hasRoles = hasRoles || b2.getRole().getExists();
                }
                this.setMinLength(len);
                this.setShape(broken ? BlockShape.DECIDED_TO_MULTI_ROWS : (len > this.getContext().getLengthThresholdMax() ? BlockShape.DECIDED_TO_MULTI_ROWS : (this.userRequiresExpand() ? BlockShape.DECIDED_TO_MULTI_ROWS : (this.preserveUserLineBreaks() ? BlockShape.DECIDED_TO_MULTI_ROWS : (len <= this.getContext().getLengthThresholdMin() ? BlockShape.DECIDED_TO_ONE_ROW : (hasRoles ? BlockShape.DECIDE_LATER : BlockShape.NOT_DECIDED))))));
                this.tuneNestedNodesAfterAnalysis();
            }
        }
    }

    protected void analyseOriginalCodeStyle() {
    }

    protected boolean preserveUserLineBreaks() {
        return this.getContext().getKlb() && this.contains('\n');
    }

    protected void tuneNestedNodesAfterAnalysis() {
    }

    @Override
    public void refine() {
        if (this.getContext().getDisabled()) {
            return;
        }
        if (!this.refined) {
            this.refined = true;
            if (this.getShape().compareTo((Enum)BlockShape.DECIDE_LATER) >= 0 || this.getContext().getJustAdjust()) {
                this.configureFormattingAttributes();
            }
            for (SqlBlock b2 : this.nestedBlocks) {
                b2.refine();
            }
        }
    }

    protected void configureFormattingAttributes() {
    }

    public final void distributeWrap(@NotNull WrapType type, @NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Wrap w = this.makeWrap$intellij_database_sql_impl(type, type == WrapType.CHOP_DOWN_IF_LONG || type == WrapType.ALWAYS);
        for (SqlBlock b2 : CollectionsKt.asSequence((Iterable)this.nestedBlocks)) {
            if (b2.getRole() != role) continue;
            b2.setMyWrap(w);
        }
    }

    public final void distributeWrapIndent(@NotNull WrapType type, @NotNull Indent indent, @NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Wrap w = this.makeWrap$intellij_database_sql_impl(type, true);
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != role) continue;
            b2.setMyWrap(w);
            b2.setMyIndent(indent);
        }
    }

    public final void distributeLeftAlign(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Alignment align = SqlFormattingModelFunKt.makeLeftAlignment();
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void tabify(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Alignment align = SqlFormattingModelFunKt.makeLeftAlignmentBS();
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void tabifyInner(@NotNull BlockRole outerRole, @NotNull BlockRole innerRole) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)outerRole), (String)"outerRole");
        Intrinsics.checkParameterIsNotNull((Object)((Object)innerRole), (String)"innerRole");
        Alignment align = SqlFormattingModelFunKt.makeLeftAlignmentBS();
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != outerRole || !(b2 instanceof SqlFlowBlock)) continue;
            ((SqlFlowBlock)b2).distributeAlign(align, innerRole);
        }
    }

    private final void distributeAlign(Alignment align, BlockRole role) {
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != role) continue;
            b2.setMyAlign(align);
        }
    }

    public final void distributeRightAlign(@NotNull BlockRole role1, @Nullable BlockRole role2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role1), (String)"role1");
        Alignment align = SqlFormattingModelFunKt.makeRightAlignment();
        for (SqlBlock b2 : this.nestedBlocks) {
            if (b2.getRole() != role1 && (role2 == null || b2.getRole() != role2)) continue;
            SqlLeafBlock sqlLeafBlock = b2.getLastLeafBlock();
            if (sqlLeafBlock == null) continue;
            sqlLeafBlock.setMyAlign(align);
        }
    }

    public static /* synthetic */ void distributeRightAlign$default(SqlFlowBlock sqlFlowBlock, BlockRole blockRole, BlockRole blockRole2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: distributeRightAlign");
        }
        if ((n & 2) != 0) {
            blockRole2 = null;
        }
        sqlFlowBlock.distributeRightAlign(blockRole, blockRole2);
    }

    @Override
    @Nullable
    public Wrap getTransitiveWrap() {
        Wrap wrap = this.getMyWrap();
        if (wrap == null) {
            wrap = this.getParent().getTransitiveWrap();
        }
        return wrap;
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_impl(@SqlCodeStyleConst.WrapMagicValues int setting) {
        return SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, this.convertWrapSettingToWrapType(setting), false, 2, null);
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_impl(@Nullable Wrap parentWrap, @SqlCodeStyleConst.WrapMagicValues int setting) {
        return SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, parentWrap, this.convertWrapSettingToWrapType(setting), false, 4, null);
    }

    private final WrapType convertWrapSettingToWrapType(int setting) {
        WrapType wrapType;
        switch (setting) {
            case 2: {
                wrapType = WrapType.CHOP_DOWN_IF_LONG;
                break;
            }
            case 1: {
                wrapType = WrapType.ALWAYS;
                break;
            }
            case 3: {
                wrapType = WrapType.NORMAL;
                break;
            }
            default: {
                wrapType = null;
            }
        }
        return wrapType;
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_impl(@Nullable WrapType wrapType, boolean wrapFirst) {
        return this.makeWrap$intellij_database_sql_impl(null, wrapType, wrapFirst);
    }

    @Nullable
    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_impl$default(SqlFlowBlock sqlFlowBlock, WrapType wrapType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_impl(wrapType, bl);
    }

    @Nullable
    public final Wrap makeWrap$intellij_database_sql_impl(@Nullable Wrap parentWrap, @Nullable WrapType wrapType, boolean wrapFirst) {
        if (wrapType == null || wrapType == WrapType.NONE) {
            return null;
        }
        if (wrapType == WrapType.ALWAYS) {
            return Wrap.createWrap((WrapType)wrapType, (boolean)wrapFirst);
        }
        Wrap wrap = parentWrap;
        if (wrap == null) {
            wrap = this.getParent().getTransitiveWrap();
        }
        Wrap pw = wrap;
        return pw != null ? Wrap.createChildWrap((Wrap)pw, (WrapType)wrapType, (boolean)wrapFirst) : Wrap.createWrap((WrapType)wrapType, (boolean)wrapFirst);
    }

    @Nullable
    public static /* synthetic */ Wrap makeWrap$intellij_database_sql_impl$default(SqlFlowBlock sqlFlowBlock, Wrap wrap, WrapType wrapType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeWrap");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return sqlFlowBlock.makeWrap$intellij_database_sql_impl(wrap, wrapType, bl);
    }

    public boolean userBreakFirstElement() {
        return this.userElementsLineSetting() == 101;
    }

    public int userElementsLineSetting() {
        return 0;
    }

    @SqlCodeStyleConst.WrapMagicValues
    public int userWrapSetting() {
        return 0;
    }

    @SqlCodeStyleConst.CommaMagicValues
    public int userDelimiterSetting() {
        return 0;
    }

    public boolean userRequiresExpand() {
        return this.userWrapSetting() == 1;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Collection collection = this.nestedBlocks;
        return !collection.isEmpty() && Intrinsics.areEqual((Object)this.nestedBlocks.get(0), (Object)block) ? SqlFormattingFunKt.getNONE_INDENT() : SqlFormattingFunKt.getNORMAL_INDENT();
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        this.analyze();
        this.refine();
        int n = this.nestedBlocks.size();
        if (newChildIndex < 0) {
            childAttributes = new ChildAttributes(null, null);
        } else if (newChildIndex == 0) {
            childAttributes = new ChildAttributes(SqlFormattingFunKt.getNONE_INDENT(), null);
        } else if (newChildIndex > n) {
            childAttributes = this.getChildAttributesForNewElementAtTheEnd();
        } else {
            int prevIndex = newChildIndex - 1;
            SqlBlock prev = this.nestedBlocks.get(prevIndex);
            return this.getChildAttributesForNewElementAfter(prevIndex, prev);
        }
        return childAttributes;
    }

    @NotNull
    public ChildAttributes getChildAttributesForNewElementAtTheEnd() {
        SqlFlowBlock sqlFlowBlock;
        SqlBlock b2 = (SqlBlock)CollectionsKt.lastOrNull(this.nestedBlocks);
        SqlBlock sqlBlock = b2;
        if (!(sqlBlock instanceof SqlFlowBlock)) {
            sqlBlock = null;
        }
        if ((sqlFlowBlock = (SqlFlowBlock)sqlBlock) == null || (sqlFlowBlock = sqlFlowBlock.getChildAttributesForNewElementAtTheEnd()) == null) {
            sqlFlowBlock = new ChildAttributes(null, null);
        }
        return sqlFlowBlock;
    }

    @NotNull
    public ChildAttributes getChildAttributesForNewElementAfter(int index2, @NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return new ChildAttributes(SqlFormattingFunKt.getNORMAL_INDENT(), null);
    }

    @Override
    @Nullable
    public final Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child2");
        if (this.getContext().getDisabled()) {
            return null;
        }
        if (child1 != null && child1 instanceof SqlBlock && child2 instanceof SqlBlock) {
            if (child2 instanceof SqlCommentBlock) {
                boolean keep1 = this.getContext().getCom().KEEP_FIRST_COLUMN_COMMENT && this.getContext().isInPosition1(child2);
                return keep1 ? Spacing.createKeepingFirstColumnSpacing((int)0, (int)1, (boolean)true, (int)this.getContext().getSql().IMP_COMMON_KEEP_BLANK_LINES_IN_CODE) : this.getContext().makeSafeSpacing(true);
            }
            if (child1 instanceof SqlCommentBlock) {
                return this.getContext().makeSafeSpacing(true);
            }
            if (((SqlBlock)child1).requiresFollowingBreak() || ((SqlBlock)child2).requiresPrecedingBreak()) {
                SqlLeafBlock leaf1 = ((SqlBlock)child1).getLastLeafBlock();
                SqlLeafBlock leaf2 = ((SqlBlock)child2).getFirstLeafBlock();
                if (leaf1 == null || leaf2 == null) {
                    return this.getContext().makeBreakSafeSpace();
                }
                boolean mustBeLag = SqlSpacing.languageRequiresSpaceBetweenLeafNodes(leaf1.getNode(), leaf2.getNode());
                return this.getContext().makeBreak(mustBeLag);
            }
            return this.decideSpacing$intellij_database_sql_impl((SqlBlock)child1, (SqlBlock)child2);
        }
        return null;
    }

    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        WrapImpl.Type wrapType = SqlFormattingModelFunKt.getType(block2.getMyWrap());
        boolean klb = this.getContext().getKlb() && wrapType != WrapImpl.Type.DO_NOT_WRAP;
        int should = this.shouldBeSpace(block1, block2);
        if (should == 1) {
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, klb, 1, null);
        }
        if (should == -1) {
            return this.getContext().makeNoSpace(klb);
        }
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r1 == BlockRole.ERROR || r2 == BlockRole.ERROR ? this.getContext().makeSafeSpacing(false) : (r2 == BlockRole.AMENDMENT ? this.getContext().makeSafeSpacing(false) : (r1 == BlockRole.UNKNOWN || r2 == BlockRole.UNKNOWN ? this.getContext().makeSafeSpacing(klb) : (wrapType == WrapImpl.Type.WRAP_AS_NEEDED || wrapType == WrapImpl.Type.CHOP_IF_NEEDED ? SqlFormattingContext.makeSpace$default(this.getContext(), false, klb, 1, null) : this.getContext().makeSafeSpacing(klb))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int shouldBeSpace(SqlBlock block1, SqlBlock block2) {
        ASTNode node2;
        SqlLeafBlock leaf1 = block1.getLastLeafBlock();
        SqlLeafBlock leaf2 = block2.getFirstLeafBlock();
        if (leaf1 == null) return 0;
        if (leaf2 == null) {
            return 0;
        }
        ASTNode node1 = leaf1.getBlockNode();
        if (SqlSpacing.languageRequiresSpaceBetween(node1, node2 = leaf2.getBlockNode())) {
            return 1;
        }
        IElementType t1 = leaf1.getElementType();
        IElementType t2 = leaf2.getElementType();
        if (t1 == SqlCommonTokens.SQL_PERIOD) return -1;
        if (t2 == SqlCommonTokens.SQL_PERIOD) {
            return -1;
        }
        if (t1 == SqlCommonTokens.SQL_OP_ASSIGN) return 1;
        if (t2 == SqlCommonTokens.SQL_OP_ASSIGN) {
            return 1;
        }
        if (SqlFormattingFunKt.getRIGHT_BRACE_TOKENS().contains(t1)) {
            if (!(leaf2 instanceof SqlSymbol)) return 1;
            return 0;
        }
        if (t2 == SqlCommonTokens.SQL_OP_PLUS || t2 == SqlCommonTokens.SQL_OP_MINUS) {
            ASTNode aSTNode = node2.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node2.treeParent");
            if (aSTNode.getElementType() == SqlCompositeElementTypes.SQL_UNARY_EXPRESSION && !SqlFormattingFunKt.getLEFT_BRACE_TOKENS().contains(t1)) {
                return 1;
            }
        }
        if (block1 instanceof SqlKeyword && !SqlFormattingFunKt.getUSUALLY_RIGHT_CLOSELY_SPACES_TOKENS().contains(t2)) {
            return 1;
        }
        if (block2 instanceof SqlKeyword && !SqlFormattingFunKt.getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS().contains(t1)) {
            return 1;
        }
        if (!(block2 instanceof SqlCortegeBlock)) return 0;
        if (SqlFormattingFunKt.getUSUALLY_LEFT_CLOSELY_SPACES_TOKENS().contains(t1)) return 0;
        if (!this.getContext().getSql().CORTEGE_SPACE_BEFORE_L_PAREN) return -1;
        return 1;
    }

    @Override
    public boolean requiresFollowingBreak() {
        SqlLeafBlock sqlLeafBlock = this.getLastLeafBlock();
        return sqlLeafBlock != null ? sqlLeafBlock.requiresFollowingBreak() : false;
    }

    @Override
    public boolean incomplete() {
        boolean bl;
        SqlBlock sqlBlock = (SqlBlock)CollectionsKt.lastOrNull(this.getSubBlocks());
        if (sqlBlock == null) {
            return true;
        }
        SqlBlock last = sqlBlock;
        BlockRole role = last.getRole();
        switch (SqlFlowBlock$WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = last.incomplete();
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        return SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, true, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    protected final void makeDefaultBlocks(@NotNull List<? extends ASTNode> nodes2, int since, int till) {
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int n = since;
        int n2 = till;
        while (n < n2) {
            void i2;
            ASTNode node = nodes2.get((int)i2);
            SqlBlock block = this.makeDefaultBlock(node);
            if (block.getRole() == BlockRole.NOTHING) {
                block.setRole(this.determineRole$intellij_database_sql_impl(node));
            }
            this.addNestedBlock$intellij_database_sql_impl(block);
            ++i2;
        }
    }

    public static /* synthetic */ void makeDefaultBlocks$default(SqlFlowBlock sqlFlowBlock, List list, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeDefaultBlocks");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        sqlFlowBlock.makeDefaultBlocks(list, n, n2);
    }

    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.makeDefaultBlock(node);
    }

    private final SqlBlock makeDefaultBlock(ASTNode node) {
        return SqlFormattingModelFunKt.makeDefaultBlock(this, node);
    }

    @Override
    @Nullable
    public final SqlBlock getFirstNestedBlock() {
        return (SqlBlock)CollectionsKt.firstOrNull(this.nestedBlocks);
    }

    @Override
    @Nullable
    public final SqlBlock getLastNestedBlock() {
        return (SqlBlock)CollectionsKt.lastOrNull(this.nestedBlocks);
    }

    @NotNull
    public final JBIterable<SqlBlock> nestedBlocksIter() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.nestedBlocks);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(nestedBlocks)");
        return jBIterable;
    }

    private SqlFlowBlock() {
        super(null);
    }

    public /* synthetic */ SqlFlowBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

