/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakStringInterner;
import gnu.trove.TByteArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.ConstantFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQNBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.MethodFQN;

public interface FQN {
    public static final FQN INVALID = new ConstantFQN(Collections.emptyList(), new byte[0], false);

    @NotNull
    public String getFullPath();

    @NotNull
    public String getShortName();

    public boolean isToplevel();

    public boolean processNestingResolution(@NotNull Processor<FQN> var1);

    @NotNull
    public FQN getCallerFQN();

    @NotNull
    public List<String> asList();

    @NotNull
    public Stream<String> asStream();

    public static boolean same(@NotNull FQN fqn, @Nullable String fqnAsString) {
        if (fqn == null) {
            FQN.$$$reportNull$$$0(0);
        }
        return fqn.getFullPath().equals(fqnAsString);
    }

    public static FQN of(@NotNull String fqn) {
        if (fqn == null) {
            FQN.$$$reportNull$$$0(1);
        }
        return Builder.fromString(fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "fqn";
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "same";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "of";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Serialization {
        private static final FQNBase.SerializationFactory[] FACTORIES = new FQNBase.SerializationFactory[]{ConstantFQN.SerializationFactory.INSTANCE, MethodFQN.SerializationFactory.INSTANCE};
        private static final Map<FQNBase.SerializationFactory, Integer> FACTORY_TO_ID = new HashMap<FQNBase.SerializationFactory, Integer>();

        public static void serialize(@NotNull FQN fqn, @NotNull StubOutputStream dataStream) throws IOException {
            if (fqn == null) {
                Serialization.$$$reportNull$$$0(0);
            }
            if (dataStream == null) {
                Serialization.$$$reportNull$$$0(1);
            }
            if (fqn == INVALID) {
                dataStream.writeByte(-1);
                return;
            }
            FQNBase.SerializationFactory serializationFactory = ((FQNBase)fqn).getSerializationFactory();
            dataStream.writeByte(FACTORY_TO_ID.get(serializationFactory).intValue());
            serializationFactory.serialize(fqn, dataStream);
        }

        @NotNull
        public static FQN deserialize(@NotNull StubInputStream stream) throws IOException {
            byte b;
            if (stream == null) {
                Serialization.$$$reportNull$$$0(2);
            }
            if ((b = stream.readByte()) == -1) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Serialization.$$$reportNull$$$0(3);
                }
                return fQN;
            }
            FQN fQN = FACTORIES[b].deserialize(stream);
            if (fQN == null) {
                Serialization.$$$reportNull$$$0(4);
            }
            return fQN;
        }

        static {
            for (int i = 0; i < FACTORIES.length; ++i) {
                FACTORY_TO_ID.put(FACTORIES[i], i);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataStream";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Serialization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Serialization";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deserialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deserialize";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Builder {
        @NotNull
        public static FQN create(@NotNull List<String> fqns, boolean isToplevel) {
            if (fqns == null) {
                Builder.$$$reportNull$$$0(0);
            }
            ArrayList<String> splitted = new ArrayList<String>(fqns.size());
            TByteArrayList bytes = new TByteArrayList(fqns.size());
            byte currentColor = 0;
            for (String fqn : fqns) {
                for (String part : StringUtil.split((String)fqn, (String)"::")) {
                    splitted.add(FQNBase.INTERNER.intern(part));
                    bytes.add(currentColor);
                }
                currentColor = (byte)(currentColor + 1);
            }
            ConstantFQN constantFQN = new ConstantFQN(splitted, bytes.toNativeArray(), isToplevel);
            if (constantFQN == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return constantFQN;
        }

        @NotNull
        public static FQN fromString(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (fqn.isEmpty()) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(3);
                }
                return fQN;
            }
            Pair<String, Boolean> fqnAndLeading = Builder.checkLeadingDelimiter(fqn);
            if (((String)fqnAndLeading.getFirst()).isEmpty()) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(4);
                }
                return fQN;
            }
            Pair<String, String> fqnAndMethod = Builder.checkMethodPresence((String)fqnAndLeading.getFirst());
            if (((Boolean)fqnAndLeading.getSecond()).booleanValue() && StringUtil.isEmpty((String)((String)fqnAndMethod.getFirst()))) {
                Logger.getInstance(Builder.class).warn("FQN can't start with :: and have no CONSTANT: " + fqn, new Throwable());
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(5);
                }
                return fQN;
            }
            if (fqnAndMethod.getSecond() != null) {
                if (fqnAndMethod.getFirst() != null) {
                    List<String> names = Builder.splitIncomingFQN((String)fqnAndMethod.getFirst());
                    MethodFQN methodFQN = new MethodFQN(names, ConstantFQN.createSameColors(names.size()), (Boolean)fqnAndLeading.getSecond(), FQNBase.INTERNER.intern((String)fqnAndMethod.getSecond()));
                    if (methodFQN == null) {
                        Builder.$$$reportNull$$$0(6);
                    }
                    return methodFQN;
                }
                MethodFQN methodFQN = new MethodFQN(Collections.emptyList(), ConstantFQN.createSameColors(0), (Boolean)fqnAndLeading.getSecond(), FQNBase.INTERNER.intern((String)fqnAndMethod.getSecond()));
                if (methodFQN == null) {
                    Builder.$$$reportNull$$$0(7);
                }
                return methodFQN;
            }
            List<String> names = Builder.splitIncomingFQN((String)fqnAndLeading.getFirst());
            ConstantFQN constantFQN = new ConstantFQN(names, ConstantFQN.createSameColors(names.size()), (Boolean)fqnAndLeading.getSecond());
            if (constantFQN == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return constantFQN;
        }

        @NotNull
        public static FQN forceConcat(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            if (fqn1 == INVALID) {
                FQN fQN = fqn2;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(11);
                }
                return fQN;
            }
            if (fqn2 == INVALID) {
                FQN fQN = fqn1;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(12);
                }
                return fQN;
            }
            ArrayList<String> newPath = new ArrayList<String>(Builder.getRawPath(fqn1));
            newPath.addAll(Builder.getRawPath(fqn2));
            byte[] newColors = Builder.concatColors(fqn1, fqn2);
            if (fqn2 instanceof MethodFQN) {
                MethodFQN methodFQN = new MethodFQN(newPath, newColors, fqn1.isToplevel(), fqn2.getShortName());
                if (methodFQN == null) {
                    Builder.$$$reportNull$$$0(13);
                }
                return methodFQN;
            }
            ConstantFQN constantFQN = new ConstantFQN(newPath, newColors, fqn1.isToplevel());
            if (constantFQN == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return constantFQN;
        }

        @NotNull
        public static FQN concat(@NotNull FQN fqn1, @NotNull String fqnAsString) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            if (fqnAsString == null) {
                Builder.$$$reportNull$$$0(16);
            }
            FQN fQN = Builder.concat(fqn1, Builder.fromString(fqnAsString));
            if (fQN == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return fQN;
        }

        @NotNull
        private static Pair<String, Boolean> checkLeadingDelimiter(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(18);
            }
            if (fqn.startsWith("::")) {
                Pair pair = Pair.create((Object)fqn.substring(2), (Object)true);
                if (pair == null) {
                    Builder.$$$reportNull$$$0(19);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)fqn, (Object)false);
            if (pair == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return pair;
        }

        @NotNull
        private static Pair<String, String> checkMethodPresence(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(21);
            }
            assert (!fqn.isEmpty());
            int i = fqn.lastIndexOf(".");
            if (i != -1) {
                Pair pair = Pair.create((Object)fqn.substring(0, i), (Object)fqn.substring(i + 1));
                if (pair == null) {
                    Builder.$$$reportNull$$$0(22);
                }
                return pair;
            }
            if (Character.isUpperCase(fqn.charAt(0)) || fqn.contains("::") || fqn.startsWith("$$")) {
                Pair pair = Pair.create((Object)fqn, null);
                if (pair == null) {
                    Builder.$$$reportNull$$$0(23);
                }
                return pair;
            }
            Pair pair = Pair.create(null, (Object)fqn);
            if (pair == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return pair;
        }

        @NotNull
        public static FQN concat(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(25);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(26);
            }
            if (fqn1 instanceof MethodFQN) {
                Logger.getInstance(Builder.class).warn("Cannot append anything to method fqn: " + fqn1 + "+" + fqn2 + ". Check caller code.");
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(27);
                }
                return fQN;
            }
            if (fqn2.isToplevel()) {
                FQN fQN = fqn2;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(28);
                }
                return fQN;
            }
            FQN fQN = Builder.forceConcat(fqn1, fqn2);
            if (fQN == null) {
                Builder.$$$reportNull$$$0(29);
            }
            return fQN;
        }

        @NotNull
        private static List<String> splitIncomingFQN(@NotNull String fqnAsString) {
            if (fqnAsString == null) {
                Builder.$$$reportNull$$$0(30);
            }
            List list = ContainerUtil.map((Collection)StringUtil.split((String)fqnAsString, (String)"::"), arg_0 -> ((WeakStringInterner)FQNBase.INTERNER).intern(arg_0));
            if (list == null) {
                Builder.$$$reportNull$$$0(31);
            }
            return list;
        }

        @NotNull
        private static List<String> getRawPath(@NotNull FQN fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(32);
            }
            if (fqn instanceof ConstantFQN) {
                List<String> list = ((ConstantFQN)fqn).getRawPath();
                if (list == null) {
                    Builder.$$$reportNull$$$0(33);
                }
                return list;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                Builder.$$$reportNull$$$0(34);
            }
            return list;
        }

        @NotNull
        private static byte[] concatColors(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(35);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(36);
            }
            byte[] c1 = ((FQNBase)fqn1).getPathColors();
            byte[] c2 = ((FQNBase)fqn2).getPathColors();
            int L1 = c1.length;
            byte[] result = new byte[L1 + c2.length];
            System.arraycopy(c1, 0, result, 0, L1);
            byte delta = L1 == 0 ? (byte)0 : c1[L1 - 1];
            for (int i = 0; i < c2.length; ++i) {
                result[L1 + i] = (byte)(c2[i] + 1 + delta);
            }
            if (result == null) {
                Builder.$$$reportNull$$$0(37);
            }
            return result;
        }

        @NotNull
        public static FQN appendConstant(@NotNull FQN origin, @NotNull FQN constant) {
            if (origin == null) {
                Builder.$$$reportNull$$$0(38);
            }
            if (constant == null) {
                Builder.$$$reportNull$$$0(39);
            }
            if (origin instanceof MethodFQN) {
                MethodFQN methodFQN = (MethodFQN)origin;
                FQN fQN = Builder.concat(Builder.concat(methodFQN.getCallerFQN(), constant), methodFQN.getShortName());
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(40);
                }
                return fQN;
            }
            FQN fQN = Builder.concat(origin, constant);
            if (fQN == null) {
                Builder.$$$reportNull$$$0(41);
            }
            return fQN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 34: 
                case 37: 
                case 40: 
                case 41: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 34: 
                case 37: 
                case 40: 
                case 41: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqns";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 34: 
                case 37: 
                case 40: 
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Builder";
                    break;
                }
                case 2: 
                case 18: 
                case 21: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 9: 
                case 15: 
                case 25: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn1";
                    break;
                }
                case 10: 
                case 26: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn2";
                    break;
                }
                case 16: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqnAsString";
                    break;
                }
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forceConcat";
                    break;
                }
                case 17: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concat";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkLeadingDelimiter";
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkMethodPresence";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitIncomingFQN";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawPath";
                    break;
                }
                case 37: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concatColors";
                    break;
                }
                case 40: 
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendConstant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 34: 
                case 37: 
                case 40: 
                case 41: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "forceConcat";
                    break;
                }
                case 15: 
                case 16: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "concat";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "checkLeadingDelimiter";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMethodPresence";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "splitIncomingFQN";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "getRawPath";
                    break;
                }
                case 35: 
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "concatColors";
                    break;
                }
                case 38: 
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "appendConstant";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 34: 
                case 37: 
                case 40: 
                case 41: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

