/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class LoginPerformer {
    private final Project myProject;
    private final Collection<? extends CvsEnvironment> myRoots;
    private final Consumer<? super VcsException> myExceptionConsumer;
    private boolean myForceCheck;

    public LoginPerformer(Project project, Collection<? extends CvsEnvironment> roots, Consumer<? super VcsException> exceptionConsumer) {
        this.myProject = project;
        this.myRoots = roots;
        this.myExceptionConsumer = exceptionConsumer;
        this.myForceCheck = false;
    }

    public void setForceCheck(boolean forceCheck) {
        this.myForceCheck = forceCheck;
    }

    public boolean loginAll() {
        return this.loginAll(true);
    }

    public boolean loginAll(boolean goOffline) {
        for (CvsEnvironment cvsEnvironment : this.myRoots) {
            CvsLoginWorker worker = cvsEnvironment.getLoginWorker(this.myProject);
            try {
                ThreeState checkResult = LoginPerformer.checkLoginWorker(worker, this.myForceCheck);
                if (ThreeState.YES.equals((Object)checkResult)) continue;
                if (ThreeState.UNSURE.equals((Object)checkResult)) {
                    if (goOffline) {
                        worker.goOffline();
                    }
                    this.myExceptionConsumer.consume((Object)new CvsException("Authentication canceled", cvsEnvironment.getCvsRootAsString()));
                }
                return false;
            }
            catch (AuthenticationException e) {
                this.myExceptionConsumer.consume((Object)new CvsException(e, cvsEnvironment.getCvsRootAsString()));
                return false;
            }
        }
        return true;
    }

    public static ThreeState checkLoginWorker(CvsLoginWorker worker, boolean forceCheckParam) throws AuthenticationException {
        boolean forceCheck = forceCheckParam;
        Ref promptResult = new Ref();
        Runnable prompt = () -> promptResult.set((Object)worker.promptForPassword());
        ThreeState state;
        while (!ThreeState.YES.equals((Object)(state = worker.silentLogin(forceCheck)))) {
            if (ThreeState.NO.equals((Object)state)) {
                return state;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                return ThreeState.NO;
            }
            UIUtil.invokeAndWaitIfNeeded((Runnable)prompt);
            if (!Boolean.TRUE.equals(promptResult.get())) {
                return ThreeState.UNSURE;
            }
            forceCheck = true;
        }
        return ThreeState.YES;
    }
}

