/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousNullOrUndefinedCheck {
    static void checkNullOrUndefinedGuard(@NotNull ProblemsHolder holder, @NotNull JSBinaryExpression binaryExpression, @NotNull IElementType sign, @NotNull JSExpression candidate, @NotNull JSExpression nullOrUndefinedExpression, @NotNull ProblemHighlightType problemHighlightType) {
        if (holder == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(0);
        }
        if (binaryExpression == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(1);
        }
        if (sign == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(2);
        }
        if (candidate == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(3);
        }
        if (nullOrUndefinedExpression == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(4);
        }
        if (problemHighlightType == null) {
            JSSuspiciousNullOrUndefinedCheck.$$$reportNull$$$0(5);
        }
        if (!JSTypeGuardChecker.isNarrowableReference(candidate)) {
            return;
        }
        JSType expressionJSType = JSTypeGuardChecker.getExactType(JSResolveUtil.getElementJSTypeWithInferredDecorators((PsiElement)candidate));
        if (expressionJSType == null) {
            return;
        }
        boolean isEqualCheckToNullOrUndefined = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.EQEQEQ;
        boolean isDoubleEq = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        Set<JSDecoratedType.TypeDecoration> decoratorsToCheck = JSTypeGuardChecker.getDecoratorsForNullOrUndefinedExpression(isDoubleEq, nullOrUndefinedExpression, false);
        if (decoratorsToCheck.isEmpty()) {
            return;
        }
        if (!TypeScriptTypeRelations.hasExplicitDecorators(expressionJSType, decoratorsToCheck)) {
            return;
        }
        boolean isNullable = JSSuspiciousNullOrUndefinedCheck.isNullableUndefinedType(expressionJSType, decoratorsToCheck);
        if (isNullable) {
            return;
        }
        boolean value = !isEqualCheckToNullOrUndefined;
        holder.registerProblem((PsiElement)binaryExpression, value ? JSBundle.message((String)"javascript.true.null.or.undefined.guard", (Object[])new Object[0]) : JSBundle.message((String)"javascript.false.null.or.undefined.guard", (Object[])new Object[0]), problemHighlightType, JSSuspiciousTypeUtil.getSimplifyFixes((JSExpression)binaryExpression, !value));
    }

    private static boolean isNullableUndefinedType(@Nullable JSType expressionJSType, Set<JSDecoratedType.TypeDecoration> expectedDecorators) {
        JSTypeCastUtil.NullableState state = JSTypeCastUtil.getNullableState(expressionJSType);
        if (expectedDecorators.contains(JSDecoratedType.TypeDecoration.INFERRED_NOTNULL) && state.hasNull()) {
            return true;
        }
        return expectedDecorators.contains(JSDecoratedType.TypeDecoration.INFERRED_NOTUNDEFINED) && state.hasUndefined();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "binaryExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sign";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "candidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "nullOrUndefinedExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "problemHighlightType";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousNullOrUndefinedCheck";
        objectArray[2] = "checkNullOrUndefinedGuard";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

