/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.node;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportNodeJsModuleFix
extends ImportCommonJSModuleFix {
    private String myText;

    public ImportNodeJsModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, @NotNull String quoteString) {
        if (node == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(1);
        }
        if (quoteString == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(2);
        }
        super(node, descriptor2, quoteString);
    }

    @Override
    protected void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        PsiElement last;
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(3);
        }
        if (created == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(4);
        }
        Pair anchor = (last = new LastImportRequireInScope(false).findAndSelect(scope)) != null ? Pair.create((Object)true, (Object)last) : ES6ImportPsiUtil.findPlaceForImport(scope);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, (Pair<Boolean, PsiElement>)anchor, editor);
        if (last instanceof PsiComment) {
            scope.addAfter(CommentsMover.createNewLine(last), last);
        }
    }

    @Override
    protected boolean modifyExistingImports(@NotNull PsiElement scope, Editor editor, @NotNull PsiElement reference) {
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myText == null) {
            String postfix = this.getPostfix();
            StringBuilder builder = new StringBuilder();
            String wholeImportWrapQuote = "'".equals(this.myQuotes) ? "\"" : "'";
            builder.append("Insert ").append(wholeImportWrapQuote).append("require(").append(this.myQuotes).append(this.getPath()).append(this.myQuotes).append(")").append(postfix).append(wholeImportWrapQuote);
            this.myText = builder.toString();
        }
        String string = this.myText;
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.modules.dependencies.missing.family.name", (Object[])new Object[0]);
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String getPostfix() {
        if (this.myFixDescriptor.getTail() == null && !this.myFixDescriptor.isModuleElementIsMissing() && (this.myFixDescriptor.getFirstWordInExportsName() == null || this.myFixDescriptor.getFirstWordInExportsName().equals(this.myFixDescriptor.getFirstWordInFile()))) {
            if ("" == null) {
                ImportNodeJsModuleFix.$$$reportNull$$$0(9);
            }
            return "";
        }
        String postfix = "";
        if (this.myFixDescriptor.getFirstWordInExportsName() != null) {
            postfix = "." + this.myFixDescriptor.getFirstWordInExportsName();
        }
        if (this.myFixDescriptor.getTail() != null) {
            postfix = postfix + "." + StringUtil.join((String[])this.myFixDescriptor.getTail(), (String)".");
        }
        String string = postfix;
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    protected PsiElement createRequire(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(11);
        }
        StringBuilder text = new StringBuilder();
        String[] tail = this.myFixDescriptor.getTail();
        String varName = tail != null ? tail[tail.length - 1] : this.myFixDescriptor.getFirstWordInFile();
        PsiElement element = this.getStartElement();
        boolean isES6 = element != null && ES6CoolRefactoring.isEs6Compatible(element);
        text.append(isES6 ? "const " : "var ").append(varName).append(" = require(").append(this.myQuotes).append(this.getPath()).append(this.myQuotes).append(")");
        String postfix = this.getPostfix();
        text.append(postfix).append(JSCodeStyleSettings.getSemicolon((PsiElement)psiFile));
        PsiFile file2 = ImportNodeJsModuleFix.createDummyFile(psiFile.getProject(), text.toString());
        return file2.getFirstChild();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteString";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertCreatedElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "modifyExistingImports";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequire";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

